/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.monitor;

import java.io.IOException;
import org.modelio.gproject.monitor.GProjectEventType;
import org.modelio.vbasic.files.FileUtils;

public class GProjectEvent {
    public final GProjectEventType type;
    public final String message;
    public final Object subject;
    public final Throwable throwable;

    public GProjectEvent(GProjectEventType type, String message, Object subject, Throwable throwable) {
        this.type = type;
        this.subject = subject;
        this.message = message;
        this.throwable = throwable;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append((Object)this.type);
        if (this.message != null) {
            s.append(": ");
            s.append(this.message);
        }
        if (this.subject != null) {
            s.append(" on '");
            s.append(this.subject.toString());
            s.append("'");
        }
        if (this.throwable != null) {
            s.append(", error =");
            s.append(this.throwable.toString());
        }
        return s.toString();
    }

    public static GProjectEvent buildWarning(Object subject, Throwable e) {
        String msg = e instanceof IOException ? FileUtils.getLocalizedMessage((IOException)((IOException)e)) : (e.getMessage() == null || e.getMessage().isEmpty() ? e.getClass().getSimpleName() : e.getLocalizedMessage());
        GProjectEvent ev = new GProjectEvent(GProjectEventType.WARNING, msg, subject, e);
        return ev;
    }

    public static GProjectEvent buildWarning(Object subject, String message) {
        GProjectEvent ev = new GProjectEvent(GProjectEventType.WARNING, message, subject, null);
        return ev;
    }
}

