/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.monitor;

import java.util.ArrayList;
import java.util.List;
import org.modelio.gproject.monitor.GProjectEvent;
import org.modelio.gproject.monitor.IProjectMonitor;
import org.modelio.vbasic.log.Log;

public class GProjectMonitorSupport {
    private List<IProjectMonitor> monitors = new ArrayList<IProjectMonitor>();

    public void addMonitor(IProjectMonitor m) {
        this.monitors.add(m);
    }

    public void removeMonitor(IProjectMonitor m) {
        this.monitors.remove(m);
    }

    public void fireMonitors(GProjectEvent ev) {
        if (this.monitors.isEmpty()) {
            FallBackMonitor.instance.handleProjectEvent(ev);
        } else {
            for (IProjectMonitor m : this.monitors) {
                m.handleProjectEvent(ev);
            }
        }
    }

    private static class FallBackMonitor
    implements IProjectMonitor {
        public static final FallBackMonitor instance = new FallBackMonitor();

        private FallBackMonitor() {
        }

        @Override
        public void handleProjectEvent(GProjectEvent ev) {
            switch (ev.type) {
                case PART_DOWN: {
                    if (ev.throwable != null) {
                        Log.error((Throwable)ev.throwable);
                        break;
                    }
                    Log.error((String)ev.message);
                    break;
                }
                case WARNING: {
                    if (ev.throwable != null) {
                        Log.warning((Throwable)ev.throwable);
                        break;
                    }
                    Log.warning((String)String.valueOf(ev.message));
                    break;
                }
            }
        }
    }
}

