/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.mtools.merge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.modelio.gproject.mtools.merge.DiagramsMerger;
import org.modelio.metamodel.diagrams.AbstractDiagram;
import org.modelio.metamodel.uml.infrastructure.ModelElement;
import org.modelio.metamodel.uml.infrastructure.TagParameter;
import org.modelio.metamodel.uml.infrastructure.TaggedValue;
import org.modelio.metamodel.uml.infrastructure.properties.PropertyTable;
import org.modelio.metamodel.uml.infrastructure.properties.TypedPropertyTable;
import org.modelio.vbasic.log.Log;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.session.impl.CoreSession;
import org.modelio.vcore.smkernel.mapi.MAttribute;
import org.modelio.vcore.smkernel.mapi.MClass;
import org.modelio.vcore.smkernel.mapi.MDependency;
import org.modelio.vcore.smkernel.mapi.MExpert;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.meta.SmAttribute;
import org.modelio.vcore.smkernel.meta.SmClass;
import org.modelio.vcore.smkernel.meta.SmDependency;
import org.modelio.vcore.smkernel.meta.smannotations.SmDirective;

public class MergeMachine {
    private static final boolean TRACE = false;
    private boolean replaceAttributes;
    private boolean deleteNewReflexiveLinks;
    private final MObject target;
    private final ICoreSession coreSession;
    private final Collection<MObject> sources = new HashSet<MObject>(3);
    static Map<Class<? extends MObject>, CustomMerger<? extends MObject>> mergersMap = MergeMachine.initCustomMergers();

    public MergeMachine(MObject target) {
        this.target = Objects.requireNonNull(target, "target");
        this.coreSession = CoreSession.getSession((MObject)target);
    }

    public MergeMachine setDeleteNewReflexiveLinks(boolean deleteNewReflexiveLinks) {
        this.deleteNewReflexiveLinks = deleteNewReflexiveLinks;
        return this;
    }

    public MergeMachine setReplaceAttributes(boolean replaceAttributes) {
        this.replaceAttributes = replaceAttributes;
        return this;
    }

    public MergeMachine addSource(MObject asource) {
        this.sources.add(asource);
        return this;
    }

    public void merge() {
        HashSet diagrams = new HashSet();
        for (MObject source : this.sources) {
            if (source instanceof ModelElement) {
                ModelElement el = (ModelElement)source;
                diagrams.addAll(el.getDiagramElement());
            }
            this.merge(source);
        }
        DiagramsMerger diagramsMerger = new DiagramsMerger();
        for (AbstractDiagram diag : diagrams) {
            if (!diag.isValid()) continue;
            diagramsMerger.fixDiagram(diag, this.sources, this.target);
        }
    }

    private void merge(MObject source) {
        Objects.requireNonNull(source, "original");
        if (source.equals(this.target)) {
            throw new IllegalArgumentException(String.format("Cannot merge %s in itself", source));
        }
        if (CoreSession.getSession((MObject)source) != this.coreSession) {
            throw new IllegalArgumentException(String.format("Cannot merge %s into %s : they belong to different projects.", source, this.target));
        }
        MClass targetMClass = this.target.getMClass();
        SmClass sourceMClass = (SmClass)source.getMClass();
        if (this.replaceAttributes) {
            for (MAttribute att : targetMClass.getAttributes(true)) {
                Object val;
                if (targetMClass != sourceMClass && targetMClass != ((SmAttribute)att).getOwner() && !targetMClass.hasBase((MClass)((SmAttribute)att).getOwner()) || (val = source.mGet(att)) == null) continue;
                if (att.getType() == String.class) {
                    this.target.mSet(att, (Object)val.toString());
                    continue;
                }
                this.target.mSet(att, val);
            }
        }
        for (SmDependency sourceDep : sourceMClass.getAllDepDef()) {
            List origDepContent;
            if (targetMClass != sourceMClass && targetMClass != sourceDep.getSource() && !targetMClass.hasBase(sourceDep.getSource())) continue;
            SmDependency sourceDepSym = sourceDep.getSymetric();
            if (MergeMachine.isNavigable(sourceDep) || sourceDepSym == null) {
                if (sourceDep.getMaxCardinality() == 1 && !this.replaceAttributes || sourceDep.isComposition() && this.mergeCompositionChildrenCustom(source, sourceDep)) continue;
                this.deleteFutureReflexiveLinks(source, sourceDep);
                origDepContent = source.mGet((MDependency)sourceDep);
                List targetDepContent = this.target.mGet((MDependency)sourceDep);
                for (MObject value : new ArrayList(origDepContent)) {
                    origDepContent.remove(value);
                    targetDepContent.add(value);
                    assert (!source.mGet((MDependency)sourceDep).contains(value));
                    assert (this.target.mGet((MDependency)sourceDep).contains(value));
                    assert (sourceDepSym == null || value.mGet((MDependency)sourceDepSym).contains(this.target)) : String.format("%s.%s does not contain %s", value, sourceDepSym, this.target);
                    assert (sourceDepSym == null || !value.mGet((MDependency)sourceDepSym).contains(source)) : String.format("%s.%s still contains %s", value, sourceDepSym, source);
                }
                continue;
            }
            if (sourceDep.isCompositionOpposite()) continue;
            this.deleteFutureReflexiveLinks(source, sourceDep);
            origDepContent = source.mGet((MDependency)sourceDep);
            for (MObject value : new ArrayList(origDepContent)) {
                this.moveNonNavigableDepValue(source, (MDependency)sourceDep, origDepContent, value);
            }
        }
        assert (source.getCompositionChildren().isEmpty()) : String.valueOf(source) + " still owns:" + String.valueOf(source.getCompositionChildren());
        String msg = String.format("  Merged %s into %s.", source, this.target);
        source.delete();
        Log.trace((String)msg);
    }

    private boolean mergeCompositionChildrenCustom(MObject source, SmDependency sourceDep) {
        Class i = sourceDep.getTarget().getJavaInterface();
        CustomMerger<? extends MObject> comparator = mergersMap.get(i);
        if (comparator == null) {
            return false;
        }
        List sourceDepContent = source.mGet((MDependency)sourceDep);
        List targetDepContent = this.target.mGet((MDependency)sourceDep);
        for (MObject sourceValue : new ArrayList(sourceDepContent)) {
            if (!targetDepContent.stream().noneMatch(targetVal -> comparator.run((MObject)targetVal, sourceValue) && this.recurseMerge((MObject)targetVal, sourceValue))) continue;
            sourceDepContent.remove(sourceValue);
            targetDepContent.add(sourceValue);
        }
        return true;
    }

    private boolean recurseMerge(MObject targetVal, MObject sourceValue) {
        new MergeMachine(targetVal).setDeleteNewReflexiveLinks(this.deleteNewReflexiveLinks).setReplaceAttributes(this.replaceAttributes).addSource(sourceValue).merge();
        return true;
    }

    private static Map<Class<? extends MObject>, CustomMerger<? extends MObject>> initCustomMergers() {
        mergersMap = new HashMap<Class<? extends MObject>, CustomMerger<? extends MObject>>();
        MergeMachine.addToMap(TaggedValue.class, MergeMachine::isSameTaggedValue);
        MergeMachine.addToMap(TagParameter.class, MergeMachine::isSameTagParameter);
        MergeMachine.addToMap(PropertyTable.class, MergeMachine::isSamePropertyTable);
        MergeMachine.addToMap(TypedPropertyTable.class, MergeMachine::isSameTypedPropertyTable);
        return mergersMap;
    }

    private static <T extends MObject> void addToMap(Class<T> mc, CustomMerger<T> comparator) {
        mergersMap.put(mc, comparator);
    }

    private static boolean isSameTaggedValue(TaggedValue target, TaggedValue source) {
        if (Objects.equals(target.getDefinition(), source.getDefinition())) {
            if (target.getDefinition().getParamNumber().equals("1")) {
                new ArrayList<TagParameter>((Collection<TagParameter>)source.getActual()).forEach(o -> o.delete());
            }
            return true;
        }
        return false;
    }

    private static boolean isSameTagParameter(TagParameter target, TagParameter source) {
        return Objects.equals(target.getValue(), source.getValue());
    }

    private static boolean isSameTypedPropertyTable(TypedPropertyTable target, TypedPropertyTable source) {
        if (Objects.equals(target.getType(), source.getType())) {
            for (Map.Entry<Object, Object> prop : source.toProperties().entrySet()) {
                String key = (String)prop.getKey();
                if (target.getProperty(key) != null) continue;
                target.setProperty(key, (String)prop.getValue());
            }
            return true;
        }
        return false;
    }

    private static boolean isSamePropertyTable(PropertyTable target, PropertyTable source) {
        if (Objects.equals(target.getName(), source.getName())) {
            for (Map.Entry<Object, Object> prop : source.toProperties().entrySet()) {
                String key = (String)prop.getKey();
                if (target.getProperty(key) != null) continue;
                target.setProperty(key, (String)prop.getValue());
            }
            return true;
        }
        return false;
    }

    private void deleteFutureReflexiveLinks(MObject source, SmDependency sourceDep) {
        if (!this.deleteNewReflexiveLinks) {
            return;
        }
        SmDependency sourceDepSym = sourceDep.getSymetric();
        Collection linkOppositeDeps = null;
        SmClass depTargetType = sourceDep.getType();
        MExpert mmExpert = depTargetType.getMetamodel().getMExpert();
        if (sourceDepSym.hasDirective(SmDirective.SMCDLINKSOURCE)) {
            linkOppositeDeps = depTargetType.getLinkMetaclassTargets();
        } else if (sourceDepSym.hasDirective(SmDirective.SMCDLINKTARGET)) {
            linkOppositeDeps = depTargetType.getLinkMetaclassSources();
        } else {
            return;
        }
        List origDepContent = source.mGet((MDependency)sourceDep);
        for (MObject linkElement : new ArrayList(origDepContent)) {
            boolean noMoreSourceOrTarget = true;
            boolean oppositesWereEmpty = true;
            for (MDependency oppdep : linkOppositeDeps) {
                List oppDepContent = linkElement.mGet(oppdep);
                if (oppDepContent.isEmpty()) continue;
                if (oppDepContent.size() == 1 && oppDepContent.contains(this.target)) {
                    oppositesWereEmpty = false;
                    continue;
                }
                oppositesWereEmpty = false;
                noMoreSourceOrTarget = false;
            }
            if (!noMoreSourceOrTarget || oppositesWereEmpty) continue;
            Log.trace((String)"Merge: Delete %s new reflexive link from %s to %s", (Object[])new Object[]{linkElement, mmExpert.getSource(linkElement), mmExpert.getTarget(linkElement)});
            linkElement.delete();
        }
    }

    private static boolean isNavigable(SmDependency dep) {
        return dep.isComposition() || dep.isSharedComposition() || dep.isPartOf();
    }

    private void moveNonNavigableDepValue(MObject original, MDependency dep, List<MObject> origDepContent, MObject value) {
        MDependency origDepOpposite = dep.getSymetric();
        List origOppositeContent = value.mGet(origDepOpposite);
        int idx = origOppositeContent.indexOf(original);
        if (idx != -1) {
            origDepContent.remove(value);
            origOppositeContent.remove(original);
            if (!origOppositeContent.contains(this.target)) {
                origOppositeContent.add(idx, this.target);
            }
        } else {
            Log.warning((String)"  Warn: %1$s.%2$s contains %3$s but %3$s.%4$s does not contain %1$s, only %5$s.", (Object[])new Object[]{original, dep.getName(), value, origDepOpposite, origOppositeContent});
        }
    }

    static interface CustomMerger<T extends MObject> {
        default public boolean run(MObject target, MObject source) {
            return this.merge(target, source);
        }

        public boolean merge(T var1, T var2);
    }
}

