/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.parts;

import org.modelio.gproject.core.IGPart;
import org.modelio.gproject.core.IGPartState;
import org.modelio.gproject.core.IGProject;
import org.modelio.gproject.data.project.DefinitionScope;
import org.modelio.gproject.data.project.GProjectPartDescriptor;
import org.modelio.gproject.data.project.GProperties;
import org.modelio.gproject.data.project.auth.AuthDescriptor;
import org.modelio.gproject.data.project.auth.InheritedAuthData;
import org.modelio.gproject.parts.GPartState;
import org.modelio.vbasic.auth.IAuthData;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.version.Version;

public abstract class AbstractGPart
implements IGPart {
    private static final String PROP_ISACTIVE = "isActive";
    private static final long serialVersionUID = 1L;
    private final GProjectPartDescriptor descriptor;
    protected final GPartState state;
    private IGProject project;

    protected AbstractGPart(GProjectPartDescriptor descriptor) {
        this.descriptor = descriptor;
        this.state = new GPartState(this);
        if (this.descriptor.getAuth() == null) {
            this.descriptor.setAuth(new AuthDescriptor(null, DefinitionScope.LOCAL));
        }
    }

    protected IAuthData resolveAuthData() {
        IAuthData authData = this.getAuth().getData();
        if (InheritedAuthData.matches((IAuthData)authData)) {
            return this.project.getAuth().getData();
        }
        return authData;
    }

    @Override
    public IGProject getProject() {
        return this.project;
    }

    @Override
    public AuthDescriptor getAuth() {
        return this.descriptor.getAuth();
    }

    @Override
    public String getId() {
        return this.descriptor.getId();
    }

    @Override
    public Version getVersion() {
        return this.descriptor.getVersion();
    }

    @Override
    public GPartState getState() {
        return this.state;
    }

    @Override
    public final GProjectPartDescriptor.GProjectPartType getType() {
        return this.descriptor.getType();
    }

    @Override
    public GProjectPartDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public GProperties getProperties() {
        return this.descriptor.getProperties();
    }

    protected void setProperties(GProperties properties) {
        this.descriptor.setProperties(properties);
    }

    @Override
    public DefinitionScope getDefinitionScope() {
        return this.descriptor.getDefinitionScope();
    }

    @Override
    public boolean isActive() {
        return this.getProperties().getBooleanValue(PROP_ISACTIVE, true);
    }

    @Override
    public void setActive(boolean b) {
        DefinitionScope scope = this.getProperties().getPropertyScope(PROP_ISACTIVE, DefinitionScope.LOCAL);
        this.getProperties().setBooleanProperty(PROP_ISACTIVE, b, scope);
    }

    @Override
    public void install(IGProject aProject, IModelioProgress monitor) throws IGPart.GPartException {
        this.project = aProject;
        if (this.state.sendInstall() != IGPartState.GPartStateEnum.INSTALLED) {
            throw new IGPart.GPartException("Install failed");
        }
    }

    @Override
    public void uninstall(IGProject aProject, IModelioProgress monitor) throws IGPart.GPartException {
        if (this.state.sendUninstall() != IGPartState.GPartStateEnum.UNINSTALLED) {
            throw new IGPart.GPartException("Uninstall failed");
        }
        this.project = null;
    }

    public String toString() {
        return String.format("%s [id='%s', version='%s', type='%s', definitionScope='%s', state='%s']", new Object[]{this.getClass().getSimpleName(), this.getId(), this.getVersion(), this.getType(), this.getDefinitionScope(), this.getState().getValue()});
    }
}

