/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.parts;

import java.util.ArrayList;
import java.util.List;
import org.modelio.gproject.core.IGPart;
import org.modelio.gproject.core.IGPartFactory;
import org.modelio.gproject.data.project.GProjectPartDescriptor;
import org.modelio.gproject.parts.feature.GFeature;
import org.modelio.gproject.parts.fragment.GConferenceFragment;
import org.modelio.gproject.parts.fragment.GExmlFragment;
import org.modelio.gproject.parts.fragment.GHttpFragment;
import org.modelio.gproject.parts.fragment.GRamcFragment;
import org.modelio.gproject.parts.fragment.GUnknownFragment;
import org.modelio.gproject.parts.module.GModule;
import org.modelio.gproject.parts.resource.GResource;

public class GPartFactory
implements IGPartFactory {
    private static final List<IGPartFactory> FACTORIES = new ArrayList<IGPartFactory>();
    private static final GPartFactory INSTANCE = new GPartFactory();
    private static final IGPartFactory DEFAULT_FACTORY = new IGPartFactory(){

        @Override
        public IGPart instantiate(GProjectPartDescriptor d) {
            switch (d.getType()) {
                case EXMLFRAGMENT: {
                    return new GExmlFragment(d);
                }
                case HTTPFRAGMENT: {
                    return new GHttpFragment(d);
                }
                case RAMC: {
                    return new GRamcFragment(d);
                }
                case MODULE: {
                    return new GModule(d);
                }
                case FEATURE: {
                    return new GFeature(d);
                }
                case RESOURCE: {
                    return new GResource(d);
                }
                case CONFERENCEFRAGMENT: {
                    return new GConferenceFragment(d);
                }
            }
            return null;
        }

        @Override
        public boolean supports(GProjectPartDescriptor d) {
            switch (d.getType()) {
                case EXMLFRAGMENT: 
                case HTTPFRAGMENT: 
                case RAMC: 
                case MODULE: 
                case FEATURE: 
                case RESOURCE: 
                case CONFERENCEFRAGMENT: {
                    return true;
                }
            }
            return false;
        }
    };

    static {
        FACTORIES.add(DEFAULT_FACTORY);
    }

    private GPartFactory() {
    }

    public static GPartFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public IGPart instantiate(GProjectPartDescriptor d) {
        for (IGPartFactory f : FACTORIES) {
            if (!f.supports(d)) continue;
            return f.instantiate(d);
        }
        return new GUnknownFragment(d);
    }

    @Override
    public boolean supports(GProjectPartDescriptor d) {
        for (IGPartFactory f : FACTORIES) {
            if (!f.supports(d)) continue;
            return true;
        }
        return false;
    }

    public static void registerFactory(IGPartFactory factory) {
        FACTORIES.add(0, factory);
    }

    public static void unregisterFactory(IGPartFactory factory) {
        FACTORIES.remove(factory);
    }
}

