/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.parts;

import org.modelio.gproject.core.IGPart;
import org.modelio.gproject.core.IGPartState;
import org.modelio.gproject.monitor.GProjectEvent;
import org.modelio.gproject.monitor.GProjectEventType;
import org.modelio.vbasic.log.Log;

public class GPartState
implements IGPartState {
    private IGPartState.GPartStateEnum currentState;
    private Throwable downError = null;
    private final IGPart part;

    public GPartState(IGPart part) {
        this.part = part;
        this.currentState = IGPartState.GPartStateEnum.INSTANTIATED;
    }

    @Override
    public Throwable getDownError() {
        return this.downError;
    }

    @Override
    public IGPartState.GPartStateEnum getValue() {
        return this.currentState;
    }

    public IGPartState.GPartStateEnum sendDown(Throwable error) {
        IGPartState.GPartStateEnum initialState = this.currentState;
        switch (this.currentState) {
            case DOWN: {
                return this.currentState;
            }
            case INSTALLED: 
            case MOUNTING: 
            case MOUNTED: {
                this.currentState = IGPartState.GPartStateEnum.DOWN;
                this.downError = error;
                break;
            }
            default: {
                this.currentState = IGPartState.GPartStateEnum.DOWN;
                this.downError = error;
                IllegalStateException e = new IllegalStateException(String.format("'%s' part Down transition not allowed from state '%s'", new Object[]{this.part.getId(), this.currentState}));
                Log.trace((Throwable)e);
            }
        }
        String tm = this.getTransitionMessage("Down", initialState, this.currentState);
        this.fireMonitors(new GProjectEvent(GProjectEventType.PART_DOWN, tm, this.part, error));
        return this.currentState;
    }

    public IGPartState.GPartStateEnum sendEndMount(Throwable error) throws IGPart.GPartException {
        return error == null ? this.endMountOK() : this.endMountKO(error);
    }

    private IGPartState.GPartStateEnum endMountKO(Throwable error) throws IllegalStateException {
        IGPartState.GPartStateEnum initialState = this.currentState;
        switch (this.currentState) {
            case MOUNTING: {
                this.currentState = IGPartState.GPartStateEnum.DOWN;
                this.downError = error;
                break;
            }
            default: {
                throw new IllegalStateException(String.format("'%s' part EndMount transition not allowed from state '%s'", new Object[]{this.part.getId(), this.currentState}));
            }
        }
        String tm = this.getTransitionMessage("EndMountFail", initialState, this.currentState);
        this.fireMonitors(new GProjectEvent(GProjectEventType.PART_DOWN, tm, this.part, this.downError));
        return this.currentState;
    }

    private IGPartState.GPartStateEnum endMountOK() throws IllegalStateException {
        IGPartState.GPartStateEnum initialState = this.currentState;
        switch (this.currentState) {
            case MOUNTING: {
                this.currentState = IGPartState.GPartStateEnum.MOUNTED;
                this.downError = null;
                break;
            }
            default: {
                throw new IllegalStateException(String.format("'%s' part EndMount transition not allowed from state '%s'", new Object[]{this.part.getId(), this.currentState}));
            }
        }
        String tm = this.getTransitionMessage("EndMountSuccess", initialState, this.currentState);
        this.fireMonitors(new GProjectEvent(GProjectEventType.PART_ADDED, tm, this.part, null));
        return this.currentState;
    }

    public IGPartState.GPartStateEnum sendInstall() throws IllegalStateException {
        IGPartState.GPartStateEnum initialState = this.currentState;
        switch (this.currentState) {
            case INSTANTIATED: 
            case UNINSTALLED: {
                this.currentState = IGPartState.GPartStateEnum.INSTALLED;
                break;
            }
            default: {
                throw new IllegalStateException(String.format("'%s' part Install transition not allowed from state '%s'", new Object[]{this.part.getId(), this.currentState}));
            }
        }
        String tm = this.getTransitionMessage("Install", initialState, this.currentState);
        this.fireMonitors(new GProjectEvent(GProjectEventType.PART_INSTALLED, tm, this.part, null));
        return this.currentState;
    }

    public IGPartState.GPartStateEnum sendStartMount() throws IllegalStateException {
        IGPartState.GPartStateEnum initialState = this.currentState;
        switch (this.currentState) {
            case INSTALLED: 
            case DOWN: {
                this.currentState = IGPartState.GPartStateEnum.MOUNTING;
                break;
            }
            default: {
                throw new IllegalStateException(String.format("'%s' part StartMount transition not allowed from state '%s'", new Object[]{this.part.getId(), this.currentState}));
            }
        }
        String tm = this.getTransitionMessage("StartMount", initialState, this.currentState);
        this.fireMonitors(new GProjectEvent(GProjectEventType.PART_INSTALLED, tm, this.part, null));
        return this.currentState;
    }

    public IGPartState.GPartStateEnum sendUninstall() throws IllegalStateException {
        IGPartState.GPartStateEnum initialState = this.currentState;
        switch (this.currentState) {
            case INSTANTIATED: 
            case INSTALLED: 
            case DOWN: {
                this.currentState = IGPartState.GPartStateEnum.UNINSTALLED;
                break;
            }
            default: {
                throw new IllegalStateException(String.format("'%s' part Uninstall transition not allowed from state '%s'", new Object[]{this.part.getId(), this.currentState}));
            }
        }
        String tm = this.getTransitionMessage("Uninstall", initialState, this.currentState);
        this.fireMonitors(new GProjectEvent(GProjectEventType.PART_UNINSTALLED, tm, this.part, null));
        return this.currentState;
    }

    public IGPartState.GPartStateEnum sendUnmount() throws IllegalStateException {
        IGPartState.GPartStateEnum initialState = this.currentState;
        switch (this.currentState) {
            case INSTALLED: 
            case MOUNTED: 
            case DOWN: {
                this.currentState = IGPartState.GPartStateEnum.INSTALLED;
                break;
            }
            default: {
                throw new IllegalStateException(String.format("'%s' part Unmount transition not allowed from state '%s'", new Object[]{this.part.getId(), this.currentState}));
            }
        }
        String tm = this.getTransitionMessage("Unmount", initialState, this.currentState);
        this.fireMonitors(new GProjectEvent(GProjectEventType.PART_UNINSTALLED, tm, this.part, null));
        return this.currentState;
    }

    @Override
    public void setDownError(Throwable e) throws IllegalStateException {
        if (this.currentState != IGPartState.GPartStateEnum.DOWN) {
            IllegalStateException e2 = new IllegalStateException(String.format("'%s' part is not down but '%s'.", new Object[]{this.part.getId(), this.currentState}));
            e2.addSuppressed(e);
            throw e2;
        }
        this.downError = e;
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append(this.getClass().getSimpleName()).append(" [part='").append(this.part.getType()).append(' ').append(this.part.getId()).append("', currentState='").append((Object)this.currentState).append('\'');
        if (this.downError != null) {
            s.append(", downError='").append(this.downError.toString()).append('\'');
        }
        s.append(']');
        return s.toString();
    }

    private void fireMonitors(GProjectEvent ev) {
        if (this.part.getProject() != null) {
            this.part.getProject().getMonitorSupport().fireMonitors(ev);
        }
    }

    private String getTransitionMessage(String transitionName, IGPartState.GPartStateEnum initialState, IGPartState.GPartStateEnum outputState) {
        return String.format("GPartState %s '%s': %s(%s) => %s", new Object[]{this.part.getType(), this.part.getId(), transitionName, initialState, outputState});
    }
}

