/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.parts.fragment;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.modelio.gproject.FragmentAuthenticationException;
import org.modelio.gproject.FragmentConflictException;
import org.modelio.gproject.FragmentMigrationNeededException;
import org.modelio.gproject.auth.AuthReconfigurer;
import org.modelio.gproject.core.IGAccessRights;
import org.modelio.gproject.core.IGModelFragment;
import org.modelio.gproject.core.IGPart;
import org.modelio.gproject.core.IGPartState;
import org.modelio.gproject.core.IGProject;
import org.modelio.gproject.core.IGProjectState;
import org.modelio.gproject.data.project.GProjectPartDescriptor;
import org.modelio.gproject.data.project.GProperties;
import org.modelio.gproject.monitor.GProjectEvent;
import org.modelio.gproject.parts.AbstractGPart;
import org.modelio.gproject.parts.GPartAccessRights;
import org.modelio.gproject.parts.GPartFactory;
import org.modelio.gproject.parts.IGModelFragmentMigrator;
import org.modelio.gproject.parts.fragment.VersionHelper;
import org.modelio.gproject.plugin.CoreProject;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vbasic.version.Version;
import org.modelio.vcore.model.spi.mm.MmVersionComparator;
import org.modelio.vcore.session.api.IAccessManager;
import org.modelio.vcore.session.api.repository.IRepository;
import org.modelio.vcore.session.api.repository.IRepositoryErrorListener;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MetamodelVersionDescriptor;
import org.modelio.vcore.smkernel.meta.SmMetamodel;

public abstract class AbstractGModelFragment
extends AbstractGPart
implements IGModelFragment {
    protected static final String FRAGMENTS_SUBDIR = "fragments";
    protected static final String MMVERSION_FILE_NAME = "mmversion.dat";
    protected String encodedDirectoryName;
    private final Object stateLock = new Object();
    private IRepositoryErrorListener errSupport;
    private IGAccessRights accessRights;

    protected AbstractGModelFragment(GProjectPartDescriptor desc) {
        super(desc);
        this.encodedDirectoryName = FileUtils.encodeFileName((String)this.getId(), (StringBuilder)new StringBuilder()).toString();
        this.accessRights = new GPartAccessRights(this.getProperties());
    }

    @Override
    public final void install(IGProject aProject, IModelioProgress monitor) throws IGPart.GPartException {
        super.install(aProject, monitor);
        this.doInstall(aProject, monitor);
    }

    protected abstract void doInstall(IGProject var1, IModelioProgress var2) throws IGPart.GPartException;

    @Override
    public final void uninstall(IGProject project, IModelioProgress monitor) throws IGPart.GPartException {
        this.doUninstall(project, monitor);
        super.uninstall(project, monitor);
        try {
            this.delete(project, monitor);
        }
        catch (IOException e) {
            throw new IGPart.GPartException(FileUtils.getLocalizedMessage((IOException)e), e);
        }
    }

    protected abstract void doUninstall(IGProject var1, IModelioProgress var2) throws IGPart.GPartException;

    @Override
    public void rename(String name, IModelioProgress aMonitor) throws IOException, IGPart.GPartException {
        if (Objects.equals(this.getId(), name)) {
            return;
        }
        IGProject project = this.getProject();
        String newEncodedDirectoryName = FileUtils.encodeFileName((String)name, (StringBuilder)new StringBuilder()).toString();
        Path newDataDirectory = project.getPfs().getProjectDataPath().resolve(FRAGMENTS_SUBDIR).resolve(newEncodedDirectoryName);
        GProjectPartDescriptor descriptor = this.getDescriptor();
        boolean isPermanent = project.getDescriptor().getPartDescriptors().contains(descriptor);
        Path oldDataDirectory = this.getDataDirectory();
        Files.move(oldDataDirectory, newDataDirectory, new CopyOption[0]);
        SubProgress mon = SubProgress.convert((IModelioProgress)aMonitor, (int)2);
        project.removeGPart((IModelioProgress)mon.newChild(1), this);
        try {
            descriptor.setId(name);
            this.encodedDirectoryName = newEncodedDirectoryName;
            project.addGPart((IModelioProgress)mon.newChild(1), this, isPermanent);
        }
        catch (FragmentConflictException e) {
            project.getMonitorSupport().fireMonitors(GProjectEvent.buildWarning((Object)this, e));
            try {
                project.addGPart((IModelioProgress)mon.newChild(1), this, isPermanent);
            }
            catch (FragmentConflictException e1) {
                e1.addSuppressed(e);
                this.setDown(e1);
            }
        }
    }

    @Override
    public final void mount(IModelioProgress aMonitor) throws IGPart.GPartException {
        IGPartState.GPartStateEnum stateValue = this.state.getValue();
        if (stateValue != IGPartState.GPartStateEnum.INSTALLED && stateValue != IGPartState.GPartStateEnum.DOWN) {
            throw new IGPart.GPartException("Mount failed, invalid part state " + String.valueOf((Object)stateValue));
        }
        try {
            this.state.sendStartMount();
            SubProgress mon = SubProgress.convert((IModelioProgress)aMonitor, (int)90);
            IGProject project = this.getProject();
            IRepository repository = this.doMountInitRepository(project, (IModelioProgress)mon.newChild(30));
            this.checkVersions();
            this.errSupport = new RepositoryErrorListener(this);
            repository.getErrorSupport().addErrorListener(this.errSupport);
            IAccessManager accessManager = this.doInitAccessManager();
            project.getSession().getRepositorySupport().connectRepository(repository, this.getId(), accessManager, (IModelioProgress)mon.newChild(30));
            this.doMountPostConnect((IModelioProgress)mon.newChild(30));
            this.state.sendEndMount(null);
        }
        catch (IOException | RuntimeException | FragmentAuthenticationException | FragmentMigrationNeededException e) {
            this.state.sendEndMount(e);
            throw new IGPart.GPartException(e);
        }
    }

    @Override
    public final void unmount(IModelioProgress monitor) throws IGPart.GPartException {
        IGProject project = this.getProject();
        IRepository repository = this.getRepository();
        if (repository != null) {
            if (repository.isOpen()) {
                project.getSession().getRepositorySupport().disconnectRepository(repository, this.isProjectBeingClosed(project));
            }
            repository.getErrorSupport().removeErrorListener(this.errSupport);
        }
        try {
            this.doUmountPostProcess(project, monitor);
        }
        catch (IOException e) {
            project.getMonitorSupport().fireMonitors(GProjectEvent.buildWarning((Object)this, e));
        }
        this.state.sendUnmount();
    }

    private boolean isProjectBeingClosed(IGProject project) {
        return project.getState().getValue() == IGProjectState.GProjectStateEnum.CLOSING;
    }

    public final void setDown(Throwable error) {
        assert (error != null);
        if (this.state.getValue() == IGPartState.GPartStateEnum.DOWN) {
            return;
        }
        IGProject project = this.getProject();
        IRepository repository = this.getRepository();
        if (repository != null) {
            if (repository.isOpen()) {
                project.getSession().getRepositorySupport().disconnectRepository(repository, this.isProjectBeingClosed(project));
            }
            repository.getErrorSupport().removeErrorListener(this.errSupport);
        }
        try {
            this.doUmountPostProcess(project, null);
        }
        catch (IOException | RuntimeException e) {
            project.getMonitorSupport().fireMonitors(GProjectEvent.buildWarning((Object)this, e));
        }
        this.state.sendDown(error);
    }

    protected final SmMetamodel getProjectMetamodel() {
        return this.getProject().getSession().getMetamodel();
    }

    protected void doUmountPostProcess(IGProject project, IModelioProgress monitor) throws IOException {
    }

    protected abstract IRepository doMountInitRepository(IGProject var1, IModelioProgress var2) throws IOException, FragmentAuthenticationException;

    protected abstract IAccessManager doInitAccessManager();

    protected void doMountPostConnect(IModelioProgress mon) throws IOException {
    }

    @Override
    public final Path getDataDirectory() {
        IGProject project = this.getProject();
        if (project == null) {
            throw new IllegalArgumentException("This fragment is not in a project");
        }
        return this.getDataDirectory(project);
    }

    protected final Path getDataDirectory(IGProject project) {
        return project.getPfs().getProjectDataPath().resolve(FRAGMENTS_SUBDIR).resolve(this.encodedDirectoryName);
    }

    protected final void delete(IGProject project, IModelioProgress monitor) throws IOException, IGPart.GPartException {
        if (this.state.getValue() != IGPartState.GPartStateEnum.UNINSTALLED) {
            throw new IGPart.GPartException("Delete failed");
        }
        this.doDelete(project, monitor);
        FileUtils.delete((Path)this.getRuntimeDirectory(project));
        FileUtils.delete((Path)this.getDataDirectory(project));
    }

    protected void doDelete(IGProject project, IModelioProgress monitor) {
    }

    @Override
    public final Path getRuntimeDirectory() {
        IGProject project = this.getProject();
        if (project == null) {
            throw new IllegalArgumentException("This fragment is not in a project");
        }
        return this.getRuntimeDirectory(project);
    }

    protected final Path getRuntimeDirectory(IGProject project) {
        return project.getPfs().getProjectRuntimePath().resolve(FRAGMENTS_SUBDIR).resolve(this.encodedDirectoryName);
    }

    protected final MetamodelVersionDescriptor getCurrentMmDescriptor() {
        return VersionHelper.getDescriptors((MMetamodel)this.getProjectMetamodel());
    }

    @Override
    public final Collection<MObject> getRoots() {
        IRepository repository = this.getRepository();
        if (repository == null || !repository.isOpen()) {
            return Collections.emptyList();
        }
        try {
            return this.doGetRoots().stream().filter(o -> o.isValid()).collect(Collectors.toList());
        }
        catch (IOException e) {
            this.setDown(e);
            return Collections.emptyList();
        }
    }

    protected abstract Collection<MObject> doGetRoots() throws IOException;

    @Override
    public IGModelFragmentMigrator getMigrator(MetamodelVersionDescriptor targetMetamodel) throws IOException {
        return null;
    }

    @Override
    public void reconfigure(GProjectPartDescriptor desc, IModelioProgress aMonitor) throws IGPart.GPartException {
        GProjectPartDescriptor currentDescriptor = this.getDescriptor();
        if (Objects.equals(currentDescriptor.getLocation(), desc.getLocation())) {
            boolean isMount = this.getState().getValue() == IGPartState.GPartStateEnum.MOUNTED;
            SubProgress mon = SubProgress.convert((IModelioProgress)aMonitor, (int)2);
            if (isMount) {
                this.unmount((IModelioProgress)mon.newChild(1));
            }
            currentDescriptor.setDefinitionScope(desc.getDefinitionScope());
            this.setProperties(new GProperties(desc.getProperties()));
            AuthReconfigurer.reconfigure(this.getAuth(), desc.getAuth());
            if (isMount) {
                mon.setWorkRemaining(1);
                this.mount((IModelioProgress)mon);
            }
        } else {
            this.removeAndRecreateFragment(desc, aMonitor);
        }
        this.accessRights = new GPartAccessRights(this.getProperties());
    }

    protected void removeAndRecreateFragment(GProjectPartDescriptor desc, IModelioProgress aMonitor) throws IGPart.GPartException {
        SubProgress mon = SubProgress.convert((IModelioProgress)aMonitor, (int)4);
        IGProject currentProject = this.getProject();
        currentProject.removeGPart((IModelioProgress)mon.newChild(1), this);
        IGPart fragment = GPartFactory.getInstance().instantiate(desc);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (UndoableDeletion back = new UndoableDeletion();){
                back.sendToTrash(this.getRuntimeDirectory(currentProject), this.getDataDirectory(currentProject));
                this.delete(currentProject, (IModelioProgress)mon.newChild(1));
                currentProject.addGPart((IModelioProgress)mon.newChild(1), fragment, true);
                back.allowDelete();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | RuntimeException | FragmentConflictException e) {
            currentProject.getMonitorSupport().fireMonitors(GProjectEvent.buildWarning((Object)fragment, e));
            try {
                currentProject.addGPart((IModelioProgress)mon.newChild(1), this, true);
            }
            catch (FragmentConflictException e1) {
                e1.addSuppressed(e);
                this.setDown(e);
            }
        }
    }

    protected void checkVersions() throws IOException, FragmentMigrationNeededException {
        MetamodelVersionDescriptor neededMm = this.getRequiredMetamodelDescriptor();
        MetamodelVersionDescriptor currentMm = this.getCurrentMmDescriptor();
        MmVersionComparator comparator = MmVersionComparator.withSource((MetamodelVersionDescriptor)neededMm).withTarget(currentMm);
        if (!comparator.isTargetCompatible(false)) {
            IGModelFragmentMigrator migrator = this.getMigrator(currentMm);
            if (migrator != null) {
                throw new FragmentMigrationNeededException(this, currentMm);
            }
            if (!comparator.withMissingSourcesRemoved().isTargetCompatible(true)) {
                Collection checkRes = currentMm.getIncompatibilities(neededMm, false);
                throw new IOException(this.compileErrors(checkRes, currentMm));
            }
        }
    }

    private String compileErrors(Collection<MetamodelVersionDescriptor.Difference> checkRes, MetamodelVersionDescriptor currentMm) {
        String msg = checkRes.stream().map(entry -> {
            String fragName = entry.neededMmFragment.getName();
            Version fragVersion = entry.neededMmFragment.getVersion();
            switch (entry.type) {
                case older: {
                    return CoreProject.I18N.getMessage("AbstractFragment.MmVersionNotSupported", new Object[]{this.getId(), fragName, fragVersion, currentMm.getVersion(fragName)});
                }
                case missing: {
                    return CoreProject.I18N.getMessage("AbstractFragment.MissingMetamodelFragment", new Object[]{this.getId(), fragName, fragVersion});
                }
                case newer: {
                    return CoreProject.I18N.getMessage("AbstractFragment.FutureMmVersion", new Object[]{this.getId(), fragName, fragVersion, currentMm.getVersion(fragName)});
                }
                case olderCompatibleBuild: {
                    return CoreProject.I18N.getMessage("AbstractFragment.CompatibleMmVersion", new Object[]{this.getId(), fragName, fragVersion, currentMm.getVersion(fragName)});
                }
            }
            return null;
        }).filter(s -> s != null).collect(Collectors.joining(", \n"));
        return msg;
    }

    @Override
    public IGAccessRights getAccessRights() {
        return this.accessRights;
    }

    private static class RepositoryErrorListener
    implements IRepositoryErrorListener {
        private AbstractGModelFragment modelFragment;

        public RepositoryErrorListener(AbstractGModelFragment fragment) {
            this.modelFragment = fragment;
        }

        public void onWarning(IRepository repository, Throwable e) {
            this.modelFragment.getProject().getMonitorSupport().fireMonitors(GProjectEvent.buildWarning((Object)this.modelFragment, e));
        }

        public void onError(IRepository repository, Throwable e) {
            this.modelFragment.setDown(e);
        }
    }

    protected static class UndoableDeletion
    implements Closeable {
        private boolean doDelete;
        private List<Path> toDelete;
        private List<Path> backup;

        public void sendToTrash(Path ... pathsToDelete) throws IOException {
            this.toDelete = new ArrayList<Path>(pathsToDelete.length);
            this.backup = new ArrayList<Path>(pathsToDelete.length);
            Path[] pathArray = pathsToDelete;
            int n = pathsToDelete.length;
            int n2 = 0;
            while (n2 < n) {
                Path path = pathArray[n2];
                if (path != null && Files.exists(path, new LinkOption[0])) {
                    Path backupPath = path.resolveSibling("_" + String.valueOf(path.getFileName()) + ".bak");
                    FileUtils.delete((Path)backupPath);
                    FileUtils.move((Path)path, (Path)backupPath);
                    this.backup.add(backupPath);
                    this.toDelete.add(path);
                }
                ++n2;
            }
        }

        public void allowDelete() {
            this.doDelete = true;
        }

        @Override
        public void close() throws IOException {
            if (this.doDelete) {
                for (Path element : this.backup) {
                    try {
                        FileUtils.delete((Path)element);
                    }
                    catch (IOException e) {
                        GProjectEvent.buildWarning((Object)element, e);
                    }
                }
            } else {
                this.restore();
            }
        }

        private void restore() throws IOException {
            int i = 0;
            while (i < this.backup.size()) {
                Path toRestore = this.backup.get(i);
                FileUtils.move((Path)toRestore, (Path)this.toDelete.get(i));
                ++i;
            }
        }
    }
}

