/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.parts.fragment;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Properties;
import org.modelio.gproject.FragmentAuthenticationException;
import org.modelio.gproject.FragmentMigrationNeededException;
import org.modelio.gproject.core.IGPart;
import org.modelio.gproject.core.IGProject;
import org.modelio.gproject.data.project.GProjectPartDescriptor;
import org.modelio.gproject.data.project.IFragmentInfos;
import org.modelio.gproject.migration.FragmentMigratorWithBackup;
import org.modelio.gproject.parts.IGModelFragmentMigrator;
import org.modelio.gproject.parts.fragment.AbstractGModelFragment;
import org.modelio.gproject.parts.fragment.VersionHelper;
import org.modelio.gproject.parts.fragment.migration.ChainedExmlFragmentMigrator;
import org.modelio.gproject.plugin.CoreProject;
import org.modelio.metamodel.uml.infrastructure.AbstractProject;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.version.Version;
import org.modelio.vcore.session.api.IAccessManager;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.session.api.repository.IRepository;
import org.modelio.vcore.session.impl.permission.BasicAccessManager;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MetamodelVersionDescriptor;
import org.modelio.vcore.smkernel.meta.SmMetamodel;
import org.modelio.version.ModelioVersion;
import org.modelio.vstore.exml.common.RepositoryVersions;
import org.modelio.vstore.exml.local.ExmlBase;
import org.modelio.vstore.exml.resource.IExmlResourceProvider;
import org.modelio.vstore.exml.resource.LocalExmlResourceProvider;

public class GExmlFragment
extends AbstractGModelFragment {
    private ExmlBase repository;

    public GExmlFragment(GProjectPartDescriptor desc) {
        super(desc);
    }

    @Override
    public GProjectPartDescriptor getDescriptor() {
        return super.getDescriptor();
    }

    @Override
    public IRepository getRepository() {
        return this.repository;
    }

    @Override
    protected IRepository doMountInitRepository(IGProject project, IModelioProgress aMonitor) throws IOException, FragmentAuthenticationException {
        Path location = this.getDataDirectory();
        LocalExmlResourceProvider resProvider = this.createResourceProvider();
        this.repository = new ExmlBase((IExmlResourceProvider)resProvider);
        if (!Files.isDirectory(location, new LinkOption[0])) {
            this.repository.create((MMetamodel)project.getSession().getMetamodel());
            this.saveMmVersion(this.getCurrentMmDescriptor());
        }
        return this.repository;
    }

    public IRepository instantiateRepository(ICoreSession session) throws IOException, FragmentAuthenticationException {
        LocalExmlResourceProvider resProvider = this.createResourceProvider();
        ExmlBase ret = new ExmlBase((IExmlResourceProvider)resProvider);
        Path location = this.getDataDirectory();
        if (!Files.isDirectory(location, new LinkOption[0])) {
            throw new NoSuchFileException(location.toString());
        }
        return ret;
    }

    private void saveMmVersion(MetamodelVersionDescriptor mmVersion) throws IOException {
        Path mmVersionPath = this.getMmVersionPath();
        Files.createDirectories(mmVersionPath.getParent(), new FileAttribute[0]);
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedWriter out = Files.newBufferedWriter(mmVersionPath, StandardCharsets.UTF_8, new OpenOption[0]);){
            mmVersion.write((Writer)out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected Path getMmVersionPath() {
        return this.getDataDirectory().resolve("admin").resolve("mmversion.dat");
    }

    protected LocalExmlResourceProvider createResourceProvider() {
        return new LocalExmlResourceProvider(this.getDataDirectory(), this.getRuntimeDirectory(), this.getId());
    }

    @Override
    protected IAccessManager doInitAccessManager() {
        BasicAccessManager ret = new BasicAccessManager();
        if (this.isReadOnly()) {
            ret.setWriteable(false);
        }
        return ret;
    }

    protected boolean isReadOnly() {
        return !this.getAccessRights().isEditable();
    }

    @Override
    protected Collection<MObject> doGetRoots() throws IOException {
        SmMetamodel mm = this.getProjectMetamodel();
        Collection roots = this.repository.findByClass(mm.getMClass(AbstractProject.class), true);
        return roots;
    }

    @Override
    protected void doUmountPostProcess(IGProject project, IModelioProgress monitor) {
        this.repository = null;
    }

    /*
     * Loose catch block
     */
    @Override
    public IFragmentInfos getInformations() throws IOException {
        Path infosuri = this.getDataDirectory().resolve("manifest.properties");
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                ExmlFragmentInfos exmlFragmentInfos;
                InputStreamReader in;
                InputStream is;
                block18: {
                    block17: {
                        is = Files.newInputStream(infosuri, new OpenOption[0]);
                        in = new InputStreamReader(is, StandardCharsets.UTF_8);
                        Properties p = new Properties();
                        p.load(in);
                        exmlFragmentInfos = new ExmlFragmentInfos(p.getProperty("name"), p.getProperty("description"), new Version(p.getProperty("version")), new Version(p.getProperty("modelioversion")));
                        if (in == null) break block17;
                        in.close();
                    }
                    if (is == null) break block18;
                    is.close();
                }
                return exmlFragmentInfos;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (in != null) {
                                in.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (is != null) {
                                is.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            Log.warning((String)("No '" + String.valueOf(infosuri) + "' infos version file, use default values."));
            return new ExmlFragmentInfos(this.getId(), "", new Version("0.0.0"), ModelioVersion.VERSION);
        }
    }

    @Override
    public MetamodelVersionDescriptor getRequiredMetamodelDescriptor() throws IOException {
        Path p = this.getMmVersionPath();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader in = Files.newBufferedReader(p, StandardCharsets.UTF_8);){
                return VersionHelper.convert(new MetamodelVersionDescriptor((Reader)in));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            Log.warning((String)("No '" + String.valueOf(p) + "' metamodel version file. Assume Modelio 3.1 (9020) metamodel version."));
            MetamodelVersionDescriptor guessed = VersionHelper.getDescriptors(9020);
            return guessed;
        }
    }

    @Override
    protected void doInstall(IGProject aProject, IModelioProgress monitor) throws IGPart.GPartException {
    }

    @Override
    protected void doUninstall(IGProject aProject, IModelioProgress monitor) throws IGPart.GPartException {
    }

    @Override
    protected void checkVersions() throws FragmentMigrationNeededException, IOException {
        MetamodelVersionDescriptor currentMm;
        MetamodelVersionDescriptor neededMm;
        super.checkVersions();
        RepositoryVersions repoVersion = this.repository.getResourceProvider().readRepositoryVersion();
        if (repoVersion.getRepositoryFormat() < 3) {
            throw new FragmentMigrationNeededException(this, this.getRequiredMetamodelDescriptor(), CoreProject.I18N.getMessage("ExmlFragment.RepositoryFormatNeedMigration", new Object[]{this.getId(), repoVersion.getRepositoryFormat(), 3}));
        }
        if (!this.isReadOnly() && !(neededMm = this.getRequiredMetamodelDescriptor()).isSame(currentMm = this.getCurrentMmDescriptor())) {
            this.saveMmVersion(currentMm);
        }
    }

    @Override
    public IGModelFragmentMigrator getMigrator(MetamodelVersionDescriptor targetMetamodel) throws IOException {
        LocalExmlResourceProvider resProvider = this.createResourceProvider();
        ChainedExmlFragmentMigrator chainedMigrator = new ChainedExmlFragmentMigrator(this.getProject(), this, this.getMmVersionPath(), targetMetamodel, resProvider);
        if (chainedMigrator.getMigrationChain().isSuccessful()) {
            return new FragmentMigratorWithBackup(this, chainedMigrator);
        }
        return null;
    }

    public static class ExmlFragmentInfos
    implements IFragmentInfos {
        private final String description;
        private final String name;
        private final Version version;
        private final Version modelioVersion;

        public ExmlFragmentInfos(String name, String description, Version version, Version modelioVersion) {
            this.description = description;
            this.name = name;
            this.version = version;
            this.modelioVersion = modelioVersion;
        }

        public String getDescription() {
            return this.description;
        }

        public Version getModelioVersion() {
            return this.modelioVersion;
        }

        public String getName() {
            return this.name;
        }

        public Version getVersion() {
            return this.version;
        }
    }
}

