/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.parts.fragment;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Properties;
import org.modelio.gproject.FragmentAuthenticationException;
import org.modelio.gproject.core.IGPart;
import org.modelio.gproject.core.IGProject;
import org.modelio.gproject.data.project.GProjectPartDescriptor;
import org.modelio.gproject.parts.fragment.AbstractGModelFragment;
import org.modelio.gproject.parts.fragment.GExmlFragment;
import org.modelio.gproject.parts.fragment.VersionHelper;
import org.modelio.metamodel.StandardMetamodel;
import org.modelio.metamodel.uml.infrastructure.AbstractProject;
import org.modelio.vbasic.auth.IAuthData;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.net.UriConnections;
import org.modelio.vbasic.net.UriUtils;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.version.Version;
import org.modelio.vbasic.version.VersionedItem;
import org.modelio.vcore.session.api.IAccessManager;
import org.modelio.vcore.session.api.repository.IRepository;
import org.modelio.vcore.session.impl.permission.BasicAccessManager;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MetamodelVersionDescriptor;
import org.modelio.vcore.smkernel.meta.SmMetamodel;
import org.modelio.version.ModelioVersion;
import org.modelio.vstore.exml.local.ExmlBase;
import org.modelio.vstore.exml.resource.IExmlResourceProvider;
import org.modelio.vstore.exml.resource.UriExmlResourceProvider;

public class GHttpFragment
extends AbstractGModelFragment {
    private IRepository repository;

    public GHttpFragment(GProjectPartDescriptor desc) {
        super(desc);
    }

    @Override
    protected IRepository doMountInitRepository(IGProject project, IModelioProgress aMonitor) throws IOException, FragmentAuthenticationException {
        Path localPath = this.getRuntimeDirectory();
        UriExmlResourceProvider resProvider = new UriExmlResourceProvider(this.getDescriptor().getLocation(), localPath, this.resolveAuthData());
        resProvider.setName(this.getId());
        this.repository = new ExmlBase((IExmlResourceProvider)resProvider);
        return this.repository;
    }

    @Override
    protected void doUmountPostProcess(IGProject project, IModelioProgress monitor) {
        this.repository = null;
    }

    @Override
    public IRepository getRepository() {
        return this.repository;
    }

    @Override
    public Collection<MObject> doGetRoots() {
        SmMetamodel mm = this.getProjectMetamodel();
        Collection roots = this.repository.findByClass(mm.getMClass(AbstractProject.class), true);
        return roots;
    }

    protected final void assertOpen() throws IllegalStateException {
        if (this.repository == null) {
            throw new IllegalStateException("The '" + this.getId() + "' fragment is not mount.");
        }
    }

    @Override
    protected IAccessManager doInitAccessManager() {
        BasicAccessManager ret = new BasicAccessManager();
        ret.setWriteable(false);
        ret.setStatusflags(0x400000000000L, true);
        return ret;
    }

    /*
     * Loose catch block
     */
    @Override
    public MetamodelVersionDescriptor getRequiredMetamodelDescriptor() throws IOException {
        URI mmuri = UriUtils.asDirectoryUri((URI)this.getDescriptor().getLocation()).resolve("admin/").resolve("mmversion.dat");
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                MetamodelVersionDescriptor metamodelVersionDescriptor;
                InputStreamReader in;
                InputStream is;
                block18: {
                    block17: {
                        is = UriConnections.openInputStream((URI)mmuri, (IAuthData)this.resolveAuthData());
                        in = new InputStreamReader(is, StandardCharsets.UTF_8);
                        metamodelVersionDescriptor = VersionHelper.convert(new MetamodelVersionDescriptor((Reader)in));
                        if (in == null) break block17;
                        in.close();
                    }
                    if (is == null) break block18;
                    is.close();
                }
                return metamodelVersionDescriptor;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (in != null) {
                                in.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (is != null) {
                                is.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            Log.warning((String)("No '" + String.valueOf(mmuri) + "' metamodel version file. Assume Modelio 3.1 (9020) metamodel version."));
            return new MetamodelVersionDescriptor(new VersionedItem(StandardMetamodel.NAME, VersionHelper.convert(9020)));
        }
    }

    @Override
    public void rename(String name, IModelioProgress aMonitor) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public UrlFragmentInfos getInformations() throws IOException {
        Properties p = this.getPropertyFile();
        if (p != null) {
            return new UrlFragmentInfos(p.getProperty("name"), p.getProperty("description"), new Version(p.getProperty("version")), new Version(p.getProperty("modelioversion")));
        }
        return new UrlFragmentInfos(this.getId(), "", new Version(0, 0, 0), ModelioVersion.VERSION);
    }

    /*
     * Loose catch block
     */
    private Properties getPropertyFile() throws IOException {
        URI infosUri = UriUtils.asDirectoryUri((URI)this.getDescriptor().getLocation()).resolve("manifest.properties");
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                Properties properties;
                InputStreamReader in;
                InputStream is;
                block18: {
                    block17: {
                        is = UriConnections.openInputStream((URI)infosUri, (IAuthData)this.resolveAuthData());
                        in = new InputStreamReader(is, StandardCharsets.UTF_8);
                        Properties p = new Properties();
                        p.load(in);
                        properties = p;
                        if (in == null) break block17;
                        in.close();
                    }
                    if (is == null) break block18;
                    is.close();
                }
                return properties;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (in != null) {
                                in.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (is != null) {
                                is.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            Log.warning((String)("No '" + String.valueOf(infosUri) + "' infos version file, use default values."));
            return null;
        }
    }

    @Override
    protected void doInstall(IGProject aProject, IModelioProgress monitor) throws IGPart.GPartException {
    }

    @Override
    protected void doUninstall(IGProject aProject, IModelioProgress monitor) throws IGPart.GPartException {
    }

    public class UrlFragmentInfos
    extends GExmlFragment.ExmlFragmentInfos {
        public UrlFragmentInfos(String name, String description, Version version, Version modelioVersion) {
            super(name, description, version, modelioVersion);
        }

        public String getProvider() throws IOException {
            Properties p = GHttpFragment.this.getPropertyFile();
            if (p != null) {
                return p.getProperty("provider");
            }
            return "";
        }

        public String getDate() throws IOException {
            Properties p = GHttpFragment.this.getPropertyFile();
            if (p != null) {
                return p.getProperty("date");
            }
            return "";
        }
    }
}

