/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.parts.fragment;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.modelio.gproject.FragmentAuthenticationException;
import org.modelio.gproject.core.IGPart;
import org.modelio.gproject.core.IGProject;
import org.modelio.gproject.data.project.GProjectPartDescriptor;
import org.modelio.gproject.data.ramc.IModelComponentInfos;
import org.modelio.gproject.data.ramc.ModelComponentArchive;
import org.modelio.gproject.data.ramc.ModelRef;
import org.modelio.gproject.monitor.GProjectEvent;
import org.modelio.gproject.parts.fragment.AbstractGModelFragment;
import org.modelio.gproject.parts.fragment.VersionHelper;
import org.modelio.gproject.plugin.CoreProject;
import org.modelio.metamodel.StandardMetamodel;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.files.Unzipper;
import org.modelio.vbasic.net.UriPathAccess;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vbasic.version.Version;
import org.modelio.vbasic.version.VersionedItem;
import org.modelio.vcore.session.api.IAccessManager;
import org.modelio.vcore.session.api.repository.IRepository;
import org.modelio.vcore.session.impl.permission.BasicAccessManager;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MetamodelVersionDescriptor;
import org.modelio.vstore.exml.local.ExmlBase;
import org.modelio.vstore.exml.resource.IExmlResourceProvider;
import org.modelio.vstore.exml.resource.LocalExmlResourceProvider;

public class GRamcFragment
extends AbstractGModelFragment {
    protected ExmlBase repository;
    protected Path modelLocation;
    private List<MObject> roots;

    public GRamcFragment(GProjectPartDescriptor desc) {
        super(desc);
    }

    public IModelComponentInfos getInformations() throws IOException {
        Path archivePath = this.extractRamcToLocal(null);
        return new ModelComponentArchive(archivePath, false).getInfos();
    }

    @Override
    public IRepository getRepository() {
        return this.repository;
    }

    @Override
    protected IRepository doMountInitRepository(IGProject project, IModelioProgress aMonitor) throws IOException, FragmentAuthenticationException {
        Path runtimePath = this.getRuntimeDirectory();
        Files.createDirectories(runtimePath, new FileAttribute[0]);
        Path localUri = this.extractRamcToLocal(aMonitor);
        this.modelLocation = localUri.resolve("model");
        LocalExmlResourceProvider resProvider = new LocalExmlResourceProvider(this.modelLocation, this.modelLocation, this.getId());
        this.repository = new ExmlBase((IExmlResourceProvider)resProvider);
        return this.repository;
    }

    @Override
    protected void doUmountPostProcess(IGProject project, IModelioProgress monitor) throws IOException {
        this.repository = null;
    }

    protected final void assertOpen() throws IllegalStateException {
        if (this.repository == null) {
            throw new IllegalStateException("The '" + this.getId() + "' fragment is not mount.");
        }
    }

    protected List<MObject> doGetRoots() throws IOException {
        if (this.roots == null) {
            this.roots = new ArrayList<MObject>();
            IModelComponentInfos infos = ModelComponentArchive.getRamcDirectoryInfos((Path)this.getContentDirectory());
            for (ModelRef mref : infos.getRoots()) {
                SmObjectImpl obj = this.getRepository().findById(this.getProjectMetamodel().getMClass(mref.mc), mref.uuid);
                if (obj == null) continue;
                this.roots.add((MObject)obj);
            }
        }
        return this.roots != null ? this.roots : new ArrayList<MObject>();
    }

    @Override
    protected IAccessManager doInitAccessManager() {
        BasicAccessManager ret = new BasicAccessManager();
        ret.setWriteable(false);
        ret.setRamc(true);
        return ret;
    }

    @Override
    protected void doDelete(IGProject project, IModelioProgress monitor) {
        try {
            this.removeExportedFilesOfFragment(project, monitor);
        }
        catch (IOException e) {
            project.getMonitorSupport().fireMonitors(GProjectEvent.buildWarning((Object)this, e));
        }
    }

    private Path extractRamcToLocal(IModelioProgress monitor) throws IOException {
        Path ramcContentDir = this.getContentDirectory();
        Path tagFile = ramcContentDir.resolve(this.getDescriptor().getVersion().toString("T_V.R.C"));
        if (Files.isDirectory(ramcContentDir, new LinkOption[0]) && Files.exists(tagFile, new LinkOption[0])) {
            return ramcContentDir;
        }
        FileUtils.delete((Path)ramcContentDir);
        Files.createDirectories(ramcContentDir, new FileAttribute[0]);
        URI uri = this.getDescriptor().getLocation();
        if (!uri.isAbsolute()) {
            uri = this.getProject().getPfs().getProjectPath().toUri().resolve(uri);
        }
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try (UriPathAccess acc = new UriPathAccess(uri, this.resolveAuthData());){
                SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)2);
                String progressLabel = CoreProject.I18N.getMessage("RamcFileFragment.ExtractRamcFrom", new Object[]{this.getId(), uri});
                mon.subTask(progressLabel);
                new Unzipper().setProgressLabelPrefix(progressLabel).unzip(acc.getPath(), ramcContentDir, (IModelioProgress)mon.newChild(1));
                mon.subTask(CoreProject.I18N.getMessage("RamcFileFragment.DeployRamcFiles", new Object[]{this.getId(), uri}));
                new ModelComponentArchive(ramcContentDir, false).installExportedFiles(this.getProject().getPfs().getProjectPath(), (IModelioProgress)mon.newChild(1));
                Files.createFile(tagFile, new FileAttribute[0]);
                return ramcContentDir;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (MalformedURLException e1) {
            String msg = CoreProject.I18N.getMessage("RamcFileFragment.InvalidUri", new Object[]{uri, e1.getLocalizedMessage()});
            throw new IOException(msg, e1);
        }
        catch (IllegalArgumentException e1) {
            String msg = CoreProject.I18N.getMessage("RamcFileFragment.InvalidUri", new Object[]{uri, e1.getLocalizedMessage()});
            throw new IOException(msg, e1);
        }
    }

    private void removeExportedFilesOfFragment(IGProject project, IModelioProgress monitor) throws IOException {
        Path contentDirectory = project.getPfs().getProjectDataPath().resolve("fragments").resolve(this.encodedDirectoryName).resolve("content");
        Path deploymentPath = project.getPfs().getProjectPath();
        ModelComponentArchive modelComponentArchive = new ModelComponentArchive(contentDirectory, false);
        modelComponentArchive.removeExportedFiles(deploymentPath, monitor);
    }

    private Path getContentDirectory() {
        return this.getDataDirectory().resolve("content");
    }

    @Override
    public MetamodelVersionDescriptor getRequiredMetamodelDescriptor() throws IOException {
        MetamodelVersionDescriptor mmDesc = new MetamodelVersionDescriptor();
        boolean found = false;
        for (VersionedItem versionedItem : this.getInformations().getRequiredMetamodelFragments()) {
            VersionedItem v = new VersionedItem(versionedItem.getName(), versionedItem.getVersion());
            mmDesc.addDescriptor(v);
            found = true;
        }
        if (!found) {
            Path modelio2_model = this.getContentDirectory().resolve("model.xml");
            Path modelio3_stamp = this.getContentDirectory().resolve("model").resolve("admin").resolve("stamp.dat");
            Path modelio3_format_version = this.getContentDirectory().resolve("model").resolve("admin/format_version.dat");
            Version v = Files.isRegularFile(modelio3_format_version, new LinkOption[0]) ? VersionHelper.convert(9020) : (Files.isRegularFile(modelio3_stamp, new LinkOption[0]) ? VersionHelper.convert(9017) : (Files.isRegularFile(modelio2_model, new LinkOption[0]) ? VersionHelper.convert(8020) : VersionHelper.convert(8000)));
            mmDesc.addDescriptor(new VersionedItem(StandardMetamodel.NAME, v));
        }
        return mmDesc;
    }

    @Override
    public void rename(String name, IModelioProgress aMonitor) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doInstall(IGProject aProject, IModelioProgress monitor) throws IGPart.GPartException {
    }

    @Override
    protected void doUninstall(IGProject aProject, IModelioProgress monitor) throws IGPart.GPartException {
    }
}

