/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.parts.fragment;

import java.io.IOException;
import org.modelio.gproject.core.IGModelFragment;
import org.modelio.gproject.core.IGPart;
import org.modelio.gproject.core.IGProject;
import org.modelio.gproject.data.project.GProjectPartDescriptor;
import org.modelio.gproject.parts.GPartFactory;
import org.modelio.metamodel.StandardMetamodel;
import org.modelio.vbasic.version.Version;
import org.modelio.vbasic.version.VersionedItem;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vcore.smkernel.mapi.MMetamodelFragment;
import org.modelio.vcore.smkernel.mapi.MetamodelVersionDescriptor;
import org.modelio.version.ModelioVersionGuesser;

public class VersionHelper {
    public static Version convert(int mmVersion) {
        return new Version(1, 0, mmVersion);
    }

    public static MetamodelVersionDescriptor convert(MetamodelVersionDescriptor input) {
        MetamodelVersionDescriptor out = new MetamodelVersionDescriptor();
        for (VersionedItem item : input) {
            if (item.getName().equals("Modelio")) {
                VersionedItem n = new VersionedItem(StandardMetamodel.NAME, VersionHelper.convert(item.getVersion().getMajorVersion()), item.getObject());
                out.addDescriptor(n);
                continue;
            }
            if (item.getVersion().isOlderThan(new Version(0, 0, 10000)) && item.getVersion().isNewerBuildOf(new Version(0, 0, 1))) {
                out.addDescriptor(new VersionedItem(StandardMetamodel.NAME, VersionHelper.convert(item.getVersion().getBuildVersion()), item.getObject()));
                continue;
            }
            out.addDescriptor(item);
        }
        return out;
    }

    public static MetamodelVersionDescriptor getDescriptors(int oldMmVersion) {
        VersionedItem it = new VersionedItem(StandardMetamodel.NAME, VersionHelper.convert(oldMmVersion));
        return new MetamodelVersionDescriptor(it);
    }

    public static MetamodelVersionDescriptor getDescriptors(MMetamodel mm) {
        MetamodelVersionDescriptor desc = new MetamodelVersionDescriptor();
        for (MMetamodelFragment mmFragment : mm.getFragments()) {
            VersionedItem v = new VersionedItem(mmFragment.getName(), mmFragment.getVersion());
            desc.addDescriptor(v);
        }
        return desc;
    }

    private VersionHelper() {
    }

    public static Version guessModelioVersion(IGProject loadedProject) {
        Version lastWorkVersion = null;
        Version lastRamcVersion = null;
        try {
            block6: for (GProjectPartDescriptor d : loadedProject.getDescriptor().getPartDescriptors()) {
                GProjectPartDescriptor.GProjectPartType type = d.getType();
                switch (type) {
                    case EXMLFRAGMENT: 
                    case SVNFRAGMENT: 
                    case HTTPFRAGMENT: {
                        IGModelFragment f = (IGModelFragment)GPartFactory.getInstance().instantiate(d);
                        f.install(loadedProject, null);
                        MetamodelVersionDescriptor mmv = f.getRequiredMetamodelDescriptor();
                        Version v = mmv.getVersion(StandardMetamodel.NAME);
                        if (v == null || v.equals((Object)VersionHelper.convert(9020)) || lastWorkVersion != null && !v.isNewerThan(lastWorkVersion)) continue block6;
                        lastWorkVersion = v;
                        break;
                    }
                    case RAMC: {
                        IGModelFragment f = (IGModelFragment)GPartFactory.getInstance().instantiate(d);
                        f.install(loadedProject, null);
                        MetamodelVersionDescriptor mmv = f.getRequiredMetamodelDescriptor();
                        Version v = mmv.getVersion(StandardMetamodel.NAME);
                        if (v == null || lastRamcVersion != null && !v.isNewerThan(lastRamcVersion)) continue block6;
                        lastRamcVersion = v;
                        break;
                    }
                }
            }
            if (lastRamcVersion != null) {
                return ModelioVersionGuesser.guessFromStandardMmVersion(lastRamcVersion);
            }
            if (lastWorkVersion != null) {
                return ModelioVersionGuesser.guessFromStandardMmVersion(lastWorkVersion);
            }
            return null;
        }
        catch (IOException | IGPart.GPartException exception) {
            return null;
        }
    }
}

