/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.parts.fragment.migration;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.modelio.gproject.FragmentAuthenticationException;
import org.modelio.gproject.MigrationFailedException;
import org.modelio.gproject.core.IGProject;
import org.modelio.gproject.migration.ChainedMofFragmentMigrator;
import org.modelio.gproject.migration.FileFlags;
import org.modelio.gproject.parts.fragment.GExmlFragment;
import org.modelio.gproject.plugin.CoreProject;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.model.spi.mm.AbstractMofRepositoryMigrator;
import org.modelio.vcore.model.spi.mm.IMigrationStepDescription;
import org.modelio.vcore.model.spi.mm.IMofRepositoryMigrator;
import org.modelio.vcore.model.spi.mm.IMofRepositoryMigratorProvider;
import org.modelio.vcore.model.spi.mm.MigrationChain;
import org.modelio.vcore.model.spi.mm.MigrationStepDescription;
import org.modelio.vcore.model.spi.mm.MofMigrationException;
import org.modelio.vcore.model.spi.mm.MofSession;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vcore.smkernel.mapi.MetaclassNotFoundException;
import org.modelio.vcore.smkernel.mapi.MetamodelVersionDescriptor;
import org.modelio.vcore.smkernel.meta.descriptor.MetamodelDescriptor;
import org.modelio.vcore.smkernel.meta.descriptor.MetamodelDescriptorWriter;
import org.modelio.vstore.exml.common.AbstractExmlRepository;
import org.modelio.vstore.exml.resource.IExmlResourceProvider;
import org.modelio.vstore.exml.resource.LocalExmlResourceProvider;
import org.modelio.vstore.exml.resource.migration.RepositoryFormatMigrator;

public class ChainedExmlFragmentMigrator
extends ChainedMofFragmentMigrator {
    private final int srcRepositoryFormat;
    private final GExmlFragment exmlFragment;
    private final Path mmVersionPath;
    private final MetamodelVersionDescriptor targetVersion;
    private final IExmlResourceProvider.ExmlResource mmDescriptorResource;

    public ChainedExmlFragmentMigrator(IGProject project, GExmlFragment exmlFragment, Path mmVersionPath, MetamodelVersionDescriptor targetVersion, LocalExmlResourceProvider resProvider) throws IOException {
        super(project, exmlFragment, exmlFragment::instantiateRepository);
        this.exmlFragment = exmlFragment;
        this.mmVersionPath = mmVersionPath;
        this.mmDescriptorResource = resProvider.getMetamodelDescriptorResource();
        this.targetVersion = targetVersion;
        this.srcRepositoryFormat = resProvider.readRepositoryVersion().getRepositoryFormat();
    }

    @Override
    public void migrateModel(IModelioProgress monitor) throws MigrationFailedException, FragmentAuthenticationException {
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)(this.isFormatChangeNeeded() ? 2 : 1));
        try {
            if (this.isFormatChangeNeeded()) {
                this.migrateRepositoryFormat((IModelioProgress)mon.newChild(1));
            }
            super.migrateModel((IModelioProgress)mon.newChild(1));
            this.writeMmVersion();
        }
        catch (IOException e) {
            throw this.handleIOException(e);
        }
        catch (MofMigrationException e) {
            throw new MigrationFailedException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    protected void doFinish(IModelioProgress monitor) throws MigrationFailedException {
        super.doFinish(monitor);
        try {
            new FileFlags(this.getExmlFragment()).removeMigrationFlag("migrator");
            this.getMigrationReporter().getLogger().println("'" + this.getExmlFragment().getId() + "' migration sucessful.");
        }
        catch (IOException e) {
            throw this.handleIOException(e);
        }
    }

    @Override
    protected void doStart(IModelioProgress monitor) throws FragmentAuthenticationException, MigrationFailedException {
        super.doStart(monitor);
        try {
            new FileFlags(this.exmlFragment).putMigrationFlag("migrator", this.getClass().getName());
        }
        catch (RuntimeException e) {
            this.getMigrationReporter().getLogger().printStackTrace((Throwable)e);
            throw new MigrationFailedException(CoreProject.I18N.getMessage("ChainedExmlFragmentMigrator.MigrationFailed", new Object[]{this.exmlFragment.getId(), e.toString()}), e);
        }
        catch (IOException e) {
            throw this.handleIOException(e);
        }
    }

    @Override
    protected void postMofMigration(Supplier<SubProgress> mon, MofSession migrationSession, IMofRepositoryMigrator mofMigrator) throws MofMigrationException {
        try {
            this.handleCmsNodeChanges(mon, migrationSession, mofMigrator);
        }
        catch (MetaclassNotFoundException e) {
            throw new MofMigrationException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    protected void preMofMigration(Supplier<SubProgress> mon, MofSession migrationSession, IMofRepositoryMigrator mofMigrator) throws MofMigrationException {
        this.getMigrationReporter().getLogger().println("Rebuilding '" + this.exmlFragment.getId() + "' indexes...");
        try {
            AbstractExmlRepository repository = (AbstractExmlRepository)migrationSession.getTargetRepository();
            repository.getResourceProvider().updateRepositoryStructure((MMetamodel)this.getProject().getSession().getMetamodel());
            repository.getMaintenance().rebuildIndexes((IModelioProgress)mon.get());
        }
        catch (IOException e) {
            throw new MofMigrationException(FileUtils.getLocalizedMessage((IOException)e), (Throwable)e);
        }
    }

    @Override
    protected MigrationChain resolveMigrationChain(MetamodelVersionDescriptor fromMetamodel, MetamodelVersionDescriptor targetMetamodel, Collection<IMofRepositoryMigratorProvider> migrationProviders) {
        MigrationChain ret = super.resolveMigrationChain(fromMetamodel, targetMetamodel, migrationProviders);
        if (this.isFormatChangeNeeded() && ret.isNoopMigrationChain()) {
            return ret.add((IMofRepositoryMigrator)new RepoFormatMigrationNeededMigrator(fromMetamodel, targetMetamodel));
        }
        return ret;
    }

    private GExmlFragment getExmlFragment() {
        return this.exmlFragment;
    }

    @Deprecated
    private void handleCmsNodeChanges(Supplier<SubProgress> monitorSupplier, MofSession migrationSession, IMofRepositoryMigrator mofMigrator) throws MetaclassNotFoundException {
    }

    private MigrationFailedException handleIOException(IOException e) {
        this.getMigrationReporter().getLogger().printStackTrace((Throwable)e);
        return new MigrationFailedException(CoreProject.I18N.getMessage("ChainedExmlFragmentMigrator.MigrationFailed", new Object[]{this.exmlFragment.getId(), FileUtils.getLocalizedMessage((IOException)e)}), e);
    }

    private boolean isFormatChangeNeeded() {
        return this.srcRepositoryFormat < 3;
    }

    private void migrateRepositoryFormat(IModelioProgress monitor) throws IOException, FragmentAuthenticationException, MofMigrationException {
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)10);
        MofSession sess = this.prepareMofSession((IModelioProgress)mon.newChild(1), 0);
        try {
            new RepositoryFormatMigrator(this.exmlFragment.getDataDirectory(), (MMetamodel)sess.getMetamodel(), this.getMigrationReporter(), this.srcRepositoryFormat, 3).execute((IModelioProgress)mon.newChild(9));
        }
        finally {
            sess.getCoreSession().close();
        }
    }

    private void writeMmVersion() throws IOException, MofMigrationException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedWriter out = Files.newBufferedWriter(this.mmVersionPath, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.targetVersion.write((Writer)out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.writeMetamodelDescriptor(this.getFinalMergedMmDescriptor(this.getMigrationReporter()));
    }

    private void writeMetamodelDescriptor(MetamodelDescriptor finalMergedMmDescriptor) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStream out = this.mmDescriptorResource.bufferedWrite();){
            new MetamodelDescriptorWriter().write(finalMergedMmDescriptor, out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected List<IMigrationStepDescription> computeStepsDescription() {
        try {
            List<IMigrationStepDescription> ret;
            if (this.getMigrationChain().isNoopMigrationChain()) {
                ret = new ArrayList<IMigrationStepDescription>();
                ret.add((IMigrationStepDescription)new MigrationStepDescription(CoreProject.I18N.getMessage("ChainedExmlFragmentMigrator.SaveMmVersionNeeded", new Object[]{this.exmlFragment.getId()})));
            } else {
                ret = super.computeStepsDescription();
            }
            if (this.isFormatChangeNeeded()) {
                ret.add((IMigrationStepDescription)new MigrationStepDescription(CoreProject.I18N.getMessage("GExmlFragment.RepositoryFormatNeedMigration", new Object[]{this.exmlFragment.getId(), this.srcRepositoryFormat, 3})));
            }
            return ret;
        }
        catch (IOException iOException) {
            return super.computeStepsDescription();
        }
    }

    private static final class RepoFormatMigrationNeededMigrator
    extends AbstractMofRepositoryMigrator {
        public RepoFormatMigrationNeededMigrator(MetamodelVersionDescriptor fromMetamodel, MetamodelVersionDescriptor targetMetamodel) {
            super(fromMetamodel, targetMetamodel);
        }
    }
}

