/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.parts.module;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import org.modelio.gproject.core.IGModelFragment;
import org.modelio.gproject.core.IGPart;
import org.modelio.gproject.core.IGPartState;
import org.modelio.gproject.core.IGProject;
import org.modelio.gproject.data.project.GProjectPartDescriptor;
import org.modelio.gproject.data.project.ProjectFileStructure;
import org.modelio.gproject.data.project.auth.AuthDescriptor;
import org.modelio.gproject.module.EmptyModuleHandle;
import org.modelio.gproject.module.IModuleHandle;
import org.modelio.gproject.module.IModuleRTCache;
import org.modelio.gproject.monitor.GProjectEvent;
import org.modelio.gproject.parts.AbstractGPart;
import org.modelio.gproject.parts.GPartFactory;
import org.modelio.metamodel.mda.ModuleComponent;
import org.modelio.vbasic.auth.IAuthData;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.net.UriConnections;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.version.Version;
import org.modelio.vcore.session.api.repository.IRepository;
import org.modelio.vcore.smkernel.meta.SmMetamodel;

public class GModule
extends AbstractGPart {
    private IModuleHandle moduleHandle = null;
    private IGModelFragment mdaFragment = null;
    private ModuleComponent moduleComponent;

    public GModule(GProjectPartDescriptor desc) {
        super(desc);
    }

    @Override
    public void install(IGProject aProject, IModelioProgress monitor) throws IGPart.GPartException {
        try {
            super.install(aProject, monitor);
            this.moduleHandle = this.createModuleHandle(aProject, this.getId(), this.getVersion(), monitor);
            Path archive = this.moduleHandle.getArchive();
            Path backupPath = aProject.getPfs().getModuleBackupDir(this.getId());
            if (archive != null) {
                this.installArchiveInBackup(aProject, archive, backupPath);
            }
        }
        catch (IOException e) {
            this.setDown(e);
        }
    }

    public final void setDown(Throwable error) {
        assert (error != null);
        if (this.state.getValue() == IGPartState.GPartStateEnum.DOWN) {
            return;
        }
        if (this.mdaFragment != null) {
            try {
                this.mdaFragment.unmount(null);
            }
            catch (RuntimeException | IGPart.GPartException e) {
                error.addSuppressed(e);
            }
        }
        this.state.sendDown(error);
    }

    private boolean installArchiveInBackup(IGProject aProject, Path archive, Path backupPath) throws IGPart.GPartException {
        Path existingArchive = backupPath.resolve(archive.getFileName());
        boolean hasToCopy = false;
        if (Files.isRegularFile(existingArchive, new LinkOption[0])) {
            try {
                FileTime d1 = Files.getLastModifiedTime(archive, new LinkOption[0]);
                FileTime d2 = Files.getLastModifiedTime(existingArchive, new LinkOption[0]);
                if (d1.compareTo(d2) > 0) {
                    hasToCopy = true;
                }
            }
            catch (IOException iOException) {
                hasToCopy = true;
            }
        } else {
            hasToCopy = true;
        }
        if (hasToCopy) {
            try {
                FileUtils.delete((Path)backupPath);
                Files.createDirectories(backupPath, new FileAttribute[0]);
                Path localArchivePath = aProject.getPfs().getModuleBackupArchivePath(this.moduleHandle.getName(), this.moduleHandle.getVersion());
                Files.copy(this.moduleHandle.getArchive(), localArchivePath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (SecurityException e) {
                throw new IGPart.GPartException(e);
            }
            catch (IOException e) {
                throw new IGPart.GPartException(FileUtils.getLocalizedMessage((IOException)e), e);
            }
        }
        return hasToCopy;
    }

    @Override
    public void mount(IModelioProgress monitor) throws IGPart.GPartException {
        this.state.sendStartMount();
        IGProject project = this.getProject();
        if (this.moduleHandle != null) {
            this.mdaFragment = this.createMdaFragment();
            if (this.mdaFragment != null) {
                project.addGPart(monitor, this.mdaFragment, false);
            } else {
                String msg = this.getId() + " " + String.valueOf(this.getVersion()) + " has no model fragment.";
                project.getMonitorSupport().fireMonitors(GProjectEvent.buildWarning((Object)project, msg));
            }
            this.state.sendEndMount(null);
        } else {
            this.state.sendEndMount(new Exception(String.format("GModule#mount(): Could not get module handle for %s %s", this.getId(), this.getVersion())));
        }
    }

    public IGModelFragment getMdaFragment() {
        return this.mdaFragment;
    }

    @Override
    public void unmount(IModelioProgress monitor) throws IGPart.GPartException {
        IGProject project = this.getProject();
        if (this.mdaFragment != null) {
            this.mdaFragment.unmount(monitor);
        } else {
            String msg = this.getId() + " " + String.valueOf(this.getVersion()) + " has no model fragment.";
            project.getMonitorSupport().fireMonitors(GProjectEvent.buildWarning((Object)project, msg));
        }
        this.state.sendUnmount();
    }

    @Override
    public void uninstall(IGProject project, IModelioProgress monitor) throws IGPart.GPartException {
        super.uninstall(project, monitor);
        this.moduleHandle = null;
        this.moduleComponent = null;
        if (this.mdaFragment != null) {
            project.removeGPart(monitor, this.mdaFragment);
            this.mdaFragment = null;
        } else {
            this.delete(project);
        }
    }

    private void delete(IGProject project) {
        String encodedDirectoryName = FileUtils.encodeFileName((String)this.getId(), (StringBuilder)new StringBuilder()).toString();
        String FRAGMENTS_SUBDIR = "fragments";
        ProjectFileStructure pfs = project.getPfs();
        Path runtimeDirectory = pfs.getProjectRuntimePath().resolve(FRAGMENTS_SUBDIR).resolve(encodedDirectoryName);
        try {
            FileUtils.delete((Path)runtimeDirectory);
        }
        catch (IOException | SecurityException exception) {}
        Path dataDirectory = pfs.getProjectDataPath().resolve(FRAGMENTS_SUBDIR).resolve(encodedDirectoryName);
        try {
            FileUtils.delete((Path)dataDirectory);
        }
        catch (IOException | SecurityException exception) {}
    }

    private IGModelFragment createMdaFragment() {
        Path ramcPath = this.moduleHandle.getModelComponentPath();
        if (ramcPath != null) {
            GProjectPartDescriptor d = new GProjectPartDescriptor(GProjectPartDescriptor.GProjectPartType.RAMC, this.moduleHandle.getName(), this.moduleHandle.getVersion(), this.getDefinitionScope());
            d.setLocation(ramcPath.toUri());
            d.setAuth(new AuthDescriptor(this.getAuth()));
            return (IGModelFragment)GPartFactory.getInstance().instantiate(d);
        }
        return null;
    }

    IModuleHandle createModuleHandle(IGProject project, String name, Version version, IModelioProgress progress) throws FileSystemException, IOException {
        URI archiveURI;
        IModuleRTCache moduleCache = project.getProjectEnvironment().getModulesCache();
        IModuleHandle mh = moduleCache.findModule(name, version.toString("V.R.C"), progress);
        if (mh == null) {
            Path backupPath = project.getPfs().getModuleBackupArchivePath(name, version);
            mh = moduleCache.installModuleArchive(backupPath, progress);
        }
        if (mh == null && (archiveURI = this.getDescriptor().getLocation()) != null) {
            IAuthData authData = this.resolveAuthData();
            try {
                Path backupPath = project.getPfs().getModuleBackupArchivePath(name, version);
                this.copyJmdacToModuleDir(project.getPfs().getProjectDataPath(), archiveURI, authData, backupPath);
                if (Files.isRegularFile(backupPath, new LinkOption[0])) {
                    mh = moduleCache.installModuleArchive(backupPath, progress);
                }
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                Log.warning((String)"'%s' module '%s' URI is invalid: %s", (Object[])new Object[]{name, archiveURI, FileUtils.getLocalizedMessage((IOException)e)});
            }
        }
        if (mh == null) {
            mh = moduleCache.findModule(name, version.toString("V.R.C"), progress);
        }
        return mh == null ? new EmptyModuleHandle(name, version) : mh;
    }

    protected boolean copyJmdacToModuleDir(Path projectDataPath, URI anUri, IAuthData authData, Path copyTo) throws IOException {
        Path fsPath = null;
        if (anUri.getScheme() != null) {
            try {
                fsPath = Paths.get(anUri);
            }
            catch (IllegalArgumentException | FileSystemNotFoundException runtimeException) {}
            if (fsPath != null) {
                if (Files.isRegularFile(fsPath, new LinkOption[0])) {
                    Files.copy(fsPath, copyTo, StandardCopyOption.REPLACE_EXISTING);
                    return true;
                }
                if (Files.isDirectory(fsPath, new LinkOption[0])) {
                    throw new NoSuchFileException(fsPath.toString(), null, "It is a directory.");
                }
            }
        }
        if (anUri.getScheme() == null || anUri.getScheme().equals("file")) {
            try {
                fsPath = projectDataPath.resolve(anUri.getPath());
            }
            catch (IllegalArgumentException | FileSystemNotFoundException runtimeException) {}
            if (fsPath != null) {
                if (Files.isRegularFile(fsPath, new LinkOption[0])) {
                    Files.copy(fsPath, copyTo, StandardCopyOption.REPLACE_EXISTING);
                    return true;
                }
                if (Files.isDirectory(fsPath, new LinkOption[0])) {
                    throw new NoSuchFileException(fsPath.toString(), null, "It is a directory.");
                }
            }
        }
        try {
            Files.createDirectories(copyTo.getParent(), new FileAttribute[0]);
            Throwable throwable = null;
            Object var7_10 = null;
            try (InputStream in = UriConnections.openInputStream((URI)anUri, (IAuthData)authData);){
                Files.copy(in, copyTo, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return true;
        }
        catch (MalformedURLException e) {
            throw new IOException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException(e);
        }
    }

    @Deprecated
    public String getName() {
        return this.moduleHandle != null ? this.moduleHandle.getName() : "";
    }

    public IModuleHandle getModuleHandle() {
        return this.moduleHandle;
    }

    public ModuleComponent getModuleElement() {
        if (this.moduleComponent == null) {
            try {
                IRepository repository;
                String uid = this.getModuleHandle().getUid();
                IRepository iRepository = repository = this.mdaFragment != null ? this.mdaFragment.getRepository() : null;
                if (repository != null) {
                    SmMetamodel mm = this.getProject().getSession().getMetamodel();
                    this.moduleComponent = (ModuleComponent)repository.findById(mm.getMClass(ModuleComponent.class), uid);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return this.moduleComponent;
    }
}

