/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.project;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.modelio.gproject.GProblem;
import org.modelio.gproject.core.IGModelFragment;
import org.modelio.gproject.core.IGProject;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.session.api.repository.IRepository;
import org.modelio.vcore.session.impl.CoreSession;
import org.modelio.vcore.smkernel.mapi.MObject;

public abstract class AbstractGProject
implements IGProject {
    private static final List<WeakReference<IGProject>> allProjects = new CopyOnWriteArrayList<WeakReference<IGProject>>();
    protected CoreSession session;
    protected final List<GProblem> problems = new ArrayList<GProblem>();

    @Override
    public ICoreSession getSession() {
        return this.session;
    }

    protected AbstractGProject() {
        allProjects.removeIf(ref -> ref.get() == null);
        allProjects.add(new WeakReference<AbstractGProject>(this));
    }

    @Override
    public void close() {
        try {
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
            this.problems.clear();
        }
        catch (Throwable throwable) {
            allProjects.removeIf(ref -> ref.get() == null || ref.get() == this);
            throw throwable;
        }
        allProjects.removeIf(ref -> ref.get() == null || ref.get() == this);
    }

    @Override
    public List<GProblem> getProblems() {
        return this.problems;
    }

    public static IGProject getProject(ICoreSession session) {
        for (WeakReference<IGProject> ref : allProjects) {
            IGProject proj = (IGProject)ref.get();
            if (proj == null || proj.getSession() != session) continue;
            return proj;
        }
        return null;
    }

    public static IGProject getProject(MObject mObj) {
        return AbstractGProject.getProject((ICoreSession)CoreSession.getSession((MObject)mObj));
    }

    @Override
    public IGModelFragment getFragment(MObject obj) {
        if (this.session != null) {
            IRepository repo = this.session.getRepositorySupport().getRepository(obj);
            for (IGModelFragment f : this.getParts(IGModelFragment.class)) {
                if (f.getRepository() != repo) continue;
                return f;
            }
        }
        return null;
    }
}

