/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.project;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.modelio.gproject.GProblem;
import org.modelio.gproject.core.IGPart;
import org.modelio.gproject.core.IGProject;
import org.modelio.gproject.core.IGProjectState;
import org.modelio.gproject.data.project.DefinitionScope;
import org.modelio.gproject.data.project.GProjectDescriptor;
import org.modelio.gproject.data.project.GProjectDescriptorWriter;
import org.modelio.gproject.data.project.GProjectPartDescriptor;
import org.modelio.gproject.data.project.GProperties;
import org.modelio.gproject.data.project.ProjectFileStructure;
import org.modelio.gproject.data.project.ProjectType;
import org.modelio.gproject.data.project.auth.AuthDescriptor;
import org.modelio.gproject.env.GProjectEnvironment;
import org.modelio.gproject.env.IGProjectEnv;
import org.modelio.gproject.lock.ProjectLock;
import org.modelio.gproject.module.EmptyModuleCache;
import org.modelio.gproject.module.IModuleRTCache;
import org.modelio.gproject.monitor.GProjectEvent;
import org.modelio.gproject.monitor.GProjectMonitorSupport;
import org.modelio.gproject.monitor.IProjectMonitor;
import org.modelio.gproject.mtools.AuthTool;
import org.modelio.gproject.mtools.ModelTool;
import org.modelio.gproject.parts.GPartFactory;
import org.modelio.gproject.plugin.CoreProject;
import org.modelio.gproject.project.AbstractGProject;
import org.modelio.gproject.project.GProjectState;
import org.modelio.vbasic.auth.IAuthData;
import org.modelio.vbasic.collections.TopologicalSorter;
import org.modelio.vbasic.files.CloseOnFail;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.NullProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vbasic.version.Version;
import org.modelio.vbasic.version.VersionedItem;
import org.modelio.vcore.model.api.MTools;
import org.modelio.vcore.model.spi.IGMetamodelExtension;
import org.modelio.vcore.model.spi.mtools.IAuthTool;
import org.modelio.vcore.model.spi.mtools.IModelTool;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.session.impl.CoreSession;
import org.modelio.version.ModelioVersion;

public class GProject
extends AbstractGProject {
    private final GProjectDescriptor descriptor;
    private final List<IGPart> gParts = new CopyOnWriteArrayList<IGPart>();
    private final GProjectMonitorSupport monitorSupport = new GProjectMonitorSupport();
    private ProjectFileStructure pfs;
    private GProjectEnvironment projectEnvironment;
    private final GProjectState state;
    private ProjectLock projectLock;

    static {
        MTools.initializeMTools((IModelTool)new ModelTool(), (IAuthTool)new AuthTool());
    }

    @Override
    public void addGPart(IGPart gPart, boolean permanent) throws IGPart.GPartException {
        this.addGPart(null, gPart, permanent);
    }

    private IGPart findPart(String id, GProjectPartDescriptor.GProjectPartType type) {
        for (IGPart part : this.gParts) {
            if (!part.getId().equals(id) || !part.getType().equals((Object)type)) continue;
            return part;
        }
        return null;
    }

    private void checkDuplicatePart(GProjectPartDescriptor gPart) throws IGPart.GPartException {
        IGPart existingPart = this.findPart(gPart.getId(), gPart.getType());
        if (existingPart != null) {
            throw new IGPart.GPartException(String.format("Cannot add %s %s %s : The project already have a %s %s %s .", gPart.getType(), gPart.getId(), gPart.getVersion(), existingPart.getType(), existingPart.getId(), existingPart.getVersion()));
        }
    }

    @Override
    public void addGPart(IModelioProgress monitor, IGPart gPart, boolean permanent) throws IGPart.GPartException {
        IGProjectState.GProjectStateEnum s = this.state.getValue();
        if (s != IGProjectState.GProjectStateEnum.OPENING && s != IGProjectState.GProjectStateEnum.OPENED) {
            throw new IllegalStateException(String.format("Cannot add part %s when project is not opened (state=%s)...", new Object[]{gPart.getId(), s}));
        }
        this.checkDuplicatePart(gPart.getDescriptor());
        this.gParts.add(gPart);
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)5);
        gPart.install(this, (IModelioProgress)mon.newChild(1));
        gPart.mount((IModelioProgress)mon.newChild(1));
        if (permanent) {
            this.descriptor.getPartDescriptors().add(gPart.getDescriptor());
        }
    }

    @Override
    public void addGPartDescriptor(GProjectPartDescriptor newPartDesc) throws IGPart.GPartException {
        IGProjectState.GProjectStateEnum s = this.state.getValue();
        switch (s) {
            case NEW: 
            case SESSIONUP: {
                this.checkDuplicatePart(newPartDesc);
                this.descriptor.getPartDescriptors().add(newPartDesc);
                IGPart gPart = GPartFactory.getInstance().instantiate(newPartDesc);
                this.gParts.add(gPart);
                break;
            }
            case OPENING: 
            case OPENED: {
                this.checkDuplicatePart(newPartDesc);
                IGPart gPart = GPartFactory.getInstance().instantiate(newPartDesc);
                this.addGPart(gPart, true);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Cannot add part %s when project is in state=%s...", new Object[]{newPartDesc.getId(), s}));
            }
        }
    }

    private void lockProject() throws IOException {
        Files.createDirectories(this.pfs.getProjectRuntimePath(), new FileAttribute[0]);
        this.projectLock = ProjectLock.get(this.pfs.getProjectRuntimePath(), this.getName());
        this.projectLock.lock();
    }

    @Override
    public void close() {
        NullProgress aProgress = new NullProgress();
        this.getState().sendClosing((IModelioProgress)aProgress);
        this.unmountParts((IModelioProgress)aProgress);
        super.close();
        this.releaseLock();
        this.getState().sendClosed((IModelioProgress)aProgress);
    }

    private void releaseLock() {
        if (this.projectLock != null) {
            try {
                this.projectLock.close();
                this.projectLock = null;
            }
            catch (IOException e) {
                this.getMonitorSupport().fireMonitors(GProjectEvent.buildWarning((Object)this, e));
            }
        }
    }

    @Override
    public AuthDescriptor getAuth() {
        return this.descriptor.getAuthDescriptor();
    }

    @Override
    public GProjectDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Version getExpectedModelioVersion() {
        return this.descriptor.getModelioVersion();
    }

    @Override
    public GProjectMonitorSupport getMonitorSupport() {
        return this.monitorSupport;
    }

    @Override
    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public <T extends IGPart> List<T> getParts(Class<T> type) {
        return this.gParts.stream().filter(p -> type == null || type.isAssignableFrom(p.getClass())).map(type::cast).collect(Collectors.toList());
    }

    @Override
    public <T extends IGPart> T getPart(String partId, Class<T> partType) {
        Objects.requireNonNull(partType);
        return (T)((IGPart)this.gParts.stream().filter(p -> p.getId().equals(partId) && partType.isAssignableFrom(p.getClass())).map(partType::cast).findFirst().orElse(null));
    }

    @Override
    public ProjectFileStructure getPfs() {
        return this.pfs;
    }

    @Override
    public GProjectEnvironment getProjectEnvironment() {
        return this.projectEnvironment;
    }

    @Override
    public GProperties getProperties() {
        return this.descriptor.getProperties();
    }

    @Override
    public String getRemoteLocation() {
        return this.descriptor.getRemoteLocation();
    }

    @Override
    public GProjectState getState() {
        return this.state;
    }

    @Override
    public ProjectType getType() {
        String type = this.descriptor.getType();
        try {
            return ProjectType.valueOf((String)type);
        }
        catch (IllegalArgumentException e) {
            Log.error((String)"Invalid project type '%s', assume it is a local project.", (Object[])new Object[]{type});
            Log.trace((Throwable)e);
            return ProjectType.LOCAL;
        }
    }

    @Override
    public boolean isOpen() {
        return this.session != null;
    }

    public static GProject2Builder newBuilder(GProjectDescriptor projectDescriptor) {
        return new GProject2Builder(projectDescriptor);
    }

    @Override
    public void open(IModelioProgress aProgress) throws IOException, FileSystemException {
        SubProgress progress = SubProgress.convert((IModelioProgress)aProgress, (int)80);
        this.checkNotOpen();
        Version modelioVersion = this.descriptor.getModelioVersion();
        if (!ModelioVersion.isCompatible((Version)modelioVersion)) {
            String msg = modelioVersion == null ? CoreProject.I18N.getMessage("GProject.projectTooOld", new Object[]{this.getName(), ModelioVersion.MAJOR_MINOR.toString("V.R")}) : CoreProject.I18N.getMessage("GProject.modelioTooOld", new Object[]{this.getName(), modelioVersion.toString("V.R"), ModelioVersion.MAJOR_MINOR.toString("V.R")});
            throw new IOException(msg);
        }
        this.setModelioVersion(ModelioVersion.MAJOR_MINOR);
        this.lockProject();
        try {
            Throwable msg = null;
            Object var5_8 = null;
            try (CloseOnFail rollbacker = new CloseOnFail(this::closeProjectOnOpenFail);){
                this.session = new CoreSession();
                this.state.sendSessionUp(progress.newOptionalChild(10));
                progress.setWorkRemaining(60);
                this.mountMetamodelFragments(this.session, this.projectEnvironment.getDefaultMetamodelExtensions());
                progress.worked(20);
                this.session.mountNSURepository(this.pfs.getNsUseRepositoryPath(), progress.newChild(20));
                this.state.sendOpening(progress.newOptionalChild(10));
                progress.setWorkRemaining(50);
                this.installParts((IModelioProgress)progress.newChild(20));
                this.mountParts((IModelioProgress)progress.newChild(20));
                this.state.sendOpened(progress.newOptionalChild(10));
                rollbacker.success();
            }
            catch (Throwable throwable) {
                if (msg == null) {
                    msg = throwable;
                } else if (msg != throwable) {
                    msg.addSuppressed(throwable);
                }
                throw msg;
            }
        }
        catch (TopologicalSorter.CyclicDependencyException e) {
            this.problems.add(new GProblem(this.getDescriptor(), (Throwable)e));
        }
    }

    private void closeProjectOnOpenFail() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        if (this.projectLock != null) {
            try {
                this.projectLock.close();
                this.projectLock = null;
            }
            catch (IOException | RuntimeException e) {
                Log.trace((Throwable)e);
            }
        }
    }

    protected void mountParts(IModelioProgress aProgress) {
        SubProgress progress = SubProgress.convert((IModelioProgress)aProgress, (int)this.gParts.size());
        for (IGPart gPart : this.gParts) {
            try {
                gPart.mount((IModelioProgress)progress.newChild(1));
            }
            catch (RuntimeException | IGPart.GPartException e) {
                this.problems.add(new GProblem(gPart, (Throwable)e));
            }
        }
    }

    protected void installParts(IModelioProgress aProgress) {
        SubProgress progress = SubProgress.convert((IModelioProgress)aProgress, (int)this.gParts.size());
        for (IGPart gPart : this.gParts) {
            try {
                gPart.install(this, (IModelioProgress)progress.newChild(1));
            }
            catch (RuntimeException | IGPart.GPartException e) {
                this.problems.add(new GProblem(gPart, (Throwable)e));
            }
        }
    }

    protected void unmountParts(IModelioProgress aProgress) {
        SubProgress mon = SubProgress.convert((IModelioProgress)aProgress, (int)this.gParts.size());
        for (IGPart gPart : this.gParts) {
            try {
                gPart.unmount((IModelioProgress)mon.newChild(1));
            }
            catch (RuntimeException | IGPart.GPartException e) {
                this.problems.add(new GProblem(gPart, (Throwable)e));
            }
        }
    }

    @Override
    public void removeGPart(IGPart gPart) throws IGPart.GPartException {
        this.removeGPart(null, gPart);
    }

    @Override
    public void removeGPart(IModelioProgress monitor, IGPart gPart) throws IGPart.GPartException {
        IGProjectState.GProjectStateEnum s = this.state.getValue();
        if (s != IGProjectState.GProjectStateEnum.OPENING && s != IGProjectState.GProjectStateEnum.OPENED) {
            Log.error((String)"Cannot remove part %s when project is not opened (state=%s)...", (Object[])new Object[]{gPart.getId(), s});
            return;
        }
        if (this.gParts.contains(gPart)) {
            SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)2);
            gPart.unmount((IModelioProgress)mon.newChild(1));
            gPart.uninstall(this, (IModelioProgress)mon.newChild(1));
            this.gParts.remove(gPart);
            this.descriptor.getPartDescriptors().remove(gPart.getDescriptor());
        }
    }

    @Override
    public void removeGPartDescriptor(IModelioProgress monitor, GProjectPartDescriptor partDescriptor) throws IGPart.GPartException {
        IGProjectState.GProjectStateEnum s = this.state.getValue();
        switch (s) {
            case NEW: 
            case SESSIONUP: {
                for (IGPart existingPart : this.gParts) {
                    if (!existingPart.getId().equals(partDescriptor.getId()) || existingPart.getType() != partDescriptor.getType()) continue;
                    existingPart.uninstall(this, monitor);
                    this.gParts.remove(existingPart);
                }
                break;
            }
            case OPENING: 
            case OPENED: {
                for (IGPart existingPart : this.gParts) {
                    if (!existingPart.getId().equals(partDescriptor.getId()) || existingPart.getType() != partDescriptor.getType()) continue;
                    SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)2);
                    existingPart.unmount((IModelioProgress)mon.newChild(1));
                    existingPart.uninstall(this, (IModelioProgress)mon.newChild(1));
                    this.gParts.remove(existingPart);
                }
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Cannot remove part descriptor %s when project state is not 'new'd (state=%s)...", new Object[]{partDescriptor.getId(), s}));
            }
        }
        this.descriptor.getPartDescriptors().remove(partDescriptor);
    }

    @Override
    public void save(IModelioProgress progress) throws IOException {
        if (this.session != null) {
            this.session.save(progress);
        }
        new GProjectDescriptorWriter().write(this.descriptor);
    }

    @Override
    public void setName(String name) {
        this.descriptor.setName(name);
    }

    @Override
    public void setProperties(GProperties gProperties) {
        this.descriptor.setProperties(gProperties);
    }

    @Override
    public void setRemoteLocation(String remoteLocation) throws URISyntaxException {
    }

    protected final void checkNotOpen() throws IllegalStateException {
        if (this.session != null) {
            throw new IllegalStateException("'" + this.getName() + "' project already open.");
        }
    }

    protected void setModelioVersion(Version version) throws IOException {
        if (!ModelioVersion.isCompatible((Version)version)) {
            String msg = version == null ? CoreProject.I18N.getMessage("GProject.projectTooOld", new Object[]{this.getName(), ModelioVersion.MAJOR_MINOR.toString("V.R")}) : CoreProject.I18N.getMessage("GProject.modelioTooOld", new Object[]{this.getName(), version.toString("V.R"), ModelioVersion.MAJOR_MINOR.toString("V.R")});
            throw new IOException(msg);
        }
        this.descriptor.setModelioVersion(version);
    }

    private GProject(GProjectDescriptor descriptor) {
        this.descriptor = descriptor;
        this.state = new GProjectState(this);
    }

    private void mountMetamodelFragments(CoreSession aSession, Collection<IGMetamodelExtension> mmExtensions) throws TopologicalSorter.CyclicDependencyException {
        List sortedExtensions = new GMetamodelExtensionTopologicalSorter<IGMetamodelExtension>(mmExtensions).sort();
        for (IGMetamodelExtension mmExt : sortedExtensions) {
            aSession.getMetamodel().addMetamodelFragment(mmExt.getMmFragment());
            mmExt.register((ICoreSession)aSession);
        }
    }

    @Override
    public Collection<IGMetamodelExtension> getMetamodelExtensions() {
        return this.projectEnvironment.getDefaultMetamodelExtensions();
    }

    @Override
    public List<IGPart> getParts() {
        return Collections.unmodifiableList(this.gParts);
    }

    private static final class GMetamodelExtensionTopologicalSorter<T extends IGMetamodelExtension>
    extends TopologicalSorter<T> {
        private Collection<T> extensions = Collections.EMPTY_LIST;

        public GMetamodelExtensionTopologicalSorter(Collection<T> mmExtensions) {
            this.extensions = mmExtensions;
        }

        public Collection<T> getNodes() {
            return this.extensions;
        }

        public Collection<T> getAdjacent(T node) {
            Collection neededFragments = node.getMmFragment().getNeededFragments();
            if (neededFragments.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<IGMetamodelExtension> ret = new ArrayList<IGMetamodelExtension>(neededFragments.size());
            for (VersionedItem needed : neededFragments) {
                for (IGMetamodelExtension f : this.extensions) {
                    if (!f.getMmFragment().getName().equals(needed.getName())) continue;
                    ret.add(f);
                }
            }
            return ret;
        }
    }

    public static class GProject2Builder {
        private IProjectMonitor eventMonitor;
        private GProjectEnvironment projectEnv = new GProjectEnvironment();
        private GProjectDescriptor projectDescriptor;
        private IAuthData authData;
        private GProperties properties;
        private Version expectedModelioVersion;

        public GProject2Builder(GProjectDescriptor projectDescriptor) {
            this.projectDescriptor = projectDescriptor;
        }

        public GProject2Builder withAuth(IAuthData auth) {
            this.authData = auth;
            return this;
        }

        public GProject2Builder withMetamodelExtensions(Collection<IGMetamodelExtension> metamodelExtensions) {
            this.projectEnv.addMetamodelExtensions(metamodelExtensions);
            return this;
        }

        public GProject2Builder withEnvironment(IGProjectEnv aProjectEnv) {
            this.projectEnv.setModulesCache(aProjectEnv.getModulesCache() != null ? aProjectEnv.getModulesCache() : EmptyModuleCache.getInstance());
            this.projectEnv.addMetamodelExtensions(aProjectEnv.getDefaultMetamodelExtensions());
            this.projectEnv.setRamcCache(aProjectEnv.getRamcCache());
            return this;
        }

        public GProject2Builder withModuleCache(IModuleRTCache cache) {
            this.projectEnv.setModulesCache(cache);
            return this;
        }

        public GProject2Builder withEventMonitor(IProjectMonitor anEventMonitor) {
            this.eventMonitor = anEventMonitor;
            return this;
        }

        public IGProject build(IModelioProgress aMonitor) {
            SubProgress progress = SubProgress.convert((IModelioProgress)aMonitor);
            GProject project = new GProject(this.projectDescriptor);
            project.projectEnvironment = new GProjectEnvironment();
            this.projectDescriptor = this.migrateProjectSpace(this.projectDescriptor, project.projectEnvironment);
            project.pfs = new ProjectFileStructure(this.projectDescriptor.getProjectFileStructure().getProjectPath());
            if (this.authData != null) {
                this.projectDescriptor.setAuthDescriptor(new AuthDescriptor(this.authData, DefinitionScope.LOCAL));
            }
            project.projectEnvironment = this.projectEnv;
            if (project.projectEnvironment.getModulesCache() == null) {
                project.projectEnvironment.setModulesCache(EmptyModuleCache.getInstance());
            }
            if (this.eventMonitor != null) {
                project.monitorSupport.addMonitor(this.eventMonitor);
            }
            progress.setWorkRemaining(this.projectDescriptor.getPartDescriptors().size() + 2);
            for (GProjectPartDescriptor partDescriptor : this.projectDescriptor.getPartDescriptors()) {
                IGPart gPart = GPartFactory.getInstance().instantiate(partDescriptor);
                progress.worked(1);
                project.gParts.add(gPart);
            }
            project.getState().sendNew(progress.newOptionalChild(2));
            progress.done();
            return project;
        }

        private GProjectDescriptor migrateProjectSpace(GProjectDescriptor descriptor, GProjectEnvironment conf) {
            return descriptor;
        }
    }
}

