/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.project;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import org.modelio.gproject.auth.GProjectAuthenticationException;
import org.modelio.gproject.data.project.DefinitionScope;
import org.modelio.gproject.data.project.GProjectDescriptor;
import org.modelio.gproject.data.project.GProjectDescriptorReader;
import org.modelio.gproject.data.project.ILockInfo;
import org.modelio.gproject.data.project.ProjectFileStructure;
import org.modelio.gproject.lock.ProjectLock;
import org.modelio.vbasic.auth.IAuthData;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.net.UriAuthenticationException;
import org.modelio.vbasic.net.UriConnections;
import org.modelio.vbasic.net.UriUtils;
import org.modelio.vbasic.progress.IModelioProgress;
import org.xml.sax.InputSource;

public class GProjectDescriptorFactory {
    public static final String REMOTE_PROJECT_CONF = "project.server.conf";

    public static GProjectDescriptor getRemoteDescriptor(GProjectDescriptor localDescriptor, IAuthData authData, IModelioProgress monitor) throws IOException, GProjectAuthenticationException {
        InputSource is = GProjectDescriptorFactory.readRemoteDescriptor(localDescriptor, authData, monitor);
        try {
            GProjectDescriptor newServerDesc = new GProjectDescriptorReader().read(is, null);
            return newServerDesc;
        }
        catch (IOException e) {
            try {
                InputSource is2 = GProjectDescriptorFactory.readRemoteDescriptor(localDescriptor, authData, monitor);
                String content = FileUtils.readWhole((InputStream)is2.getByteStream(), (String)"utf-8");
                e.addSuppressed(new Throwable("Descriptor content:\n" + content));
            }
            catch (Exception e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    public static InputSource readRemoteDescriptor(GProjectDescriptor projectDescriptor, IAuthData authData, IModelioProgress monitor) throws IOException, GProjectAuthenticationException {
        URI remoteUri = UriUtils.asDirectoryUri((URI)GProjectDescriptorFactory.getRemoteDirUri(projectDescriptor));
        URI remoteConfUri = remoteUri.resolve(REMOTE_PROJECT_CONF);
        try {
            InputSource inputSource = new InputSource(UriConnections.openInputStream((URI)remoteConfUri, (IAuthData)authData));
            inputSource.setSystemId(remoteConfUri.toString());
            return inputSource;
        }
        catch (UriAuthenticationException e) {
            throw new GProjectAuthenticationException(FileUtils.getLocalizedMessage((IOException)((Object)e)), e);
        }
    }

    static URI getRemoteDirUri(GProjectDescriptor projectDescriptor) throws NoSuchFileException {
        try {
            return new URI(projectDescriptor.getRemoteLocation());
        }
        catch (URISyntaxException e) {
            NoSuchFileException e2 = new NoSuchFileException(projectDescriptor.getRemoteLocation(), null, e.getLocalizedMessage());
            e2.initCause(e);
            throw e2;
        }
    }

    public static boolean isProjectSpace(Path projectPath) {
        Path confFile = GProjectDescriptorFactory.getConfigFile(projectPath);
        return Files.isRegularFile(confFile, new LinkOption[0]);
    }

    public static GProjectDescriptor readProjectDirectory(Path projectDir) throws IOException {
        Path confFile = GProjectDescriptorFactory.getConfigFile(projectDir);
        GProjectDescriptor desc = new GProjectDescriptorReader().setDefaultScope(DefinitionScope.LOCAL).read(confFile, null);
        try {
            desc.setLockInfo(GProjectDescriptorFactory.getLockInformations(desc));
        }
        catch (IOException e) {
            Log.trace((String)("Cannot get lock informations on " + String.valueOf(projectDir) + ":"));
            Log.trace((Throwable)e);
        }
        return desc;
    }

    private static Path getConfigFile(Path projectPath) {
        return new ProjectFileStructure(projectPath).getProjectConfFile();
    }

    public static ILockInfo getLockInformations(GProjectDescriptor desc) throws IOException {
        ProjectLock locker = ProjectLock.get(desc.getProjectFileStructure().getProjectRuntimePath(), desc.getName());
        return locker.test();
    }

    private GProjectDescriptorFactory() {
    }
}

