/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.project;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import org.modelio.gproject.core.IGProject;
import org.modelio.gproject.core.IGProjectState;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.OptionalProgress;
import org.modelio.vbasic.progress.SubProgress;

public class GProjectState
implements IGProjectState {
    private IGProjectState.GProjectStateEnum currentState = IGProjectState.GProjectStateEnum.INITIAL;
    private final IGProject project;
    private final List<IGProjectState.IProjectStateChangeListener> listeners = new CopyOnWriteArrayList<IGProjectState.IProjectStateChangeListener>();

    public GProjectState(IGProject project) {
        this.project = project;
    }

    @Override
    public IGProjectState.GProjectStateEnum getValue() {
        return this.currentState;
    }

    private void setValue(IModelioProgress monitor, IGProjectState.GProjectStateEnum newState) {
        this.currentState = newState;
        this.fireListeners(monitor);
    }

    @Override
    public IGProjectState.GProjectStateEnum sendNew(IModelioProgress supplier) throws IllegalStateException {
        if (this.currentState != IGProjectState.GProjectStateEnum.INITIAL) {
            IllegalStateException e = new IllegalStateException(String.format("'%s' project 'new' transition not allowed from state '%s'", new Object[]{this.project.getName(), this.currentState}));
            Log.trace((Throwable)e);
            throw e;
        }
        this.setValue(supplier, IGProjectState.GProjectStateEnum.NEW);
        return this.currentState;
    }

    public IGProjectState.GProjectStateEnum sendClosing(IModelioProgress supplier) throws IllegalStateException {
        switch (this.currentState) {
            case SESSIONUP: 
            case OPENING: 
            case OPENED: {
                break;
            }
            default: {
                IllegalStateException e = new IllegalStateException(String.format("'%s' project 'closing' transition not allowed from state '%s'", this.project.getName(), this.currentState.name()));
                Log.trace((Throwable)e);
                throw e;
            }
        }
        this.setValue(supplier, IGProjectState.GProjectStateEnum.CLOSING);
        return this.currentState;
    }

    public IGProjectState.GProjectStateEnum sendClosed(IModelioProgress monitorSupplier) throws IllegalStateException {
        if (this.currentState != IGProjectState.GProjectStateEnum.CLOSING) {
            IllegalStateException e = new IllegalStateException(String.format("'%s' project 'closed' transition not allowed from state '%s'", new Object[]{this.project.getName(), this.currentState}));
            Log.trace((Throwable)e);
            throw e;
        }
        this.setValue(monitorSupplier, IGProjectState.GProjectStateEnum.CLOSED);
        return this.currentState;
    }

    @Override
    public IGProjectState.GProjectStateEnum sendSessionUp(IModelioProgress monitorSupplier) throws IllegalStateException {
        if (this.currentState != IGProjectState.GProjectStateEnum.NEW) {
            IllegalStateException e = new IllegalStateException(String.format("'%s' project 'Session up' transition not allowed from state '%s'", new Object[]{this.project.getName(), this.currentState}));
            Log.trace((Throwable)e);
            throw e;
        }
        this.setValue(monitorSupplier, IGProjectState.GProjectStateEnum.SESSIONUP);
        return this.currentState;
    }

    @Override
    public IGProjectState.GProjectStateEnum sendOpening(IModelioProgress monitorSupplier) throws IllegalStateException {
        if (this.currentState != IGProjectState.GProjectStateEnum.SESSIONUP) {
            IllegalStateException e = new IllegalStateException(String.format("'%s' project 'opening' transition not allowed from state '%s'", new Object[]{this.project.getName(), this.currentState}));
            Log.trace((Throwable)e);
            throw e;
        }
        this.setValue(monitorSupplier, IGProjectState.GProjectStateEnum.OPENING);
        return this.currentState;
    }

    @Override
    public IGProjectState.GProjectStateEnum sendOpened(IModelioProgress monitorSupplier) throws IllegalStateException {
        if (this.currentState != IGProjectState.GProjectStateEnum.OPENING) {
            IllegalStateException e = new IllegalStateException(String.format("'%s' project 'opened' transition not allowed from state '%d'", new Object[]{this.project.getName(), this.currentState}));
            Log.trace((Throwable)e);
            throw e;
        }
        this.setValue(monitorSupplier, IGProjectState.GProjectStateEnum.OPENED);
        return this.currentState;
    }

    private void fireListeners(IModelioProgress monitorSupplier) {
        SubSubMonitorSupplier mon = new SubSubMonitorSupplier(monitorSupplier);
        for (IGProjectState.IProjectStateChangeListener listener : this.listeners) {
            listener.stateChanged(mon.createChild(), this.currentState);
        }
    }

    @Override
    public void addListener(IGProjectState.IProjectStateChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IGProjectState.IProjectStateChangeListener listener) {
        this.listeners.remove(listener);
    }

    private static class SubSubMonitorSupplier
    implements Supplier<IModelioProgress> {
        private final IModelioProgress root;
        private SubProgress subProgress;

        public SubSubMonitorSupplier(IModelioProgress root) {
            this.root = root;
        }

        @Override
        public IModelioProgress get() {
            if (this.subProgress == null) {
                this.subProgress = SubProgress.convert((IModelioProgress)this.root);
            }
            this.subProgress.setWorkRemaining(4);
            return this.subProgress.newOptionalChild(1);
        }

        public IModelioProgress createChild() {
            return new OptionalProgress(this.root, (Supplier)this);
        }
    }
}

