/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.ramc;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.modelio.gproject.GProjectCreator;
import org.modelio.gproject.core.IGProject;
import org.modelio.gproject.data.module.jaxbv2.Jxbv2Enumeration;
import org.modelio.gproject.data.module.jaxbv2.Jxbv2ExternDocumentType;
import org.modelio.gproject.data.module.jaxbv2.Jxbv2Module;
import org.modelio.gproject.data.module.jaxbv2.Jxbv2NoteType;
import org.modelio.gproject.data.module.jaxbv2.Jxbv2PropertyDefinition;
import org.modelio.gproject.data.module.jaxbv2.Jxbv2PropertyTableDefinition;
import org.modelio.gproject.data.module.jaxbv2.Jxbv2PropertyType;
import org.modelio.gproject.data.module.jaxbv2.Jxbv2StereotypeRef;
import org.modelio.gproject.data.module.jaxbv2.Jxbv2TagType;
import org.modelio.gproject.data.project.GProjectDescriptor;
import org.modelio.gproject.project.GProject;
import org.modelio.gproject.ramc.core.model.ModelComponent;
import org.modelio.gproject.ramc.core.packaging.IModelComponentContributor;
import org.modelio.gproject.ramc.core.packaging.RamcPackager;
import org.modelio.metamodel.mda.ModuleComponent;
import org.modelio.metamodel.mda.ModuleParameter;
import org.modelio.metamodel.mda.Project;
import org.modelio.metamodel.uml.infrastructure.Element;
import org.modelio.metamodel.uml.infrastructure.MetaclassReference;
import org.modelio.metamodel.uml.infrastructure.ModelElement;
import org.modelio.metamodel.uml.infrastructure.Note;
import org.modelio.metamodel.uml.infrastructure.NoteType;
import org.modelio.metamodel.uml.infrastructure.Profile;
import org.modelio.metamodel.uml.infrastructure.ResourceType;
import org.modelio.metamodel.uml.infrastructure.Stereotype;
import org.modelio.metamodel.uml.infrastructure.TagType;
import org.modelio.metamodel.uml.infrastructure.properties.EnumeratedPropertyType;
import org.modelio.metamodel.uml.infrastructure.properties.PropertyBaseType;
import org.modelio.metamodel.uml.infrastructure.properties.PropertyDefinition;
import org.modelio.metamodel.uml.infrastructure.properties.PropertyEnumerationLitteral;
import org.modelio.metamodel.uml.infrastructure.properties.PropertyTableDefinition;
import org.modelio.metamodel.uml.infrastructure.properties.PropertyType;
import org.modelio.metamodel.uml.statik.Artifact;
import org.modelio.metamodel.uml.statik.Package;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vbasic.version.Version;
import org.modelio.vcore.model.spi.IGMetamodelExtension;
import org.modelio.vcore.session.api.IAccessManager;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.session.api.repository.IRepository;
import org.modelio.vcore.session.api.transactions.ITransaction;
import org.modelio.vcore.session.impl.CoreSession;
import org.modelio.vcore.session.impl.GenericFactory;
import org.modelio.vcore.session.impl.SmFactory;
import org.modelio.vcore.session.impl.permission.BasicAccessManager;
import org.modelio.vcore.session.impl.storage.memory.MemoryRepository;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vcore.smkernel.meta.SmClass;
import org.modelio.vcore.smkernel.meta.SmMetamodel;
import org.modelio.version.ModelioVersion;

public class RamcBuilder {
    private final Jxbv2Module loadedModule;
    private final Map<String, PropertyType> propertyTypeCache = new HashMap<String, PropertyType>();
    private final Collection<IGMetamodelExtension> metamodelExtensions;

    public RamcBuilder(Collection<IGMetamodelExtension> metamodelExtensions, Jxbv2Module loadedModule) {
        this.metamodelExtensions = metamodelExtensions;
        this.loadedModule = loadedModule;
    }

    public void createRamc(Path ramcPath, IModelioProgress monitor) throws IOException {
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)60);
        Path tempDirectory = Files.createTempDirectory("ModelioCatalog", new FileAttribute[0]);
        Files.createDirectories(ramcPath.getParent(), new FileAttribute[0]);
        GProjectDescriptor projectDescriptor = GProjectCreator.buildEmptyProject(this.loadedModule.getId(), tempDirectory, ModelioVersion.VERSION);
        gproject.open((IModelioProgress)mon.newChild(10));
        try (IGProject gproject = GProject.newBuilder(projectDescriptor).withMetamodelExtensions(this.metamodelExtensions).build((IModelioProgress)mon.newChild(10));){
            DescriptionContributor contributor = new DescriptionContributor((CoreSession)gproject.getSession());
            Artifact artifact = this.createRamcModel(gproject, (IModelioProgress)mon.newChild(10));
            RamcPackager packager = new RamcPackager(gproject, artifact, ramcPath, Arrays.asList(contributor));
            packager.setIncludeArtifact(false);
            packager.run((IModelioProgress)mon.newChild(30));
        }
        try {
            FileUtils.delete((Path)tempDirectory);
        }
        catch (IOException e) {
            Log.warning((Throwable)e);
        }
    }

    private MetaclassReference createMetaclassReference(ModelFactory modelfactory, Jxbv2Module.Jxbv2Profiles.Jxbv2Profile.Jxbv2MetaclassReference loadedRef, Profile profile) {
        Jxbv2PropertyTableDefinition loadedTableType;
        MetaclassReference mcRef = modelfactory.createMetaclassReference(loadedRef, profile);
        if (loadedRef.getTagTypes() != null) {
            for (Jxbv2TagType loadedTagType : loadedRef.getTagTypes().getTagType()) {
                modelfactory.createTagType(loadedTagType, (Element)mcRef);
            }
        }
        if (loadedRef.getNoteTypes() != null) {
            for (Jxbv2NoteType loadedNoteType : loadedRef.getNoteTypes().getNoteType()) {
                modelfactory.createNoteType(loadedNoteType, (Element)mcRef);
            }
        }
        if (loadedRef.getExternDocumentTypes() != null) {
            for (Jxbv2ExternDocumentType loadedDocumentType : loadedRef.getExternDocumentTypes().getExternDocumentType()) {
                modelfactory.createResourceType(loadedDocumentType, (Element)mcRef);
            }
        }
        if ((loadedTableType = loadedRef.getPropertyTable()) != null) {
            this.createTableType(modelfactory, loadedTableType, (Element)mcRef);
        }
        return mcRef;
    }

    private Profile createProfile(ModelFactory modelfactory, Jxbv2Module.Jxbv2Profiles.Jxbv2Profile loadedProfile, ModuleComponent module) {
        Profile profile = modelfactory.createProfile(loadedProfile, module);
        for (Jxbv2Module.Jxbv2Profiles.Jxbv2Profile.Jxbv2Stereotype loadedStereotype : loadedProfile.getStereotype()) {
            this.createStereotype(modelfactory, loadedStereotype, profile);
        }
        for (Jxbv2Module.Jxbv2Profiles.Jxbv2Profile.Jxbv2MetaclassReference loadedRef : loadedProfile.getMetaclassReference()) {
            this.createMetaclassReference(modelfactory, loadedRef, profile);
        }
        return profile;
    }

    private Artifact createRamcModel(IGProject gproject, IModelioProgress monitor) throws IOException {
        ICoreSession session = gproject.getSession();
        MemoryRepository repo = new MemoryRepository();
        session.getRepositorySupport().connectRepository((IRepository)repo, (IAccessManager)new BasicAccessManager(), monitor);
        ModelFactory modelfactory = new ModelFactory(session, (IRepository)repo);
        Throwable throwable = null;
        Object var7_8 = null;
        try (ITransaction t = session.getTransactionSupport().createTransaction("Create " + this.loadedModule.getId() + " module RAMC");){
            GenericFactory gf = session.getModel().getGenericFactory();
            Project ramcProject = (Project)gf.create(Project.class, (IRepository)repo);
            Package ramcProjectRoot = (Package)gf.create(Package.class, (IRepository)repo);
            ramcProject.getModel().add((Object)ramcProjectRoot);
            ModuleComponent module = modelfactory.createModule(this.loadedModule);
            if (this.loadedModule.getPropertyTypes() != null) {
                for (Jxbv2PropertyType loadedPropertyType : this.loadedModule.getPropertyTypes().getPropertyType()) {
                    modelfactory.createPropertyType(loadedPropertyType, module);
                }
            }
            for (PropertyType pType : session.getModel().findByClass(PropertyType.class)) {
                this.propertyTypeCache.put(pType.getName(), pType);
            }
            if (this.loadedModule.getProfiles() != null) {
                for (Jxbv2Module.Jxbv2Profiles.Jxbv2Profile loadedProfile : this.loadedModule.getProfiles().getProfile()) {
                    this.createProfile(modelfactory, loadedProfile, module);
                }
            }
            if (this.loadedModule.getParameters() != null) {
                for (Jxbv2Module.Jxbv2Parameters.Jxbv2Parameter loadedParam : this.loadedModule.getParameters().getParameter()) {
                    modelfactory.createConfigParam(loadedParam, module);
                }
            }
            if (this.loadedModule.getProfiles() != null) {
                for (Jxbv2Module.Jxbv2Profiles.Jxbv2Profile profileDesc : this.loadedModule.getProfiles().getProfile()) {
                    for (Jxbv2Module.Jxbv2Profiles.Jxbv2Profile.Jxbv2Stereotype stereotypeDesc : profileDesc.getStereotype()) {
                        String parentStereotypeId = stereotypeDesc.getOwnerStereotype();
                        if (parentStereotypeId == null || parentStereotypeId.isEmpty()) continue;
                        Stereotype current = (Stereotype)session.getModel().findById(Stereotype.class, stereotypeDesc.getUid());
                        current.setParent(modelfactory.getStereotype(session, parentStereotypeId));
                    }
                }
            }
            Artifact ramcArtifact = (Artifact)gf.create(Artifact.class, (MObject)ramcProjectRoot);
            ramcProjectRoot.getOwnedElement().add((Object)ramcArtifact);
            ramcArtifact.setName(this.loadedModule.getId());
            ModelComponent ramcFact = new ModelComponent(ramcArtifact);
            ramcFact.setRamcName(this.loadedModule.getId());
            ramcFact.setRamcVersion(new Version(this.loadedModule.getVersion()));
            ramcFact.setProvider("Module " + this.loadedModule.getId());
            ramcFact.getExportedElements().add((Element)module);
            ramcFact.updateArtifact();
            t.commit();
            return ramcArtifact;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Stereotype createStereotype(ModelFactory modelfactory, Jxbv2Module.Jxbv2Profiles.Jxbv2Profile.Jxbv2Stereotype loadedStereotype, Profile profile) {
        Jxbv2PropertyTableDefinition loadedTableType;
        Stereotype stereotype = modelfactory.createStereotype(loadedStereotype, profile);
        if (loadedStereotype.getTagTypes() != null) {
            for (Jxbv2TagType loadedTagType : loadedStereotype.getTagTypes().getTagType()) {
                modelfactory.createTagType(loadedTagType, (Element)stereotype);
            }
        }
        if (loadedStereotype.getNoteTypes() != null) {
            for (Jxbv2NoteType loadedNoteType : loadedStereotype.getNoteTypes().getNoteType()) {
                modelfactory.createNoteType(loadedNoteType, (Element)stereotype);
            }
        }
        if (loadedStereotype.getExternDocumentTypes() != null) {
            for (Jxbv2ExternDocumentType loadedDocumentType : loadedStereotype.getExternDocumentTypes().getExternDocumentType()) {
                modelfactory.createResourceType(loadedDocumentType, (Element)stereotype);
            }
        }
        if ((loadedTableType = loadedStereotype.getPropertyTable()) != null) {
            this.createTableType(modelfactory, loadedTableType, (Element)stereotype);
        }
        return stereotype;
    }

    private void createTableType(ModelFactory modelfactory, Jxbv2PropertyTableDefinition loadedTableType, Element owner) {
        PropertyTableDefinition tableType = modelfactory.createTableType(loadedTableType, owner);
        for (Jxbv2PropertyDefinition loadedPropertyDefinition : loadedTableType.getPropertyDefinition()) {
            PropertyType pType;
            String refId = loadedPropertyDefinition.getTypeRef().getId();
            if (refId.startsWith("mref#")) {
                MRef ref = new MRef(refId.substring(5));
                pType = (PropertyType)modelfactory.getObjectReference(modelfactory.metamodel.getMClass(ref.mc).getJavaInterface(), ref.uuid, ref.name);
            } else {
                pType = modelfactory.getObjectReference(PropertyType.class, refId, "");
            }
            modelfactory.createPropertyDefinition(loadedPropertyDefinition, tableType, pType);
        }
    }

    private static class DescriptionContributor
    implements IModelComponentContributor {
        private CoreSession session;

        public DescriptionContributor(CoreSession session) {
            this.session = session;
        }

        @Override
        public Set<TagType> getTagTypes() {
            return Collections.emptySet();
        }

        @Override
        public Set<NoteType> getNoteTypes() {
            HashSet<NoteType> notes = new HashSet<NoteType>();
            Throwable throwable = null;
            Object var3_4 = null;
            try (ITransaction t = this.session.getTransactionSupport().createTransaction("Create description note type");){
                notes.add((NoteType)this.session.getSmFactory().getObjectReference(this.session.getMetamodel().getMClass(NoteType.class), "00000000-0000-3e81-0000-000000000000", "description"));
                t.commit();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return notes;
        }

        @Override
        public Set<IModelComponentContributor.ExportedFileEntry> getFiles() {
            return Collections.emptySet();
        }

        @Override
        public Set<MObject> getElements() {
            return Collections.emptySet();
        }

        @Override
        public Set<Stereotype> getDependencyStereotypes() {
            HashSet<Stereotype> stereotypes = new HashSet<Stereotype>();
            Throwable throwable = null;
            Object var3_4 = null;
            try (ITransaction t = this.session.getTransactionSupport().createTransaction("Create manifestation stereotype");){
                stereotypes.add((Stereotype)this.session.getSmFactory().getObjectReference(this.session.getMetamodel().getMClass(Stereotype.class), "d5bccf8e-79b3-48df-8c79-09200aa52d19", "manifestation"));
                t.commit();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return stereotypes;
        }
    }

    static class ModelFactory {
        private final SmFactory model;
        private final IRepository repo;
        private final SmMetamodel metamodel;

        public ModelFactory(ICoreSession session, IRepository repo) {
            this.model = ((CoreSession)session).getSmFactory();
            this.repo = repo;
            this.metamodel = session.getMetamodel();
        }

        /*
         * Exception decompiling
         */
        public ModuleParameter createConfigParam(Jxbv2Module.Jxbv2Parameters.Jxbv2Parameter loadedParameter, ModuleComponent owner) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[10] lbl74 : CaseStatement: default:\u000a, @NONE, blocks:[10] lbl74 : CaseStatement: default:\u000a]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
             *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
             *     at java.base/java.util.TimSort.sort(TimSort.java:220)
             *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
             *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
             *     at java.base/java.util.Collections.sort(Collections.java:178)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public ResourceType createResourceType(Jxbv2ExternDocumentType loadedResourceType, Element owner) {
            ResourceType element = (ResourceType)this.model.createObject(this.getClass(ResourceType.class), this.repo, loadedResourceType.getUid());
            element.setName(loadedResourceType.getName());
            if (loadedResourceType.getIsHidden() != null) {
                element.setIsHidden(loadedResourceType.getIsHidden().equals("true"));
            }
            element.setLabelKey(loadedResourceType.getLabel() != null ? loadedResourceType.getLabel() : loadedResourceType.getName());
            if (owner instanceof Stereotype) {
                element.setOwnerStereotype((Stereotype)owner);
            } else if (owner instanceof MetaclassReference) {
                element.setOwnerReference((MetaclassReference)owner);
            }
            if (loadedResourceType.getExtensions() != null) {
                this.applyStereotypeRefs((ModelElement)element, loadedResourceType.getExtensions().getStereotypeRef());
            }
            return element;
        }

        public PropertyTableDefinition createTableType(Jxbv2PropertyTableDefinition loadedTableType, Element owner) {
            PropertyTableDefinition element = (PropertyTableDefinition)this.model.createObject(this.getClass(PropertyTableDefinition.class), this.repo, loadedTableType.getUid());
            if (owner instanceof Stereotype) {
                element.setOwnerStereotype((Stereotype)owner);
                if (element.getOwnerReference() != null) {
                    element.setOwnerReference(null);
                }
            } else if (owner instanceof MetaclassReference) {
                element.setOwnerReference((MetaclassReference)owner);
                if (element.getOwnerStereotype() != null) {
                    element.setOwnerStereotype(null);
                }
            }
            element.setName(loadedTableType.getId());
            if (loadedTableType.getExtensions() != null) {
                this.applyStereotypeRefs((ModelElement)element, loadedTableType.getExtensions().getStereotypeRef());
            }
            return element;
        }

        public MetaclassReference createMetaclassReference(Jxbv2Module.Jxbv2Profiles.Jxbv2Profile.Jxbv2MetaclassReference loadedMetaclassReference, Profile owner) {
            MetaclassReference element = (MetaclassReference)this.model.createObject(this.getClass(MetaclassReference.class), this.repo, loadedMetaclassReference.getUid());
            element.setReferencedClassName(loadedMetaclassReference.getMetaclass());
            element.setOwnerProfile(owner);
            return element;
        }

        public ModuleComponent createModule(Jxbv2Module loadedModule) {
            ModuleComponent element = (ModuleComponent)this.model.createObject(this.getClass(ModuleComponent.class), this.repo, loadedModule.getUid());
            Version version = new Version(loadedModule.getVersion());
            element.setMajVersion(version.getMajorVersion());
            element.setMinVersion(version.getMinorVersion());
            element.setMinMinVersion(Integer.toString(version.getBuildVersion()));
            element.setName(loadedModule.getId());
            element.setJavaClassName(loadedModule.getClazz());
            return element;
        }

        public NoteType createNoteType(Jxbv2NoteType loadedNoteType, Element owner) {
            NoteType element = (NoteType)this.model.createObject(this.getClass(NoteType.class), this.repo, loadedNoteType.getUid());
            element.setName(loadedNoteType.getName());
            if (loadedNoteType.getIsHidden() != null) {
                element.setIsHidden(loadedNoteType.getIsHidden().equals("true"));
            }
            if (loadedNoteType.getMimeType() != null) {
                element.setMimeType(loadedNoteType.getMimeType());
            } else {
                element.setMimeType("text/plain");
            }
            element.setLabelKey(loadedNoteType.getLabel() != null ? loadedNoteType.getLabel() : loadedNoteType.getName());
            if (owner instanceof Stereotype) {
                element.setOwnerStereotype((Stereotype)owner);
                if (element.getOwnerReference() != null) {
                    element.setOwnerReference(null);
                }
            } else if (owner instanceof MetaclassReference) {
                element.setOwnerReference((MetaclassReference)owner);
                if (element.getOwnerStereotype() != null) {
                    element.setOwnerStereotype(null);
                }
            }
            if (loadedNoteType.getExtensions() != null) {
                this.applyStereotypeRefs((ModelElement)element, loadedNoteType.getExtensions().getStereotypeRef());
            }
            return element;
        }

        public Profile createProfile(Jxbv2Module.Jxbv2Profiles.Jxbv2Profile loadedProfile, ModuleComponent owner) {
            Profile element = (Profile)this.model.createObject(this.getClass(Profile.class), this.repo, loadedProfile.getUid());
            element.setName(loadedProfile.getId());
            element.setOwnerModule(owner);
            if (loadedProfile.getExtensions() != null) {
                this.applyStereotypeRefs((ModelElement)element, loadedProfile.getExtensions().getStereotypeRef());
            }
            return element;
        }

        public Stereotype createStereotype(Jxbv2Module.Jxbv2Profiles.Jxbv2Profile.Jxbv2Stereotype loadedStereotype, Profile owner) {
            Jxbv2Module.Jxbv2Profiles.Jxbv2Profile.Jxbv2Stereotype.Jxbv2Image image;
            Stereotype element = (Stereotype)this.model.createObject(this.getClass(Stereotype.class), this.repo, loadedStereotype.getUid());
            element.setIsAbstract(loadedStereotype.isIsAbstract());
            element.setName(loadedStereotype.getName());
            element.setOwner(owner);
            Jxbv2Module.Jxbv2Profiles.Jxbv2Profile.Jxbv2Stereotype.Jxbv2Icon icon = loadedStereotype.getIcon();
            if (icon != null && icon.getPath() != null) {
                element.setIcon(icon.getPath());
            }
            if ((image = loadedStereotype.getImage()) != null && image.getPath() != null) {
                element.setImage(image.getPath());
            }
            if (loadedStereotype.getIsHidden() != null) {
                element.setIsHidden(loadedStereotype.getIsHidden().equals("true"));
            }
            if (loadedStereotype.getMetaclass() != null) {
                element.setBaseClassName(loadedStereotype.getMetaclass());
            }
            element.setLabelKey(loadedStereotype.getLabel() != null ? loadedStereotype.getLabel() : loadedStereotype.getName());
            if (loadedStereotype.getExtensions() != null) {
                this.applyStereotypeRefs((ModelElement)element, loadedStereotype.getExtensions().getStereotypeRef());
            }
            return element;
        }

        public TagType createTagType(Jxbv2TagType loadedTagType, Element owner) {
            TagType element = (TagType)this.model.createObject(this.getClass(TagType.class), this.repo, loadedTagType.getUid());
            element.setName(loadedTagType.getName());
            if (loadedTagType.getIsHidden() != null) {
                element.setIsHidden(loadedTagType.getIsHidden().equals("true"));
            }
            element.setLabelKey(loadedTagType.getLabel() != null ? loadedTagType.getLabel() : loadedTagType.getName());
            if (loadedTagType.getParameterCard() != null) {
                element.setParamNumber(loadedTagType.getParameterCard());
            }
            if (loadedTagType.getIsSigned() != null) {
                element.setBelongToPrototype(loadedTagType.getIsSigned().equals("true"));
            }
            if (owner instanceof Stereotype) {
                element.setOwnerStereotype((Stereotype)owner);
                if (element.getOwnerReference() != null) {
                    element.setOwnerReference(null);
                }
            } else if (owner instanceof MetaclassReference) {
                element.setOwnerReference((MetaclassReference)owner);
                if (element.getOwnerStereotype() != null) {
                    element.setOwnerStereotype(null);
                }
            }
            if (loadedTagType.getExtensions() != null) {
                this.applyStereotypeRefs((ModelElement)element, loadedTagType.getExtensions().getStereotypeRef());
            }
            return element;
        }

        public PropertyDefinition createPropertyDefinition(Jxbv2PropertyDefinition loadedPropertyDefinition, PropertyTableDefinition owner, PropertyType pType) {
            PropertyDefinition element = (PropertyDefinition)this.model.createObject(this.getClass(PropertyDefinition.class), this.repo, loadedPropertyDefinition.getUid());
            element.setName(loadedPropertyDefinition.getId());
            element.setDefaultValue(loadedPropertyDefinition.getDefaultValue());
            element.setIsEditable(loadedPropertyDefinition.isIsEditable());
            element.setType(pType);
            element.setOwner(owner);
            if (loadedPropertyDefinition.getDescription() != null && !loadedPropertyDefinition.getDescription().isEmpty()) {
                this.createDescriptionNote((ModelElement)element, loadedPropertyDefinition.getDescription());
            }
            for (Jxbv2PropertyDefinition.Jxbv2Parameter parameter : loadedPropertyDefinition.getParameter()) {
                element.setProperty("Constraints", parameter.getName(), parameter.getValue());
            }
            return element;
        }

        public PropertyType createPropertyType(Jxbv2PropertyType loadedPropertyType, ModuleComponent owner) {
            PropertyBaseType baseType;
            try {
                baseType = PropertyBaseType.valueOf((String)loadedPropertyType.getType().toUpperCase());
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                baseType = PropertyBaseType.TEXT;
            }
            PropertyType element = baseType == PropertyBaseType.ENUMERATE ? this.createEnumeratedPropertyType(loadedPropertyType, owner) : this.createPropertyType(owner, loadedPropertyType, baseType);
            if (loadedPropertyType.getDescription() != null && !loadedPropertyType.getDescription().isEmpty()) {
                this.createDescriptionNote((ModelElement)element, loadedPropertyType.getDescription());
            }
            if (loadedPropertyType.getExtensions() != null) {
                this.applyStereotypeRefs((ModelElement)element, loadedPropertyType.getExtensions().getStereotypeRef());
            }
            return element;
        }

        public SmClass getClass(Class<? extends MObject> cls) {
            return this.metamodel.getMClass(cls);
        }

        public <T extends MObject> T getObjectReference(Class<T> cls, String uuid, String name) {
            return (T)((MObject)cls.cast(this.model.getObjectReference(this.metamodel.getMClass(cls), uuid, name)));
        }

        private PropertyType createEnumeratedPropertyType(Jxbv2PropertyType loadedPropertyType, ModuleComponent owner) {
            EnumeratedPropertyType element = (EnumeratedPropertyType)this.model.createObject(this.getClass(EnumeratedPropertyType.class), this.repo, loadedPropertyType.getUid());
            element.setName(loadedPropertyType.getId());
            element.setModuleOwner(owner);
            element.setBaseType(PropertyBaseType.ENUMERATE);
            for (Jxbv2Enumeration.Jxbv2Literal loadedLiteral : loadedPropertyType.getEnumeration().getLiteral()) {
                this.createPropertyEnumerationLitteral(loadedLiteral, element);
            }
            if (loadedPropertyType.getExtensions() != null) {
                this.applyStereotypeRefs((ModelElement)element, loadedPropertyType.getExtensions().getStereotypeRef());
            }
            return element;
        }

        private PropertyEnumerationLitteral createPropertyEnumerationLitteral(Jxbv2Enumeration.Jxbv2Literal loadedLiteral, EnumeratedPropertyType element) {
            PropertyEnumerationLitteral litteral = (PropertyEnumerationLitteral)this.model.createObject(this.getClass(PropertyEnumerationLitteral.class), this.repo);
            litteral.setName(loadedLiteral.getValue());
            litteral.setOwner(element);
            if (loadedLiteral.getExtensions() != null) {
                this.applyStereotypeRefs((ModelElement)element, loadedLiteral.getExtensions().getStereotypeRef());
            }
            return litteral;
        }

        private PropertyType createPropertyType(ModuleComponent owner, Jxbv2PropertyType loadedPropertyType, PropertyBaseType baseType) {
            PropertyType element = (PropertyType)this.model.createObject(this.getClass(PropertyType.class), this.repo, loadedPropertyType.getUid());
            element.setName(loadedPropertyType.getId());
            element.setModuleOwner(owner);
            element.setBaseType(baseType);
            return element;
        }

        private void createDescriptionNote(ModelElement modelElement, String noteContent) {
            Note descriptionNote = (Note)this.model.createObject(this.getClass(Note.class), this.repo);
            descriptionNote.setContent(noteContent);
            descriptionNote.setSubject(modelElement);
            descriptionNote.setMimeType("text/plain");
            descriptionNote.setModel(this.getObjectReference(NoteType.class, "00000000-0000-3e81-0000-000000000000", "description"));
        }

        private void applyStereotypeRefs(ModelElement element, List<Jxbv2StereotypeRef> refs) {
            CoreSession session = CoreSession.getSession((MObject)element);
            for (Jxbv2StereotypeRef stereotypeRef : refs) {
                String uuid = stereotypeRef.getUid();
                if (uuid == null || uuid.isEmpty()) continue;
                element.getExtension().add((Object)this.getStereotype((ICoreSession)session, uuid));
            }
        }

        public Stereotype getStereotype(ICoreSession session, String uuid) {
            Stereotype stereotype = null;
            if (uuid.startsWith("mref#")) {
                MRef ref = new MRef(uuid.substring(5));
                stereotype = this.getObjectReference(Stereotype.class, ref.uuid, ref.name);
            } else {
                Collection owners = session.getModel().findByName(Stereotype.class, true, uuid);
                stereotype = !owners.isEmpty() ? (Stereotype)owners.iterator().next() : this.getObjectReference(Stereotype.class, uuid, "");
            }
            return stereotype;
        }
    }
}

