/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.ramc.core.model;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.emf.common.util.EList;
import org.modelio.gproject.plugin.CoreProject;
import org.modelio.gproject.ramc.core.model.IModelComponent;
import org.modelio.gproject.ramc.core.packaging.IModelComponentContributor;
import org.modelio.metamodel.mmextensions.infrastructure.ExtensionNotFoundException;
import org.modelio.metamodel.mmextensions.infrastructure.IInfrastructureModelFactory;
import org.modelio.metamodel.mmextensions.standard.factory.IStandardModelFactory;
import org.modelio.metamodel.uml.infrastructure.Dependency;
import org.modelio.metamodel.uml.infrastructure.Element;
import org.modelio.metamodel.uml.infrastructure.ModelElement;
import org.modelio.metamodel.uml.infrastructure.Note;
import org.modelio.metamodel.uml.infrastructure.NoteType;
import org.modelio.metamodel.uml.infrastructure.Stereotype;
import org.modelio.metamodel.uml.infrastructure.TagParameter;
import org.modelio.metamodel.uml.infrastructure.TagType;
import org.modelio.metamodel.uml.infrastructure.TaggedValue;
import org.modelio.metamodel.uml.infrastructure.UmlModelElement;
import org.modelio.metamodel.uml.statik.Artifact;
import org.modelio.metamodel.uml.statik.ElementImport;
import org.modelio.metamodel.uml.statik.Manifestation;
import org.modelio.metamodel.uml.statik.NameSpace;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.version.Version;
import org.modelio.vcore.model.api.MTools;
import org.modelio.vcore.session.impl.CoreSession;
import org.modelio.vcore.smkernel.mapi.MObject;

public class ModelComponent
implements Comparable<ModelComponent>,
IModelComponent {
    private static final String MODELER_MODULE = "ModelerModule";
    private final TreeMap<String, String> contributors;
    private String description;
    private String name;
    private String provider;
    private final Artifact artifact;
    private final Set<Element> exportedElements;
    private final Set<IModelComponentContributor.ExportedFileEntry> exportedFiles;
    private final Set<ModelComponent> requiredModelComponents;
    private Version version;

    public ModelComponent(Artifact ramc) {
        this.artifact = ramc;
        this.name = Loader.getName(ramc);
        this.version = Loader.getVersion(ramc);
        this.provider = Loader.getProvider(ramc);
        this.description = Loader.getDescription(ramc);
        this.exportedElements = Loader.getManifested(ramc);
        this.requiredModelComponents = Loader.getDependencies(ramc);
        this.exportedFiles = Loader.getExportedFiles(ramc);
        this.contributors = Loader.getContributors(ramc);
    }

    public void addExportedFile(IModelComponentContributor.ExportedFileEntry file) {
        this.exportedFiles.add(file);
    }

    @Override
    public int compareTo(ModelComponent model) {
        int result = this.name.compareTo(model.name);
        if (result == 0) {
            result = this.version.toString().compareTo(model.version.toString());
        }
        return result;
    }

    @Override
    public Artifact getArtifact() {
        return this.artifact;
    }

    @Override
    public Map<String, String> getContributingModules() {
        return this.contributors;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Set<Element> getExportedElements() {
        return this.exportedElements;
    }

    @Override
    public Set<IModelComponentContributor.ExportedFileEntry> getExportedFiles() {
        return this.exportedFiles;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<ModelComponent> getRequiredModelComponents() {
        return this.requiredModelComponents;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public void removeExportedFile(IModelComponentContributor.ExportedFileEntry file) {
        this.exportedFiles.remove(file);
    }

    public void setRamcDescription(String value) {
        this.description = value;
    }

    public void setRamcName(String name) {
        this.name = name;
    }

    public void setRamcVersion(Version value) {
        this.version = value;
    }

    public void updateArtifact() {
        Writer.setName(this.artifact, this.name);
        Writer.setDescription(this.artifact, this.description);
        Writer.setVersion(this.artifact, this.version);
        Writer.setProvider(this.artifact, this.provider);
        Writer.setDependencies(this.artifact, this.requiredModelComponents);
        Writer.setManifestedElements(this.artifact, this.exportedElements);
        Writer.setExportedFiles(this.artifact, this.exportedFiles);
        Writer.setContributors(this.artifact, this.contributors);
    }

    private static boolean isValidManifestedElement(Element me) {
        return me != null && me.getMClass().isCmsNode();
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider != null ? provider : "";
    }

    private static class Loader {
        private Loader() {
        }

        public static TreeMap<String, String> getContributors(Artifact ramc) {
            TreeMap<String, String> contributors = new TreeMap<String, String>();
            for (TaggedValue taggedvalue : ramc.getTag()) {
                TagType type = taggedvalue.getDefinition();
                if (type == null || !type.getName().equals("ModelComponentContributors")) continue;
                for (TagParameter parameter : taggedvalue.getActual()) {
                    String[] tokens = parameter.getValue().split("#");
                    if (tokens.length < 2) continue;
                    contributors.put(tokens[0], tokens[1]);
                }
            }
            return contributors;
        }

        public static TreeSet<ModelComponent> getDependencies(Artifact ramc) {
            TreeSet<ModelComponent> deps = new TreeSet<ModelComponent>();
            for (ElementImport elementImport : ramc.getOwnedImport()) {
                NameSpace importedNamespace = elementImport.getImportedElement();
                if (!(importedNamespace instanceof Artifact)) continue;
                Artifact ramcArtifact = (Artifact)importedNamespace;
                deps.add(new ModelComponent(ramcArtifact));
            }
            return deps;
        }

        public static String getDescription(Artifact ramc) {
            EList notes = ramc.getDescriptor();
            for (Note note : notes) {
                NoteType type = note.getModel();
                if (type == null || !type.getName().equals("description")) continue;
                return note.getContent();
            }
            return "";
        }

        public static TreeSet<IModelComponentContributor.ExportedFileEntry> getExportedFiles(Artifact ramc) {
            TreeSet<IModelComponentContributor.ExportedFileEntry> exportedFiles = new TreeSet<IModelComponentContributor.ExportedFileEntry>();
            for (TaggedValue taggedvalue : ramc.getTag()) {
                TagType type = taggedvalue.getDefinition();
                if (type == null || !type.getName().equals("ModelComponentFiles")) continue;
                int nParameters = taggedvalue.getActual().size();
                Object[] parameters = (TagParameter[])taggedvalue.getActual().toArray((Object[])new TagParameter[nParameters]);
                if (nParameters > 0 && (nParameters & 1) == 1) {
                    String message = CoreProject.I18N.getMessage("ModelComponent.BadModelComponentFiles", new Object[]{ramc.getName(), "ModelComponentFiles", Arrays.deepToString(parameters)});
                    Log.warning((String)message);
                    --nParameters;
                }
                int i = 0;
                while (i < nParameters) {
                    exportedFiles.add(new IModelComponentContributor.ExportedFileEntry(Paths.get(parameters[i].getValue().replace("\\", File.separator), new String[0]), parameters[i + 1].getValue().replace("\\", File.separator)));
                    i += 2;
                }
            }
            return exportedFiles;
        }

        public static TreeSet<Element> getManifested(Artifact ramc) {
            TreeSet<Element> elements = new TreeSet<Element>(new Comparator<Element>(){

                @Override
                public int compare(Element o1, Element o2) {
                    return o1.getUuid().compareTo(o2.getUuid());
                }
            });
            for (Manifestation manifestation : ramc.getUtilized()) {
                UmlModelElement me = manifestation.getUtilizedElement();
                if (!ModelComponent.isValidManifestedElement((Element)me)) continue;
                elements.add((Element)me);
            }
            CoreSession session = CoreSession.getSession((MObject)ramc);
            Stereotype manifStereotype = (Stereotype)session.getSmFactory().getObjectReference(session.getMetamodel().getMClass(Stereotype.class), "d5bccf8e-79b3-48df-8c79-09200aa52d19", "manifestation");
            for (Dependency dep : ramc.getDependsOnDependency()) {
                ModelElement me;
                if (!dep.getExtension().contains((Object)manifStereotype) || !ModelComponent.isValidManifestedElement((Element)(me = dep.getDependsOn()))) continue;
                elements.add((Element)me);
            }
            return elements;
        }

        public static String getName(Artifact ramc) {
            return ramc.getName();
        }

        public static Version getVersion(Artifact ramc) {
            EList taggedValues = ramc.getTag();
            for (TaggedValue taggedValue : taggedValues) {
                EList parameters;
                TagType type = taggedValue.getDefinition();
                if (type == null || !type.getName().equals("ModelComponentVersion") || (parameters = taggedValue.getActual()).size() != 1) continue;
                return new Version(((TagParameter)parameters.get(0)).getValue());
            }
            return new Version(0, 0, 0);
        }

        public static String getProvider(Artifact ramc) {
            EList taggedValues = ramc.getTag();
            for (TaggedValue taggedValue : taggedValues) {
                EList parameters;
                TagType type = taggedValue.getDefinition();
                if (type == null || !type.getName().equals("ModelComponentProvider") || (parameters = taggedValue.getActual()).size() != 1) continue;
                return ((TagParameter)parameters.get(0)).getValue();
            }
            return "";
        }
    }

    private static class Writer {
        private Writer() {
        }

        public static void setContributors(Artifact ramc, Map<String, String> contributors) {
            TaggedValue contributorsTag;
            for (TaggedValue tag : new ArrayList(ramc.getTag())) {
                if (!"ModelComponentContributors".equals(tag.getDefinition().getName())) continue;
                tag.delete();
            }
            IInfrastructureModelFactory modelFactory = Writer.getInfrastructureModelFactory(ramc);
            try {
                contributorsTag = modelFactory.createTaggedValue(ModelComponent.MODELER_MODULE, "ModelComponentArchive", "ModelComponentContributors", (ModelElement)ramc);
            }
            catch (ExtensionNotFoundException extensionNotFoundException) {
                return;
            }
            for (Map.Entry<String, String> entry : contributors.entrySet()) {
                modelFactory.createTagParameter(entry.getKey() + "#" + entry.getValue(), contributorsTag);
            }
        }

        public static void setDependencies(Artifact ramc, Set<ModelComponent> parentRamcs) {
            for (ElementImport ei : new ArrayList(ramc.getOwnedImport())) {
                if (!(ei.getImportedElement() instanceof Artifact) || !ei.getImportedElement().isStereotyped(ModelComponent.MODELER_MODULE, "ModelComponentArchive")) continue;
                ei.delete();
            }
            IStandardModelFactory standardFactory = Writer.getStandardModelFactory(ramc);
            for (ModelComponent m : parentRamcs) {
                if (!m.getArtifact().isStereotyped(ModelComponent.MODELER_MODULE, "ModelComponentArchive")) continue;
                standardFactory.createElementImport((NameSpace)ramc, (NameSpace)m.getArtifact());
            }
        }

        public static void setDescription(Artifact ramc, String description) {
            try {
                Note note = ramc.getNote(ModelComponent.MODELER_MODULE, "Infrastructure.ModelElement", "description");
                if (note == null) {
                    IInfrastructureModelFactory factory = Writer.getInfrastructureModelFactory(ramc);
                    note = factory.createNote(ModelComponent.MODELER_MODULE, "Infrastructure.ModelElement", "description", (ModelElement)ramc, "");
                }
                if (note != null) {
                    note.setContent(description);
                }
            }
            catch (ExtensionNotFoundException extensionNotFoundException) {}
        }

        public static void setExportedFiles(Artifact ramc, Set<IModelComponentContributor.ExportedFileEntry> exportedFiles) {
            TaggedValue filesTag;
            for (TaggedValue tag : new ArrayList(ramc.getTag())) {
                if (!"ModelComponentFiles".equals(tag.getDefinition().getName())) continue;
                tag.delete();
            }
            IInfrastructureModelFactory modelFactory = Writer.getInfrastructureModelFactory(ramc);
            try {
                filesTag = modelFactory.createTaggedValue(ModelComponent.MODELER_MODULE, "ModelComponentArchive", "ModelComponentFiles", (ModelElement)ramc);
            }
            catch (ExtensionNotFoundException extensionNotFoundException) {
                return;
            }
            for (IModelComponentContributor.ExportedFileEntry file : exportedFiles) {
                modelFactory.createTagParameter(file.getFileToExport().toString().replace(File.separator, "/"), filesTag);
                modelFactory.createTagParameter(file.getExportPath().replace(File.separator, "/"), filesTag);
            }
        }

        public static void setManifestedElements(Artifact ramc, Set<Element> manifestedElements) {
            HashSet<Element> toManifest = new HashSet<Element>(manifestedElements);
            for (Manifestation manifestation : new ArrayList(ramc.getUtilized())) {
                UmlModelElement me = manifestation.getUtilizedElement();
                if (toManifest.contains(me)) {
                    toManifest.remove(me);
                    continue;
                }
                manifestation.delete();
            }
            CoreSession session = CoreSession.getSession((MObject)ramc);
            Stereotype manifStereotype = (Stereotype)session.getSmFactory().getObjectReference(session.getMetamodel().getMClass(Stereotype.class), "d5bccf8e-79b3-48df-8c79-09200aa52d19", "manifestation");
            for (Dependency dep : new ArrayList(ramc.getDependsOnDependency())) {
                if (!dep.getExtension().contains((Object)manifStereotype)) continue;
                ModelElement me = dep.getDependsOn();
                if (toManifest.contains(me)) {
                    toManifest.remove(me);
                    continue;
                }
                dep.delete();
            }
            IStandardModelFactory standardFactory = Writer.getStandardModelFactory(ramc);
            IInfrastructureModelFactory modelFactory = Writer.getInfrastructureModelFactory(ramc);
            for (Element e : toManifest) {
                if (!ModelComponent.isValidManifestedElement(e)) continue;
                if (e instanceof UmlModelElement) {
                    Manifestation m = standardFactory.createManifestation();
                    m.setOwner(ramc);
                    m.setUtilizedElement((UmlModelElement)e);
                    continue;
                }
                if (!(e instanceof ModelElement)) continue;
                modelFactory.createDependency((ModelElement)ramc, (ModelElement)e, manifStereotype);
            }
        }

        public static void setName(Artifact ramc, String name) {
            ramc.setName(name);
        }

        public static void setVersion(Artifact ramc, Version version) {
            String v = String.format("%d.%d.%02d", version.getMajorVersion(), version.getMinorVersion(), version.getBuildVersion());
            try {
                EList parameters;
                TaggedValue taggedValue = ramc.getTag(ModelComponent.MODELER_MODULE, "ModelComponentArchive", "ModelComponentVersion");
                if (taggedValue == null) {
                    IInfrastructureModelFactory factory = Writer.getInfrastructureModelFactory(ramc);
                    taggedValue = factory.createTaggedValue(ModelComponent.MODELER_MODULE, "ModelComponentArchive", "ModelComponentVersion", (ModelElement)ramc);
                    factory.createTagParameter("", taggedValue);
                }
                if ((parameters = taggedValue.getActual()).size() > 0) {
                    ((TagParameter)parameters.get(0)).setValue(v);
                }
            }
            catch (ExtensionNotFoundException extensionNotFoundException) {}
        }

        private static IInfrastructureModelFactory getInfrastructureModelFactory(Artifact ramc) {
            return (IInfrastructureModelFactory)MTools.get((MObject)ramc).getModelFactory(IInfrastructureModelFactory.class);
        }

        private static IStandardModelFactory getStandardModelFactory(Artifact ramc) {
            return (IStandardModelFactory)MTools.get((MObject)ramc).getModelFactory(IStandardModelFactory.class);
        }

        public static void setProvider(Artifact ramc, String provider) {
            try {
                EList parameters;
                TaggedValue taggedValue = ramc.getTag(ModelComponent.MODELER_MODULE, "ModelComponentArchive", "ModelComponentProvider");
                if (taggedValue == null) {
                    IInfrastructureModelFactory factory = Writer.getInfrastructureModelFactory(ramc);
                    taggedValue = factory.createTaggedValue(ModelComponent.MODELER_MODULE, "ModelComponentArchive", "ModelComponentProvider", (ModelElement)ramc);
                    factory.createTagParameter("", taggedValue);
                }
                if ((parameters = taggedValue.getActual()).size() > 0) {
                    ((TagParameter)parameters.get(0)).setValue(provider);
                }
            }
            catch (ExtensionNotFoundException extensionNotFoundException) {}
        }
    }
}

