/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.ramc.core.packaging;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.List;
import org.modelio.gproject.plugin.CoreProject;
import org.modelio.gproject.ramc.core.packaging.IModelComponentContributor;
import org.modelio.gproject.ramc.core.packaging.Metadatas;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.progress.SubProgress;

class FilesExporter {
    private final Path exportPath;
    private final Path projectPath;

    public FilesExporter(Path exportPath, Path projectPath) {
        this.exportPath = exportPath;
        this.projectPath = projectPath;
    }

    public void run(List<IModelComponentContributor.ExportedFileEntry> filesToExport, Metadatas metadatas, SubProgress subMonitor) throws IOException {
        subMonitor.subTask(CoreProject.I18N.getString("RamcPackager.ExportFiles"));
        int idx = 0;
        for (IModelComponentContributor.ExportedFileEntry fileEntry : filesToExport) {
            String metaName;
            if (!this.copyFile(metadatas, fileEntry, metaName = "File" + idx)) continue;
            ++idx;
        }
    }

    private boolean copyFile(Metadatas metadatas, IModelComponentContributor.ExportedFileEntry fileEntry, String metaName) throws IOException {
        Path file = this.projectPath.resolve(fileEntry.getFileToExport());
        if (Files.isRegularFile(file, new LinkOption[0])) {
            FileTime date = Files.getLastModifiedTime(file, new LinkOption[0]);
            Files.copy(file, this.exportPath.resolve(metaName), new CopyOption[0]);
            metadatas.addExportedFileDef(metaName, fileEntry.getExportPath(), date);
            return true;
        }
        Log.warning((String)"%s - Invalid file path: %s", (Object[])new Object[]{this.getClass().getSimpleName(), file.normalize()});
        return false;
    }
}

