/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.ramc.core.packaging;

import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;
import org.modelio.metamodel.uml.infrastructure.NoteType;
import org.modelio.metamodel.uml.infrastructure.Stereotype;
import org.modelio.metamodel.uml.infrastructure.TagType;
import org.modelio.vcore.smkernel.mapi.MObject;

public interface IModelComponentContributor {
    public Set<MObject> getElements();

    public Set<NoteType> getNoteTypes();

    public Set<TagType> getTagTypes();

    public Set<Stereotype> getDependencyStereotypes();

    public Set<ExportedFileEntry> getFiles();

    public static class ExportedFileEntry
    implements Comparable<ExportedFileEntry> {
        private String exportPath;
        private Path fileToExport;

        public String getExportPath() {
            return this.exportPath;
        }

        @Override
        public int compareTo(ExportedFileEntry e) {
            int ret = this.fileToExport.compareTo(e.fileToExport);
            return ret != 0 ? ret : this.exportPath.compareTo(e.exportPath);
        }

        public void setExportPath(String exportPath) {
            this.exportPath = exportPath;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.exportPath == null ? 0 : this.exportPath.hashCode());
            result = 31 * result + (this.fileToExport == null ? 0 : this.fileToExport.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExportedFileEntry other = (ExportedFileEntry)obj;
            if (this.exportPath == null ? other.exportPath != null : !this.exportPath.equals(other.exportPath)) {
                return false;
            }
            return !(this.fileToExport == null ? other.fileToExport != null : !this.fileToExport.equals(other.fileToExport));
        }

        public ExportedFileEntry(Path fileToExport, String exportPath) {
            this.fileToExport = Objects.requireNonNull(fileToExport);
            this.exportPath = exportPath != null ? exportPath : "";
        }

        public Path getFileToExport() {
            return this.fileToExport;
        }

        public void setFileToExport(Path fileToExport) {
            this.fileToExport = fileToExport;
        }
    }
}

