/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.ramc.core.packaging;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.modelio.gproject.data.ramc.IModelComponentInfos;
import org.modelio.gproject.data.ramc.ManifestWriter;
import org.modelio.gproject.data.ramc.ModelRef;
import org.modelio.gproject.ramc.core.model.IModelComponent;
import org.modelio.vbasic.version.Version;
import org.modelio.vbasic.version.VersionedItem;
import org.modelio.vcore.smkernel.mapi.MMetamodelFragment;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.version.ModelioVersion;

class Metadatas {
    private final List<IModelComponentInfos.ExportedFile> files = new ArrayList<IModelComponentInfos.ExportedFile>();
    private Collection<MMetamodelFragment> mmFragments;
    private final IModelComponent ramc;
    private final List<MRef> roots = new ArrayList<MRef>();

    public Metadatas(IModelComponent ramc) {
        this.ramc = ramc;
    }

    public void addExportedFileDef(String archiveFileName, String deploymentPath, FileTime fileDate) {
        this.files.add(new IModelComponentInfos.ExportedFile(archiveFileName, Paths.get(deploymentPath, new String[0]), fileDate));
    }

    public void addRoot(MRef root) {
        this.roots.add(root);
    }

    public void setUsedMetamodelFragments(Collection<MMetamodelFragment> fragments) {
        this.mmFragments = fragments;
    }

    public void write(Path exportPath) throws IOException {
        Path metadataFile = exportPath.resolve("metadatas.xml");
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream metadataWriter = Files.newOutputStream(metadataFile, new OpenOption[0]);){
            ManifestWriter w = new ManifestWriter();
            IModelComponentInfos manifest = this.asModelComponentInfos();
            w.write(manifest, metadataWriter);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    List<MRef> getRoots() {
        return this.roots;
    }

    private IModelComponentInfos asModelComponentInfos() {
        final ArrayList<IModelComponentInfos.ExportedFile> exportedFiles = new ArrayList<IModelComponentInfos.ExportedFile>(this.files);
        exportedFiles.sort(Comparator.comparing(t -> t.getNameInArchive()));
        IModelComponentInfos manifest = new IModelComponentInfos(){

            public String getProvider() {
                return Metadatas.this.ramc.getProvider();
            }

            public Version getVersion() {
                return Metadatas.this.ramc.getVersion();
            }

            public Version getModelioVersion() {
                return ModelioVersion.VERSION;
            }

            public List<ModelRef> getRoots() {
                return Metadatas.this.roots.stream().map(ref -> new ModelRef(ref.mc, ref.uuid, ref.name)).collect(Collectors.toList());
            }

            public List<VersionedItem<?>> getRequiredModelComponents() {
                return Metadatas.this.ramc.getRequiredModelComponents().stream().map(mc -> new VersionedItem(mc.getName(), mc.getVersion())).collect(Collectors.toList());
            }

            public List<VersionedItem<?>> getRequiredMetamodelFragments() {
                return Metadatas.this.mmFragments.stream().map(mc -> new VersionedItem(mc.getName(), mc.getVersion())).collect(Collectors.toList());
            }

            public String getName() {
                return Metadatas.this.ramc.getName();
            }

            public List<IModelComponentInfos.ExportedFile> getExportedFiles() {
                return exportedFiles;
            }

            public String getDescription() {
                return Metadatas.this.ramc.getDescription();
            }

            public List<VersionedItem<?>> getContributingModules() {
                return Metadatas.this.ramc.getContributingModules().entrySet().stream().map(mc -> new VersionedItem((String)mc.getKey(), new Version((String)mc.getValue()))).collect(Collectors.toList());
            }
        };
        return manifest;
    }
}

