/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.ramc.core.packaging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.modelio.gproject.ramc.core.model.ModelComponent;
import org.modelio.gproject.ramc.core.packaging.IModelComponentContributor;
import org.modelio.gproject.ramc.core.packaging.Metadatas;
import org.modelio.gproject.ramc.core.packaging.filters.ConfigurableModelFilter;
import org.modelio.gproject.ramc.core.packaging.filters.RamcFilterBuilder;
import org.modelio.metamodel.mmextensions.infrastructure.IInfrastructureModelFactory;
import org.modelio.metamodel.mmextensions.standard.services.MModelServices;
import org.modelio.metamodel.uml.infrastructure.Element;
import org.modelio.metamodel.uml.infrastructure.ModelElement;
import org.modelio.metamodel.uml.infrastructure.NoteType;
import org.modelio.metamodel.uml.infrastructure.Stereotype;
import org.modelio.metamodel.uml.infrastructure.TagType;
import org.modelio.metamodel.uml.infrastructure.TaggedValue;
import org.modelio.vcore.model.CompositionGetter;
import org.modelio.vcore.model.api.MTools;
import org.modelio.vcore.model.filter.IObjectFilter;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.session.api.model.IModel;
import org.modelio.vcore.session.api.repository.IRepository;
import org.modelio.vcore.session.impl.CoreSession;
import org.modelio.vcore.session.impl.SmFactory;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.mapi.MAttribute;
import org.modelio.vcore.smkernel.mapi.MClass;
import org.modelio.vcore.smkernel.mapi.MDependency;
import org.modelio.vcore.smkernel.mapi.MMetamodelFragment;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vcore.smkernel.meta.SmAttribute;
import org.modelio.vcore.smkernel.meta.SmClass;
import org.modelio.vcore.smkernel.meta.SmDependency;

class ModelExporter {
    private final CoreSession targetSession;
    private final Map<String, MObject> aliases = new HashMap<String, MObject>();
    private final DepWalker depWalker = new DepWalker();
    private final Set<MObject> done = new HashSet<MObject>();
    private IObjectFilter modelFilter;
    private final Set<MObject> objectsToExternalize = new HashSet<MObject>();
    private final IRepository targetRepository;
    private final Set<MMetamodelFragment> mmFragments = new HashSet<MMetamodelFragment>();
    private final CoreSession srcSession;
    private final MClass MODELELEMENT_MCLASS;

    public ModelExporter(ICoreSession srcSession, ICoreSession targetSession, IRepository targetRepository) {
        assert (srcSession != null);
        assert (targetSession != null);
        assert (targetRepository != null);
        this.srcSession = (CoreSession)srcSession;
        this.targetSession = (CoreSession)targetSession;
        this.targetRepository = targetRepository;
        this.MODELELEMENT_MCLASS = this.srcSession.getMetamodel().getMClass(ModelElement.class);
    }

    public void addObject(MObject o) {
        this.objectsToExternalize.add(o);
    }

    public void configureModelExporter(ModelComponent ramc, boolean exportArtifact, List<IModelComponentContributor> contributors) {
        if (exportArtifact) {
            this.addObject((MObject)ramc.getArtifact());
        }
        for (Element e : ramc.getExportedElements()) {
            this.addObject((MObject)e);
        }
        RamcFilterBuilder builder = new RamcFilterBuilder(this.srcSession.getMetamodel(), ramc.getArtifact());
        for (IModelComponentContributor contributor : contributors) {
            for (MObject mObject : contributor.getElements()) {
                if (mObject == null) continue;
                this.addObject(mObject);
            }
            for (NoteType noteType : contributor.getNoteTypes()) {
                if (noteType == null) continue;
                builder.addNoteType(noteType);
            }
            for (TagType tagType : contributor.getTagTypes()) {
                if (tagType == null) continue;
                builder.addTagType(tagType);
            }
            for (Stereotype stereotype : contributor.getDependencyStereotypes()) {
                if (stereotype == null) continue;
                builder.addDependencyStereotype(stereotype);
            }
        }
        this.setModelFilter(builder.getModelFilter());
    }

    public void run(Metadatas metadatas) {
        assert (this.modelFilter != null);
        this.createEmptyObjects();
        for (MObject anObject : this.objectsToExternalize) {
            this.externalizeObject(anObject);
        }
        Set<MObject> stubs = this.computeStubObjectsToExport(metadatas);
        this.externalizeStubObject(stubs);
        ListIterator<MRef> it = metadatas.getRoots().listIterator();
        while (it.hasNext()) {
            MRef root = it.next();
            MObject alias = this.aliases.get(root.uuid);
            if (alias == null) continue;
            it.set(new MRef(alias));
        }
        this.done.clear();
        metadatas.setUsedMetamodelFragments(this.mmFragments);
    }

    public void setModelFilter(ConfigurableModelFilter modelFilter) {
        this.modelFilter = modelFilter;
    }

    private Set<MObject> computeStubObjectsToExport(Metadatas metadatas) {
        HashSet<MObject> stubObjectsToExport = new HashSet<MObject>();
        for (MObject obj : this.objectsToExternalize) {
            MObject composed = obj.getCompositionOwner();
            boolean more = true;
            MObject current = obj;
            do {
                if (composed == null) {
                    metadatas.addRoot(new MRef(current));
                    more = false;
                    continue;
                }
                if (stubObjectsToExport.contains(composed)) {
                    more = false;
                    continue;
                }
                if (!this.done.contains(composed)) {
                    stubObjectsToExport.add(composed);
                    current = composed;
                    composed = composed.getCompositionOwner();
                    continue;
                }
                more = false;
            } while (more);
        }
        return stubObjectsToExport;
    }

    private void createEmptyObjects() {
        SmFactory smFactory = this.getSmFactory();
        IModel modelService = this.targetSession.getModel();
        for (MObject obj : this.objectsToExternalize) {
            SmClass mClass = (SmClass)obj.getMClass();
            this.mmFragments.add((MMetamodelFragment)mClass.getOrigin());
            smFactory.createObject(mClass, this.targetRepository, obj.getUuid());
        }
        ArrayList<MObject> roots = new ArrayList<MObject>();
        for (MObject o : this.objectsToExternalize) {
            roots.add(o);
        }
        final IObjectFilter theModelfilter = this.modelFilter;
        CompositionGetter.IStopFilter filter = new CompositionGetter.IStopFilter(){

            public boolean accept(MObject val) {
                return theModelfilter.accept(val);
            }
        };
        for (MObject obj : CompositionGetter.getAllChildren(roots, (CompositionGetter.IStopFilter)filter)) {
            String uuid;
            SmClass metaclass = (SmClass)obj.getMClass();
            SmObjectImpl ret = (SmObjectImpl)modelService.findById((MClass)metaclass, uuid = obj.getUuid());
            if (ret != null && !ret.hasStatus(256L)) continue;
            this.mmFragments.add((MMetamodelFragment)metaclass.getOrigin());
            smFactory.createObject(metaclass, this.targetRepository, uuid);
        }
    }

    private MObject externalizeObject(MObject obj) {
        MObject targetObj = this.targetSession.getModel().findById(obj.getMClass(), obj.getUuid());
        if (this.done.contains(obj)) {
            return targetObj;
        }
        this.done.add(obj);
        if (targetObj == null || targetObj.isShell()) {
            throw new IllegalStateException(String.valueOf(obj) + " not found or shell in the target session.");
        }
        for (SmAttribute att : ((SmClass)obj.getMClass()).getAllAttDef()) {
            targetObj.mSet((MAttribute)att, obj.mGet((MAttribute)att));
        }
        for (MDependency desc : this.depWalker.getCompositionDeps(obj)) {
            SmDependency smDep = (SmDependency)desc;
            for (MObject val : obj.mGet((MDependency)smDep)) {
                if (!this.objectsToExternalize.contains(val) && !this.modelFilter.accept(val)) continue;
                MObject targetVal = this.externalizeObject(val);
                targetObj.mGet((MDependency)smDep).add(targetVal);
            }
        }
        for (MDependency desc : this.depWalker.getReferenceDeps(obj)) {
            byte objRepoId = ((SmObjectImpl)obj).getRepositoryObject().getRepositoryId();
            SmDependency smDep = (SmDependency)desc;
            for (MObject val : obj.mGet((MDependency)smDep)) {
                byte valRepoId = ((SmObjectImpl)val).getRepositoryObject().getRepositoryId();
                if (valRepoId == objRepoId && !this.objectsToExternalize.contains(val) && !this.modelFilter.accept(val)) continue;
                MObject targetVal = this.getTargetObject(val);
                if (smDep.isCompositionOpposite() && !targetVal.isValid()) continue;
                targetObj.mGet((MDependency)smDep).add(targetVal);
            }
        }
        return targetObj;
    }

    private void externalizeStubObject(Set<MObject> stubObjects) {
        MObject alias;
        if (stubObjects.isEmpty()) {
            return;
        }
        MModelServices modelServices = new MModelServices((ICoreSession)this.srcSession);
        Stereotype aliasStereotype = null;
        List stereotypes = modelServices.findStereotypes("ModelerModule", "ModelComponentElementAlias", this.MODELELEMENT_MCLASS);
        if (!stereotypes.isEmpty()) {
            aliasStereotype = (Stereotype)this.getTargetObject((MObject)stereotypes.get(0));
            this.mmFragments.add(((Stereotype)stereotypes.get(0)).getMClass().getOrigin());
        }
        TagType uuidTagType = null;
        List tagTypes = modelServices.findTagTypes("ModelerModule", "ModelComponentElementAlias", "uuid", this.MODELELEMENT_MCLASS);
        if (!tagTypes.isEmpty()) {
            uuidTagType = (TagType)this.getTargetObject((MObject)tagTypes.get(0));
            this.mmFragments.add(((TagType)tagTypes.get(0)).getMClass().getOrigin());
        }
        for (MObject o : stubObjects) {
            this.mmFragments.add(o.getMClass().getOrigin());
            alias = this.targetSession.getModel().findById(o.getMClass(), o.getUuid());
            if (this.aliases.containsKey(o.getUuid()) || alias != null) continue;
            alias = this.getSmFactory().createObject((SmClass)o.getMClass(), this.targetRepository);
            if (aliasStereotype != null) {
                IInfrastructureModelFactory targetFactory = (IInfrastructureModelFactory)MTools.get((MObject)alias).getModelFactory(IInfrastructureModelFactory.class);
                if (alias instanceof ModelElement) {
                    ((ModelElement)alias).getExtension().add((Object)aliasStereotype);
                    TaggedValue tag = targetFactory.createTaggedValue(uuidTagType, (ModelElement)alias);
                    targetFactory.createTagParameter(o.getUuid().toString(), tag);
                }
            }
            this.aliases.put(o.getUuid(), alias);
        }
        for (MObject o : stubObjects) {
            alias = this.aliases.get(o.getUuid());
            for (SmAttribute att : ((SmClass)o.getMClass()).getAllAttDef()) {
                alias.mSet((MAttribute)att, o.mGet((MAttribute)att));
            }
            for (MDependency desc : this.depWalker.getCompositionDeps(o)) {
                SmDependency smDep = (SmDependency)desc;
                for (MObject val : o.mGet((MDependency)smDep)) {
                    if (!this.modelFilter.accept(val)) continue;
                    if (this.done.contains(val)) {
                        MObject target = this.targetSession.getModel().findById(val.getMClass(), val.getUuid());
                        alias.mGet((MDependency)smDep).add(target);
                        continue;
                    }
                    if (!this.aliases.containsKey(val.getUuid())) continue;
                    alias.mGet((MDependency)smDep).add(this.aliases.get(val.getUuid()));
                }
            }
        }
    }

    private MObject getTargetObject(MObject anObject) {
        return this.getSmFactory().getObjectReference((SmClass)anObject.getMClass(), anObject.getUuid(), anObject.getName());
    }

    private SmFactory getSmFactory() {
        return this.targetSession.getSmFactory();
    }

    private static class DepWalker {
        private Map<MClass, Collection<MDependency>> compositionDeps = new HashMap<MClass, Collection<MDependency>>();
        private Map<MClass, Collection<MDependency>> referenceDeps = new HashMap<MClass, Collection<MDependency>>();

        public Collection<MDependency> getCompositionDeps(MObject srcObject) {
            Collection<MDependency> ret = this.compositionDeps.get(srcObject.getMClass());
            if (ret != null) {
                return ret;
            }
            ret = new ArrayList<MDependency>();
            for (MDependency dep : srcObject.getMClass().getDependencies(true)) {
                if (!dep.isComposition() && !((SmDependency)dep).isSharedComposition()) continue;
                ret.add(dep);
            }
            this.compositionDeps.put(srcObject.getMClass(), ret);
            return ret;
        }

        public Collection<MDependency> getReferenceDeps(MObject srcObject) {
            Collection<MDependency> ret = this.referenceDeps.get(srcObject.getMClass());
            if (ret != null) {
                return ret;
            }
            ret = new ArrayList<MDependency>();
            for (MDependency dep : srcObject.getMClass().getDependencies(true)) {
                if (dep.isComposition() || dep.isSharedComposition() || !((SmDependency)dep).isPartOf()) continue;
                ret.add(dep);
            }
            this.referenceDeps.put(srcObject.getMClass(), ret);
            return ret;
        }
    }
}

