/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.ramc.core.packaging;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipException;
import org.modelio.gproject.core.IGProject;
import org.modelio.gproject.plugin.CoreProject;
import org.modelio.gproject.project.AbstractGProject;
import org.modelio.gproject.ramc.core.model.ModelComponent;
import org.modelio.gproject.ramc.core.packaging.FilesExporter;
import org.modelio.gproject.ramc.core.packaging.IModelComponentContributor;
import org.modelio.gproject.ramc.core.packaging.Metadatas;
import org.modelio.gproject.ramc.core.packaging.ModelExporter;
import org.modelio.metamodel.uml.statik.Artifact;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.files.Zipper;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vbasic.version.Version;
import org.modelio.vcore.model.spi.IGMetamodelExtension;
import org.modelio.vcore.session.api.IAccessManager;
import org.modelio.vcore.session.api.ICoreSession;
import org.modelio.vcore.session.api.repository.IRepository;
import org.modelio.vcore.session.api.transactions.ITransaction;
import org.modelio.vcore.session.impl.CoreSession;
import org.modelio.vcore.session.impl.CoreSessionBuilder;
import org.modelio.vcore.session.impl.permission.BasicAccessManager;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vstore.exml.local.ExmlBase;

public class RamcPackager {
    private boolean includeArtifact;
    private IGProject gproject;
    private ModelComponent ramc;
    private List<IModelComponentContributor> contributors;
    private Path archivePath;
    private Path workPath;

    public RamcPackager(IGProject gproject, Artifact artifact, Path archivePath) {
        this(gproject, artifact, archivePath, new ArrayList<IModelComponentContributor>());
    }

    public RamcPackager(IGProject gproject, Artifact artifact, Path archivePath, List<IModelComponentContributor> contributors) {
        this.archivePath = archivePath;
        this.ramc = new ModelComponent(artifact);
        this.gproject = gproject;
        this.contributors = contributors;
        this.includeArtifact = true;
        Version v = this.ramc.getVersion();
        v = new Version(v.getMajorVersion(), v.getMinorVersion(), v.getBuildVersion());
        this.ramc.setRamcVersion(v);
    }

    public void run(IModelioProgress monitor) throws IOException {
        SubProgress subMonitor = SubProgress.convert((IModelioProgress)monitor, (int)40);
        this.workPath = Files.createTempDirectory("ramc-export", new FileAttribute[0]);
        Path modelPath = this.workPath.resolve("model");
        Files.createDirectories(modelPath, new FileAttribute[0]);
        Metadatas metadatas = new Metadatas(this.ramc);
        this.exportModel(modelPath, metadatas, subMonitor.newChild(10));
        this.exportFiles(this.workPath, metadatas, subMonitor.newChild(10));
        metadatas.write(this.workPath);
        RamcPackager.createCompressedArchive(this.workPath, this.archivePath, (IModelioProgress)subMonitor.newChild(10));
        FileUtils.delete((Path)this.workPath);
    }

    private void exportModel(Path modelPath, Metadatas metadatas, SubProgress monitor) throws IOException {
        SubProgress subMonitor = SubProgress.convert((IModelioProgress)monitor, (int)60);
        subMonitor.subTask(CoreProject.I18N.getString("RamcPackager.ExportModel"));
        ICoreSession srcSession = this.gproject.getSession();
        CoreSession targetSession = new CoreSessionBuilder().withMetamodel(srcSession.getMetamodel()).build();
        IGProject project = AbstractGProject.getProject(srcSession);
        for (IGMetamodelExtension mmExt : project.getProjectEnvironment().getDefaultMetamodelExtensions()) {
            mmExt.register((ICoreSession)targetSession);
        }
        try {
            ExmlBase targetRepository = new ExmlBase(modelPath, this.ramc.getName());
            targetRepository.create((MMetamodel)targetSession.getMetamodel());
            targetSession.getRepositorySupport().connectRepository((IRepository)targetRepository, (IAccessManager)new BasicAccessManager(), (IModelioProgress)subMonitor.newChild(10));
            ModelExporter exporter = new ModelExporter(srcSession, (ICoreSession)targetSession, (IRepository)targetRepository);
            exporter.configureModelExporter(this.ramc, this.includeArtifact, this.contributors);
            subMonitor.worked(10);
            Throwable throwable = null;
            Object var11_12 = null;
            try (ITransaction t = targetSession.getTransactionSupport().createTransaction("Export model to RAMC archive");){
                exporter.run(metadatas);
                subMonitor.worked(10);
                t.commit();
                subMonitor.worked(10);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            targetSession.save((IModelioProgress)subMonitor.newChild(10));
            targetRepository.getMaintenance().compressIndexes((IModelioProgress)subMonitor.newChild(10));
        }
        finally {
            targetSession.close();
        }
    }

    private void exportFiles(Path exportPath, Metadatas metadatas, SubProgress subMonitor) throws IOException {
        subMonitor.subTask(CoreProject.I18N.getString("RamcPackager.ExportFiles"));
        FilesExporter exporter = new FilesExporter(exportPath, this.gproject.getPfs().getProjectPath());
        exporter.run(this.getFilesToExport(), metadatas, subMonitor);
    }

    private static void createCompressedArchive(Path dataPath, Path archive, IModelioProgress subMonitor) throws IOException, ZipException {
        subMonitor.subTask(MessageFormat.format(CoreProject.I18N.getString("RamcPackager.ArchiveModelComponent"), archive.toString()));
        Zipper zip = new Zipper(archive);
        zip.compressContent(dataPath, subMonitor, null);
    }

    private List<IModelComponentContributor.ExportedFileEntry> getFilesToExport() {
        ArrayList<IModelComponentContributor.ExportedFileEntry> exportedFiles = new ArrayList<IModelComponentContributor.ExportedFileEntry>();
        for (IModelComponentContributor.ExportedFileEntry file : this.ramc.getExportedFiles()) {
            exportedFiles.add(file);
        }
        for (IModelComponentContributor contributor : this.contributors) {
            for (IModelComponentContributor.ExportedFileEntry file : contributor.getFiles()) {
                exportedFiles.add(file);
            }
        }
        return exportedFiles;
    }

    public void setIncludeArtifact(boolean onOff) {
        this.includeArtifact = onOff;
    }
}

