/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.ramc.core.packaging.filters;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.modelio.gproject.ramc.core.packaging.filters.IModelFilterConfigurer;
import org.modelio.vcore.model.filter.IObjectFilter;
import org.modelio.vcore.smkernel.mapi.MClass;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.meta.SmClass;
import org.modelio.vcore.smkernel.meta.SmMetamodel;

public class ConfigurableModelFilter
implements IModelFilterConfigurer,
IObjectFilter {
    private Map<MClass, IObjectFilter> classDescriptors;
    private SmMetamodel metamodel;

    public ConfigurableModelFilter(SmMetamodel metamodel) {
        List allMetaclasses = metamodel.getRegisteredMClasses();
        this.metamodel = metamodel;
        this.classDescriptors = new HashMap<MClass, IObjectFilter>(allMetaclasses.size());
    }

    public boolean accept(MObject obj) {
        IObjectFilter filter = this.classDescriptors.get(obj.getMClass());
        if (filter == null) {
            return true;
        }
        return filter.accept(obj);
    }

    @Override
    public void setFilter(Class<? extends MObject> mmClass, IObjectFilter objectFilter) {
        SmClass cls = this.metamodel.getMClass(mmClass);
        this.classDescriptors.put((MClass)cls, objectFilter);
        for (SmClass c : cls.getAllSubClasses()) {
            this.classDescriptors.put((MClass)c, objectFilter);
        }
    }
}

