/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.ramc.core.packaging.filters;

import org.modelio.gproject.ramc.core.packaging.filters.AssociationEndFilter;
import org.modelio.gproject.ramc.core.packaging.filters.ConfigurableModelFilter;
import org.modelio.gproject.ramc.core.packaging.filters.DependencyFilter;
import org.modelio.gproject.ramc.core.packaging.filters.FeatureFilter;
import org.modelio.gproject.ramc.core.packaging.filters.IgnoreFilter;
import org.modelio.gproject.ramc.core.packaging.filters.LinkTargetFilter;
import org.modelio.gproject.ramc.core.packaging.filters.NameSpaceFilter;
import org.modelio.gproject.ramc.core.packaging.filters.NaryAssociationEndFilter;
import org.modelio.gproject.ramc.core.packaging.filters.NaryLinkEndFilter;
import org.modelio.gproject.ramc.core.packaging.filters.NoteFilter;
import org.modelio.gproject.ramc.core.packaging.filters.TaggedValueFilter;
import org.modelio.metamodel.diagrams.AbstractDiagram;
import org.modelio.metamodel.uml.infrastructure.AbstractResource;
import org.modelio.metamodel.uml.infrastructure.Dependency;
import org.modelio.metamodel.uml.infrastructure.Element;
import org.modelio.metamodel.uml.infrastructure.Note;
import org.modelio.metamodel.uml.infrastructure.NoteType;
import org.modelio.metamodel.uml.infrastructure.Stereotype;
import org.modelio.metamodel.uml.infrastructure.TagType;
import org.modelio.metamodel.uml.infrastructure.TaggedValue;
import org.modelio.metamodel.uml.infrastructure.matrix.MatrixDefinition;
import org.modelio.metamodel.uml.statik.Artifact;
import org.modelio.metamodel.uml.statik.AssociationEnd;
import org.modelio.metamodel.uml.statik.Attribute;
import org.modelio.metamodel.uml.statik.NameSpace;
import org.modelio.metamodel.uml.statik.NaryAssociationEnd;
import org.modelio.metamodel.uml.statik.NaryLinkEnd;
import org.modelio.metamodel.uml.statik.Operation;
import org.modelio.vcore.smkernel.mapi.MClass;
import org.modelio.vcore.smkernel.mapi.MExpert;
import org.modelio.vcore.smkernel.meta.SmClass;
import org.modelio.vcore.smkernel.meta.SmMetamodel;

public class RamcFilterBuilder {
    private final DependencyFilter dependencyFilter;
    private final NoteFilter noteFilter;
    private final TaggedValueFilter tagFilter;
    private SmMetamodel smMetamodel;

    public RamcFilterBuilder(SmMetamodel smMetamodel, Artifact artifact) {
        this.smMetamodel = smMetamodel;
        this.dependencyFilter = new DependencyFilter(null, this.smMetamodel.getMExpert());
        this.noteFilter = new NoteFilter(artifact);
        this.tagFilter = new TaggedValueFilter(artifact);
    }

    public void addDependencyStereotype(Stereotype type) {
        this.dependencyFilter.addStereotype(type);
    }

    public void addNoteType(NoteType type) {
        this.noteFilter.addNoteType(type);
    }

    public void addTagType(TagType type) {
        this.tagFilter.addTagType(type);
    }

    public ConfigurableModelFilter getModelFilter() {
        ConfigurableModelFilter modelFilter = new ConfigurableModelFilter(this.smMetamodel);
        this.dependencyFilter.setTargetFilter(modelFilter);
        MExpert expert = this.smMetamodel.getMExpert();
        LinkTargetFilter linkFilter = new LinkTargetFilter(expert, modelFilter);
        for (MClass metaclass : this.smMetamodel.getMClass(Element.class).getSub(true)) {
            if (!expert.isLink(metaclass)) continue;
            if (metaclass.getName().equals(Dependency.class.getSimpleName())) {
                modelFilter.setFilter(Dependency.class, this.dependencyFilter);
                continue;
            }
            if (metaclass.getName().equals(AssociationEnd.class.getSimpleName())) {
                modelFilter.setFilter(AssociationEnd.class, new AssociationEndFilter(modelFilter, expert));
                continue;
            }
            modelFilter.setFilter(((SmClass)metaclass).getJavaInterface(), linkFilter);
        }
        modelFilter.setFilter(TaggedValue.class, this.tagFilter);
        modelFilter.setFilter(Note.class, this.noteFilter);
        modelFilter.setFilter(NameSpace.class, new NameSpaceFilter());
        modelFilter.setFilter(NaryAssociationEnd.class, new NaryAssociationEndFilter(modelFilter, expert));
        modelFilter.setFilter(NaryLinkEnd.class, new NaryLinkEndFilter(modelFilter, expert));
        FeatureFilter featureFilter = new FeatureFilter();
        modelFilter.setFilter(Attribute.class, featureFilter);
        modelFilter.setFilter(Operation.class, featureFilter);
        IgnoreFilter ignoreFilter = new IgnoreFilter();
        modelFilter.setFilter(AbstractDiagram.class, ignoreFilter);
        modelFilter.setFilter(MatrixDefinition.class, ignoreFilter);
        modelFilter.setFilter(AbstractResource.class, ignoreFilter);
        return modelFilter;
    }
}

