/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.rtcache;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.stream.Stream;
import org.modelio.gproject.catalog.FileModuleStore;
import org.modelio.gproject.catalog.FileModuleStoreHandle;
import org.modelio.gproject.module.IModuleHandle;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vcore.model.spi.IGMetamodelExtension;

class FileModuleAdditionStore
extends FileModuleStore {
    private static final int CACHE_VERSION = 1;

    public FileModuleAdditionStore(Collection<IGMetamodelExtension> metamodelFragments, Path cachePath) {
        super(metamodelFragments, cachePath);
    }

    @Override
    protected Path computeModuleCachePath(String moduleName, String moduleVersion) {
        Path baseModuleCachePath = this.storePath.resolve(moduleName + "_" + moduleVersion);
        long index = this.computeModuleCachePathIndex(baseModuleCachePath);
        return baseModuleCachePath.resolve(Long.toString(index));
    }

    @Override
    protected Path computeNewModuleStorePath(IModuleHandle moduleHandle) {
        Path baseModuleCachePath = this.storePath.resolve(moduleHandle.getName() + "_" + moduleHandle.getVersion().toString("V.R.C"));
        long index = this.computeModuleCachePathIndex(baseModuleCachePath) + 1L;
        return baseModuleCachePath.resolve(Long.toString(index));
    }

    protected long computeModuleCachePathIndex(Path baseModuleCachePath) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (Stream<Path> moduleEntry = Files.list(baseModuleCachePath);){
                long count = moduleEntry.filter(p -> Files.isDirectory(p, new LinkOption[0])).count();
                long l = count > 0L ? count - 1L : 0L;
                return l;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    @Override
    protected int getRequiredConfVersion() {
        return 1;
    }

    @Override
    protected Path getConfigFile() {
        return this.storePath.resolve("cacheversion.dat");
    }

    public IModuleHandle installModuleHandle(IModuleHandle handle, IModelioProgress monitor) throws FileSystemException, IOException {
        FileModuleStoreHandle h = (FileModuleStoreHandle)handle;
        Path dir = h.getModuleCachePath();
        Path dirParent = dir.getParent();
        Path moduleCatalogPath = this.computeNewModuleStorePath(handle);
        if (!Files.isDirectory(moduleCatalogPath.getParent(), new LinkOption[0])) {
            Files.createDirectories(moduleCatalogPath.getParent(), new FileAttribute[0]);
        }
        if (Files.exists(moduleCatalogPath, new LinkOption[0])) {
            FileUtils.delete((Path)moduleCatalogPath);
        }
        FileUtils.copyDirectoryTo((Path)dirParent, (Path)moduleCatalogPath);
        FileModuleStore.FileModuleStoreEntry entry = new FileModuleStore.FileModuleStoreEntry(moduleCatalogPath, this.metamodelExtensions);
        String key = this.getEntryKey(handle.getName(), handle.getVersion().toString());
        if (this.state == FileModuleStore.FileModuleStoreState.VALID) {
            this.entries.put(key, entry);
        }
        return entry.getModuleHandle(monitor);
    }

    @Override
    protected void load(IModelioProgress monitor) {
        this.entries.clear();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.storePath, file -> Files.isDirectory(file, new LinkOption[0]));){
                for (Path p : stream) {
                    long pathIndex = this.computeModuleCachePathIndex(p);
                    Path entryPath = p.resolve(Long.toString(pathIndex)).toAbsolutePath();
                    FileModuleStore.FileModuleStoreEntry entry = new FileModuleStore.FileModuleStoreEntry(entryPath, this.metamodelExtensions);
                    IModuleHandle mh = entry.getModuleHandle(monitor);
                    String key = this.getEntryKey(mh.getName(), mh.getVersion().toString());
                    this.entries.put(key, entry);
                }
                this.state = FileModuleStore.FileModuleStoreState.VALID;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Log.warning((Throwable)e);
            this.state = FileModuleStore.FileModuleStoreState.INITIAL;
        }
    }
}

