/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.gproject.rtcache;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import org.modelio.gproject.module.IModuleHandle;
import org.modelio.gproject.module.IModuleRTCache;
import org.modelio.gproject.module.IModuleStore;
import org.modelio.gproject.rtcache.FileModuleAdditionStore;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vcore.model.spi.IGMetamodelExtension;

public class ModuleRTCache
implements IModuleRTCache {
    private IModuleStore catalog;
    private FileModuleAdditionStore store;

    public ModuleRTCache(IModuleStore catalog, Collection<IGMetamodelExtension> metamodelFragments, Path cachePath) {
        this.catalog = catalog;
        this.store = new FileModuleAdditionStore(metamodelFragments, cachePath);
    }

    @Override
    public IModuleHandle installModuleArchive(Path archivePath, IModelioProgress monitor) throws IOException {
        return this.store.installModuleArchive(archivePath, monitor);
    }

    @Override
    public IModuleHandle findModule(String name, String version, IModelioProgress monitor) throws IOException {
        IModuleHandle catalogModuleHandle;
        IModuleHandle moduleHandle = this.store.findModule(name, version, monitor);
        if (moduleHandle == null && (catalogModuleHandle = this.catalog.findModule(name, version, monitor)) != null) {
            moduleHandle = this.store.installModuleHandle(catalogModuleHandle, monitor);
        }
        return moduleHandle;
    }

    public IModuleStore getCatalog() {
        return this.catalog;
    }
}

