/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.common;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.resource.Resource;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.files.StreamException;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.NullProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.model.DuplicateObjectException;
import org.modelio.vcore.model.MObjectCache;
import org.modelio.vcore.session.api.blob.IBlobInfo;
import org.modelio.vcore.session.api.repository.IRepository;
import org.modelio.vcore.session.api.repository.IRepositoryQueryRunner;
import org.modelio.vcore.session.api.repository.RepositoryClosedException;
import org.modelio.vcore.session.api.repository.StorageErrorSupport;
import org.modelio.vcore.session.impl.storage.IModelLoader;
import org.modelio.vcore.session.impl.storage.IModelLoaderProvider;
import org.modelio.vcore.session.impl.storage.StorageException;
import org.modelio.vcore.session.impl.storage.dirty.DirtyElementsCache;
import org.modelio.vcore.smkernel.IRepositoryObject;
import org.modelio.vcore.smkernel.ISmObjectData;
import org.modelio.vcore.smkernel.SmLiveId;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.mapi.AbstractMetaclassException;
import org.modelio.vcore.smkernel.mapi.MAttribute;
import org.modelio.vcore.smkernel.mapi.MClass;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vcore.smkernel.mapi.MMetamodelFragment;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vcore.smkernel.meta.MetamodelWriter;
import org.modelio.vcore.smkernel.meta.SmClass;
import org.modelio.vcore.smkernel.meta.SmDependency;
import org.modelio.vcore.smkernel.meta.SmMetamodel;
import org.modelio.vcore.smkernel.meta.descriptor.MetamodelDescriptor;
import org.modelio.vcore.smkernel.meta.descriptor.MetamodelDescriptorReader;
import org.modelio.vcore.smkernel.meta.descriptor.MetamodelDescriptorWriter;
import org.modelio.vcore.smkernel.transaction.IRemoteTransactionManager;
import org.modelio.vstore.exml.common.EmfResource;
import org.modelio.vstore.exml.common.ExmlStorageHandler;
import org.modelio.vstore.exml.common.IExmlBase;
import org.modelio.vstore.exml.common.ILoadHelper;
import org.modelio.vstore.exml.common.IMaintenanceOperations;
import org.modelio.vstore.exml.common.MaintenanceOperations;
import org.modelio.vstore.exml.common.OrphansExmlStorageHandler;
import org.modelio.vstore.exml.common.RepositoryVersions;
import org.modelio.vstore.exml.common.index.CannotOpenIndexException;
import org.modelio.vstore.exml.common.index.ExmlIndex;
import org.modelio.vstore.exml.common.index.ICmsNodeIndex;
import org.modelio.vstore.exml.common.index.IIndexDb;
import org.modelio.vstore.exml.common.index.IUserNodeIndex;
import org.modelio.vstore.exml.common.index.IndexException;
import org.modelio.vstore.exml.common.index.IndexOutdatedException;
import org.modelio.vstore.exml.common.index.hsqldb.HsqlIndexes;
import org.modelio.vstore.exml.common.model.IllegalReferenceException;
import org.modelio.vstore.exml.common.model.IndexElement;
import org.modelio.vstore.exml.common.model.ObjId;
import org.modelio.vstore.exml.common.model.ObjIdName;
import org.modelio.vstore.exml.common.utils.ObjIdReader;
import org.modelio.vstore.exml.plugin.VStoreExml;
import org.modelio.vstore.exml.resource.FsExmlResourceProvider;
import org.modelio.vstore.exml.resource.IExmlResourceProvider;
import org.modelio.vstore.exml.resource.LocalExmlResourceProvider;

public abstract class AbstractExmlRepository
implements IExmlBase {
    private static final boolean TRACE = false;
    private volatile boolean baseOpen;
    private String lastLoad;
    private boolean needRebuildIndexes;
    private byte rid;
    private Boolean writeable = null;
    private final Map<String, ExmlStorageHandler> deletedNodes = new HashMap<String, ExmlStorageHandler>();
    private final Map<String, SmObjectImpl> detachedObjects = new HashMap<String, SmObjectImpl>();
    private final EmfResource emfResource;
    private final StorageErrorSupport errorSupport = new StorageErrorSupport((IRepository)this);
    private ExmlIndex indexes;
    private MObjectCache loadCache;
    private IModelLoaderProvider modelLoaderProvider;
    private ObjIdReader objIdReader;
    private final IRepositoryObject orphansRepoHandler;
    private RepositoryVersions repositoryFormatVersion;
    private final IExmlResourceProvider resProvider;
    private final Collection<WeakReference<ExmlStorageHandler>> storageHandlers = new ArrayList<WeakReference<ExmlStorageHandler>>();
    private Optional<MetamodelDescriptor> storedMetamodelDescriptor;
    private final IRepositoryObject unloadedRepoHandler;
    private DirtyElementsCache dirtyElementsCache;

    protected AbstractExmlRepository(IExmlResourceProvider resProvider) {
        Objects.requireNonNull(resProvider, "resProvider is null.");
        this.resProvider = resProvider;
        this.baseOpen = false;
        this.emfResource = new EmfResource(this);
        this.orphansRepoHandler = new OrphansExmlStorageHandler(this, "orphan");
        this.unloadedRepoHandler = new OrphansExmlStorageHandler(this, "unloaded");
    }

    public IRemoteTransactionManager getRemoteTransactionManager() {
        return IRemoteTransactionManager.NONE;
    }

    @Override
    public final DirtyElementsCache getDirtyElementsCache() {
        return this.dirtyElementsCache;
    }

    protected AbstractExmlRepository(Path path, Path runtimePath, String name) throws IOException {
        this(AbstractExmlRepository.createLocalResourceProvider(path, runtimePath, name));
    }

    protected static IExmlResourceProvider createLocalResourceProvider(Path path, Path runtimePath, String name) throws IOException {
        if (path.getFileSystem().equals(FileSystems.getDefault())) {
            return new LocalExmlResourceProvider(path, runtimePath, name);
        }
        return new FsExmlResourceProvider(path, runtimePath, name);
    }

    public void addCreatedObject(SmObjectImpl newObject) {
        this.assertOpen();
        if (newObject.getClassOf().isCmsNode()) {
            ExmlStorageHandler newHandler = this.createStorageHandler(newObject, true);
            newObject.setRepositoryObject((IRepositoryObject)newHandler);
            newHandler.onObjAttachedToThis(newObject, true);
            newHandler.setDirty(true);
        } else {
            newObject.setRepositoryObject(this.orphansRepoHandler);
        }
        this.getLoadCache().putToCache(newObject);
        this.getDirtyElementsCache().addObject(newObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addObject(SmObjectImpl newObject) {
        this.assertOpen();
        if (newObject.getClassOf().isCmsNode()) {
            ExmlStorageHandler newHandler = this.deletedNodes.remove(newObject.getUuid());
            if (newHandler == null) {
                newHandler = this.createStorageHandler(newObject, true);
                newHandler.setDirty(true);
            } else {
                Collection<WeakReference<ExmlStorageHandler>> collection = this.storageHandlers;
                synchronized (collection) {
                    this.storageHandlers.add(new WeakReference<ExmlStorageHandler>(newHandler));
                }
            }
            newObject.setRepositoryObject((IRepositoryObject)newHandler);
            newHandler.onObjAttachedToThis(newObject, false);
        } else {
            newObject.setRepositoryObject(this.orphansRepoHandler);
        }
        Map<String, SmObjectImpl> map = this.detachedObjects;
        synchronized (map) {
            this.getLoadCache().putToCache(newObject);
            this.detachedObjects.remove(newObject.getUuid());
            this.getDirtyElementsCache().addObject(newObject);
        }
    }

    public synchronized void close() {
        if (!this.baseOpen) {
            return;
        }
        this.baseOpen = false;
        if (this.indexes != null) {
            try {
                this.indexes.close();
                this.indexes = null;
            }
            catch (IndexException e) {
                this.getErrorSupport().fireWarning((Throwable)e);
            }
        }
        if (this.resProvider != null) {
            try {
                this.resProvider.close();
            }
            catch (IOException e) {
                this.getErrorSupport().fireWarning((Throwable)e);
            }
        }
    }

    public void create(MMetamodel mMetamodel) throws IOException {
        this.resProvider.createRepository(mMetamodel);
        this.saveRepositoryVersion(mMetamodel);
        this.saveMetamodelDescriptor(mMetamodel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ExmlStorageHandler createStorageHandler(SmObjectImpl cmsNode, boolean isNodeLoaded) {
        ExmlStorageHandler newHandler = this.instantiateStorageHandler(cmsNode, isNodeLoaded);
        assert (newHandler != null);
        Collection<WeakReference<ExmlStorageHandler>> collection = this.storageHandlers;
        synchronized (collection) {
            this.storageHandlers.add(new WeakReference<ExmlStorageHandler>(newHandler));
        }
        return newHandler;
    }

    public Stream<? extends MObject> streamByAtt(SmClass cls, boolean withSubClasses, String attName, Object val) {
        this.assertOpen();
        MAttribute att = cls.getAttribute(attName);
        try {
            return this.streamAll(cls, withSubClasses).filter(o -> Objects.equals(val, o.mGet(att)));
        }
        catch (StreamException e) {
            this.getErrorSupport().fireWarning(e.getCause());
            return this.getLoadCache().streamByAtt((MClass)cls, withSubClasses, attName, val);
        }
    }

    public Stream<? extends MObject> streamByName(SmClass cls, boolean withSubClasses, String name) {
        try {
            DirtyElementsCache dirtyCache = this.getDirtyElementsCache();
            Set matchingDirty = dirtyCache.streamByName((MClass)cls, withSubClasses, name).collect(Collectors.toSet());
            Stream<Object> indexStream = withSubClasses ? AbstractExmlRepository.streamSubHierarchy(cls).flatMap(subCls -> {
                try {
                    return this.getCmsNodeIndex().findByName((SmClass)subCls, name).stream();
                }
                catch (IndexException e) {
                    throw new StreamException((Exception)e);
                }
            }) : this.getCmsNodeIndex().findByName(cls, name).stream();
            Stream<SmObjectImpl> storedStream = indexStream.map(indexElement -> {
                Throwable throwable = null;
                Object var3_4 = null;
                try (IModelLoader modelLoader = this.modelLoaderProvider.beginLoadSession();){
                    return this.tryGetbyObjIdName(modelLoader, indexElement.object, false);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }).filter(o -> o != null && !dirtyCache.contains((MObject)o));
            if (matchingDirty.isEmpty()) {
                return storedStream;
            }
            return Stream.concat(matchingDirty.stream(), storedStream);
        }
        catch (StreamException e) {
            this.getErrorSupport().fireWarning(e.getCause());
            return this.getLoadCache().streamByAtt((MClass)cls, withSubClasses, cls.getNameAttribute().getName(), (Object)name);
        }
        catch (IndexException e) {
            this.getErrorSupport().fireWarning((Throwable)e);
            return this.getLoadCache().streamByAtt((MClass)cls, withSubClasses, cls.getNameAttribute().getName(), (Object)name);
        }
    }

    public Collection<? extends MObject> findByName(SmClass cls, boolean withSubClasses, String name) {
        try {
            DirtyElementsCache dirtyCache = this.getDirtyElementsCache();
            Set matchingDirty = dirtyCache.streamByName((MClass)cls, withSubClasses, name).collect(Collectors.toSet());
            ArrayList results = new ArrayList(matchingDirty);
            Throwable throwable = null;
            Object var8_11 = null;
            try (IModelLoader modelLoader = this.modelLoaderProvider.beginLoadSession();){
                for (IndexElement indexElement : this.getCmsNodeIndex().findByName(cls, name)) {
                    SmObjectImpl obj = this.tryGetbyObjIdName(modelLoader, indexElement.object, false);
                    if (dirtyCache.contains((MObject)obj)) continue;
                    results.add(obj);
                }
                if (withSubClasses) {
                    for (SmClass subCls : cls.getAllSubClasses()) {
                        if (subCls.isAbstract()) continue;
                        for (IndexElement indexElement : this.getCmsNodeIndex().findByName(subCls, name)) {
                            SmObjectImpl obj = this.tryGetbyObjIdName(modelLoader, indexElement.object, false);
                            if (dirtyCache.contains((MObject)obj)) continue;
                            results.add(obj);
                        }
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return results;
        }
        catch (StreamException | IndexException e) {
            this.getErrorSupport().fireWarning(e.getCause());
            ArrayList results = new ArrayList();
            this.getLoadCache().findByAtt((MClass)cls, withSubClasses, cls.getNameAttribute().getName(), (Object)name, results);
            return results;
        }
    }

    public Stream<? extends MObject> streamByClass(SmClass cls, boolean withSubClasses) {
        try {
            return this.streamAll(cls, withSubClasses);
        }
        catch (StreamException e) {
            this.getErrorSupport().fireError(e.getCause());
            return this.getLoadCache().streamByClass((MClass)cls, withSubClasses);
        }
    }

    public Collection<MObject> findByClass(SmClass cls, boolean withSubClasses) {
        this.assertOpen();
        ArrayList<MObject> results = new ArrayList<MObject>();
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (IModelLoader modelLoader = this.modelLoaderProvider.beginLoadSession();){
                this.loadAll(cls, withSubClasses, modelLoader);
                this.getLoadCache().findByClass((MClass)cls, withSubClasses, results);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IndexException e) {
            this.getLoadCache().findByClass((MClass)cls, withSubClasses, results);
            this.getErrorSupport().fireError((Throwable)e);
        }
        catch (DuplicateObjectException e) {
            this.getErrorSupport().fireError((Throwable)e);
        }
        return results;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SmObjectImpl findById(SmClass cls, String siteIdentifier) {
        ObjId id = new ObjId(cls, siteIdentifier);
        if (this.modelLoaderProvider == null) return null;
        try {
            Throwable throwable = null;
            Object var5_9 = null;
            try (IModelLoader modelLoader = this.modelLoaderProvider.beginLoadSession();){
                SmObjectImpl obj = this.findByObjId(id, modelLoader);
                if (obj != null) {
                    return obj;
                }
                if (cls.getSub(false).isEmpty()) {
                    return null;
                }
                SmObjectImpl found = this.findByIdentifier(siteIdentifier, modelLoader);
                if (found == null) return null;
                if (!cls.isInstance((MObject)found)) return null;
                return found;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (DuplicateObjectException e) {
            this.getErrorSupport().fireError((Throwable)e);
            return null;
        }
        catch (IndexException e) {
            this.getErrorSupport().fireError((Throwable)e);
            return null;
        }
        catch (IllegalReferenceException e) {
            this.getErrorSupport().fireWarning((Throwable)e);
        }
        return null;
    }

    @Override
    public SmObjectImpl findByObjId(ObjId id, IModelLoader modelLoader) throws DuplicateObjectException, IndexException, IllegalReferenceException {
        this.assertOpen();
        SmObjectImpl object = this.getLoadedObject(id);
        if (object != null) {
            return object;
        }
        if (!this.isStored(id)) {
            return null;
        }
        try {
            ILoadHelper helper = this.getloadHelper();
            return helper.createStubObject(modelLoader, helper.withNameFromIndex(id), false);
        }
        catch (DuplicateObjectException e) {
            object = this.getConcurrentlyLoadedObject(id);
            if (object != null) {
                return object;
            }
            throw e;
        }
    }

    public SmObjectImpl findByIdentifier(String uuid, IModelLoader modelLoader) throws DuplicateObjectException, IndexException, IllegalReferenceException {
        this.assertOpen();
        ObjId objId = new ObjId(this.modelLoaderProvider.getMetamodel().getMClass(MObject.class), uuid);
        SmObjectImpl object = this.getLoadedObject(objId);
        if (object != null) {
            return object;
        }
        IndexElement idxEl = this.getCmsNodeIndex().findById(uuid);
        if (idxEl == null) {
            return null;
        }
        if (this.getDetachedObject(idxEl.object.toObjId()) != null) {
            return null;
        }
        try {
            ILoadHelper helper = this.getloadHelper();
            return helper.createStubObject(modelLoader, idxEl.object, false);
        }
        catch (DuplicateObjectException e) {
            object = this.getConcurrentlyLoadedObject(idxEl.object.toObjId());
            if (object != null) {
                return object;
            }
            throw e;
        }
    }

    public final Collection<SmObjectImpl> getAllLoadedObjects() {
        return this.loadCache.asCollection();
    }

    public Iterable<SmObjectImpl> getAllObjects() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ICmsNodeIndex getCmsNodeIndex() throws IndexException {
        try {
            return this.getIndexes().getCmsNodeIndex();
        }
        catch (CannotOpenIndexException e) {
            this.setIndexesDamaged(e);
            throw new IndexException(e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SmObjectImpl getDetachedObject(ObjId id) {
        Map<String, SmObjectImpl> map = this.detachedObjects;
        synchronized (map) {
            return this.detachedObjects.get(id.id);
        }
    }

    @Override
    public final Resource getEmfResource() {
        return this.emfResource;
    }

    public final StorageErrorSupport getErrorSupport() {
        return this.errorSupport;
    }

    public final ExmlIndex getIndexes(IModelioProgress monitor) throws CannotOpenIndexException {
        if (this.indexes == null || this.needRebuildIndexes) {
            this.openIndexes(monitor);
        }
        return this.indexes;
    }

    @Override
    public final MObjectCache getLoadCache() {
        this.assertOpen();
        return this.loadCache;
    }

    @Override
    public final SmObjectImpl getLoadedObject(ObjId id) {
        this.assertOpen();
        return this.getLoadCache().findById((MClass)id.classof, id.id, false);
    }

    public IMaintenanceOperations getMaintenance() {
        return new MaintenanceOperations(this);
    }

    public final Optional<MetamodelDescriptor> getMetamodelDescriptor() {
        if (this.storedMetamodelDescriptor == null) {
            this.storedMetamodelDescriptor = Optional.ofNullable(this.loadMetamodelDescriptor());
        }
        return this.storedMetamodelDescriptor;
    }

    @Override
    public final IModelLoaderProvider getModelLoaderProvider() {
        if (this.modelLoaderProvider == null) {
            throw new IllegalStateException("The '" + String.valueOf(this.getURI()) + "' repository is not open.");
        }
        return this.modelLoaderProvider;
    }

    public final byte getRepositoryId() {
        return this.rid;
    }

    public final IExmlResourceProvider getResourceProvider() {
        return this.resProvider;
    }

    public final URI getURI() {
        return this.resProvider.getURI();
    }

    public final IUserNodeIndex getUserNodeIndex() throws IndexException {
        try {
            return this.getIndexes().getUserNodeIndex();
        }
        catch (CannotOpenIndexException e) {
            this.setIndexesDamaged(e);
            throw new IndexException(e.getLocalizedMessage(), e);
        }
    }

    public void init(byte arid) {
        this.rid = arid;
    }

    public final boolean isDirty() {
        return !this.getDirtyHandlers().isEmpty() || !this.deletedNodes.isEmpty();
    }

    public final boolean isOpen() {
        return this.baseOpen;
    }

    public final boolean isStored(SmObjectImpl obj) {
        return SmLiveId.getRid((long)obj.getLiveId()) == this.rid && this.isStored(new ObjId(obj));
    }

    @Override
    public boolean isStored(ObjId id) {
        try {
            return this.getDetachedObject(id) == null && this.getCmsNodeIndex().isStored(id);
        }
        catch (IndexException e) {
            this.setIndexesDamaged(e);
            this.getErrorSupport().fireError((Throwable)e);
            return false;
        }
    }

    @Override
    public SmObjectImpl loadCmsNode(ObjId id, IModelLoader modelLoader, boolean force) throws DuplicateObjectException {
        SmObjectImpl obj;
        block9: {
            obj = null;
            Exception failure = null;
            try {
                obj = this.findByObjId(id, modelLoader);
            }
            catch (IndexException e) {
                this.setIndexesDamaged(e);
                failure = e;
            }
            catch (IllegalReferenceException e) {
                this.setIndexesDamaged(e);
                failure = e;
            }
            if (obj != null) {
                IRepositoryObject repoHandle = obj.getRepositoryObject();
                if (repoHandle.getRepositoryId() == this.getRepositoryId() && (force || !((ExmlStorageHandler)repoHandle).isLoaded())) {
                    this.reloadCmsNode(obj, modelLoader);
                }
            } else if (failure != null) {
                try {
                    obj = this.getloadHelper().createStubCmsNode(modelLoader, id, "");
                    this.getloadHelper().loadFailed(obj, modelLoader, failure);
                }
                catch (DuplicateObjectException e) {
                    obj = this.getConcurrentlyLoadedObject(id);
                    if (obj != null) break block9;
                    throw e;
                }
            }
        }
        return obj;
    }

    public void loadDynamicDep(SmObjectImpl obj, SmDependency dep) {
        this.assertOpen();
        try {
            Throwable throwable = null;
            Object var4_8 = null;
            try (IModelLoader modelLoader = this.modelLoaderProvider.beginLoadSession();){
                for (ObjId depTargetId : this.getUserNodeIndex().getObjectUsers(new ObjId(obj), dep.getSymetric().getName())) {
                    SmObjectImpl depTarget = this.findByObjId(depTargetId, modelLoader);
                    if (depTarget == null) continue;
                    depTarget.getRepositoryObject().loadDep(depTarget, dep.getSymetric());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (DuplicateObjectException e) {
            this.getErrorSupport().fireError((Throwable)e);
        }
        catch (IndexException e) {
            this.getErrorSupport().fireError((Throwable)e);
        }
        catch (IllegalReferenceException e) {
            this.getErrorSupport().fireError((Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public final ISmObjectData loadObjectData(SmObjectImpl obj) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void open(IModelLoaderProvider modelLoadProvider, IModelioProgress monitor) throws IOException {
        if (this.baseOpen) {
            throw new IllegalStateException("The '" + String.valueOf(this.getURI()) + "' repository is already open.");
        }
        this.resProvider.open();
        this.writeable = this.resProvider.isWriteable();
        this.loadCache = new MObjectCache(modelLoadProvider.getMetamodel());
        this.dirtyElementsCache = new DirtyElementsCache(modelLoadProvider.getMetamodel());
        this.modelLoaderProvider = modelLoadProvider;
        String clsSimpleName = this.getClass().getSimpleName() + ": ";
        this.objIdReader = new ObjIdReader(this.modelLoaderProvider.getMetamodel(), () -> clsSimpleName, () -> "");
        this.checkVersions();
        boolean ok = false;
        try {
            try {
                this.openIndexes(monitor);
                this.baseOpen = true;
                this.initializeLoader();
                ok = true;
            }
            catch (CannotOpenIndexException e) {
                throw new IOException(e.getLocalizedMessage(), e);
            }
        }
        finally {
            if (!ok) {
                this.baseOpen = false;
            }
        }
    }

    public InputStream readBlob(String key) throws IOException {
        return this.resProvider.readBlob(key);
    }

    public IBlobInfo readBlobInfo(String key) throws IOException {
        return this.resProvider.readBlobInfo(key);
    }

    public void refreshModel(Collection<MObject> toReload, Collection<MObject> toDelete, Collection<MRef> toRestore) {
        IModelLoaderProvider loaderProv = this.getModelLoaderProvider();
        loaderProv.asyncRefreshModel(refresher -> {
            block15: {
                try {
                    SmObjectImpl impl;
                    Object id;
                    if (toRestore != null) {
                        SmMetamodel metamodel = loaderProv.getMetamodel();
                        for (MRef ref : toRestore) {
                            Map<String, SmObjectImpl> map = this.detachedObjects;
                            synchronized (map) {
                                this.detachedObjects.remove(ref.uuid);
                                this.deletedNodes.remove(ref.uuid);
                            }
                            id = new ObjId(metamodel.getMClass(ref.mc), ref.uuid);
                            this.loadCmsNode((ObjId)id, (IModelLoader)refresher, true);
                        }
                    }
                    for (MObject obj : toReload) {
                        Map<String, SmObjectImpl> map = this.detachedObjects;
                        synchronized (map) {
                            this.detachedObjects.remove(obj.getUuid());
                            this.deletedNodes.remove(obj.getUuid());
                        }
                        impl = (SmObjectImpl)obj;
                        id = this.loadCmsNode(new ObjId(impl), (IModelLoader)refresher, true);
                    }
                    if (toDelete == null) break block15;
                    for (MObject obj : toDelete) {
                        impl = this.detachedObjects;
                        synchronized (impl) {
                            this.detachedObjects.remove(obj.getUuid());
                            this.deletedNodes.remove(obj.getUuid());
                        }
                        impl = (SmObjectImpl)obj;
                        IRepositoryObject h = impl.getRepositoryObject();
                        if (h.getRepositoryId() != this.getRepositoryId()) continue;
                        refresher.deleteObject(impl);
                    }
                }
                catch (DuplicateObjectException e) {
                    this.getErrorSupport().fireError((Throwable)e);
                }
            }
        });
    }

    /*
     * Loose catch block
     */
    @Override
    public final synchronized void reloadCmsNode(SmObjectImpl obj, IModelLoader modelLoader) throws DuplicateObjectException {
        block13: {
            ExmlStorageHandler exmlHandler = (ExmlStorageHandler)obj.getRepositoryObject();
            boolean ret = false;
            try {
                try {
                    exmlHandler.setLoaded(true);
                    this.doReloadCmsNode(obj, modelLoader);
                    ret = true;
                    exmlHandler.setDirty(false);
                }
                catch (IndexException e) {
                    this.getloadHelper().loadFailed(obj, modelLoader, e);
                    this.setIndexesDamaged(e);
                    if (!ret) {
                        exmlHandler.setLoaded(false);
                    }
                }
                catch (IOException | RuntimeException e) {
                    this.getloadHelper().loadFailed(obj, modelLoader, e);
                    if (!ret) {
                        exmlHandler.setLoaded(false);
                    }
                }
                catch (AssertionError err) {
                    this.getloadHelper().loadFailed(obj, modelLoader, new IllegalStateException((Throwable)((Object)err)));
                    if (!ret) {
                        exmlHandler.setLoaded(false);
                    }
                    break block13;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                if (!ret) {
                    exmlHandler.setLoaded(false);
                }
            }
        }
    }

    public void removeBlob(String key) throws IOException {
        this.resProvider.deleteBlob(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeObject(SmObjectImpl object) {
        Map<String, SmObjectImpl> map = this.detachedObjects;
        synchronized (map) {
            this.loadCache.removeFromCache(object);
            this.detachedObjects.put(object.getUuid(), object);
        }
        if (object.getClassOf().isCmsNode()) {
            ExmlStorageHandler handler = (ExmlStorageHandler)object.getRepositoryObject();
            this.deletedNodes.put(object.getUuid(), handler);
            Collection<WeakReference<ExmlStorageHandler>> collection = this.storageHandlers;
            synchronized (collection) {
                Iterator<WeakReference<ExmlStorageHandler>> it = this.storageHandlers.iterator();
                while (it.hasNext()) {
                    WeakReference<ExmlStorageHandler> ref = it.next();
                    if (ref.get() != handler) continue;
                    it.remove();
                }
            }
        } else {
            object.setRepositoryObject(this.orphansRepoHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save(IModelioProgress monitor) {
        Collection<ExmlStorageHandler> dirty = this.getDirtyHandlers();
        if (dirty.isEmpty()) {
            return;
        }
        String repositoryName = this.getResourceProvider().getName();
        int nbDirty = dirty.size();
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)(nbDirty * 20));
        mon.subTask(VStoreExml.I18N.getMessage("AbstractExmlRepository.save.begin", new Object[]{repositoryName}));
        try {
            if (!this.deletedNodes.isEmpty()) {
                mon.subTask(VStoreExml.I18N.getMessage("AbstractExmlRepository.save.deleting", new Object[]{repositoryName, this.deletedNodes.size()}));
                this.deleteCmsNodes(this.deletedNodes.values(), (IModelioProgress)mon.newChild(this.deletedNodes.size()));
            }
            int i = 0;
            nbDirty = dirty.size();
            for (ExmlStorageHandler handler : dirty) {
                try {
                    if (handler.isLoaded() && !this.deletedNodes.containsKey(handler.getCmsNodeId().id)) {
                        this.save(handler, (IModelioProgress)mon.newChild(10));
                    }
                    handler.setDirty(false);
                }
                catch (IOException e) {
                    String message = VStoreExml.I18N.getMessage("AbstractExmlRepository.saveNodeFailed", new Object[]{handler.getCmsNodeId(), FileUtils.getLocalizedMessage((IOException)e), this.getResourceProvider().getName()});
                    this.getErrorSupport().fireWarning((Throwable)new StorageException((IRepository)this, message, (Throwable)e));
                }
                mon.worked(1);
                if (++i % 5 != 0) continue;
                mon.subTask(VStoreExml.I18N.getMessage("AbstractExmlRepository.save.progress", new Object[]{repositoryName, i, nbDirty}));
            }
            this.saveMetamodelDescriptor();
            this.resProvider.commit();
            Map<String, SmObjectImpl> map = this.detachedObjects;
            synchronized (map) {
                this.deletedNodes.clear();
                this.detachedObjects.clear();
            }
            this.dirtyElementsCache.clear();
        }
        catch (IOException e) {
            this.getErrorSupport().fireError((Throwable)e);
        }
        mon.subTask(VStoreExml.I18N.getMessage("AbstractExmlRepository.save.indexes", new Object[]{repositoryName}));
        mon.setWorkRemaining(100);
        this.updateIndexes(dirty, (IModelioProgress)mon);
        mon.subTask(VStoreExml.I18N.getMessage("AbstractExmlRepository.save.done", new Object[]{repositoryName}));
    }

    public final void saveMetamodelDescriptor() throws IOException {
        SmMetamodel metamodel = this.getModelLoaderProvider().getMetamodel();
        MetamodelDescriptor desc = this.saveMetamodelDescriptor((MMetamodel)metamodel);
        this.storedMetamodelDescriptor = Optional.of(desc);
    }

    @Override
    public final void setIndexesDamaged(Exception e) {
        if (!this.needRebuildIndexes) {
            String m1 = e.getLocalizedMessage();
            String reposName = this.resProvider.getName();
            String msg = VStoreExml.I18N.getMessage("AbstractExmlRepository.setIndexDamaged", new Object[]{reposName, m1});
            this.getErrorSupport().fireWarning((Throwable)new StorageException((IRepository)this, msg, (Throwable)e));
            if (this.indexes != null) {
                try {
                    this.indexes.close();
                }
                catch (IndexException e1) {
                    msg = VStoreExml.I18N.getMessage("AbstractExmlRepository.setIndexDamaged.closeFailed", new Object[]{reposName, e1.getLocalizedMessage()});
                    this.getErrorSupport().fireWarning((Throwable)new StorageException((IRepository)this, msg, (Throwable)e1));
                }
            }
            this.needRebuildIndexes = true;
        }
    }

    public String toString() {
        return "'" + this.resProvider.getName() + "' " + this.getClass().getSimpleName() + " @ " + String.valueOf(this.resProvider.getURI());
    }

    @Override
    public void unloadObject(SmObjectImpl obj) {
        ExmlStorageHandler handler = (ExmlStorageHandler)obj.getRepositoryObject();
        this.loadCache.removeFromCache(obj);
        this.detachedObjects.remove(obj.getUuid());
        obj.setRepositoryObject(this.unloadedRepoHandler);
        if (this.baseOpen) {
            handler.setToReload(obj);
        }
    }

    public void updateIndexes(Collection<MRef> createdRefs, Collection<MRef> updatedRefs, Collection<MRef> deletedRefs, IModelioProgress progress) {
        int nbChanges = createdRefs.size() + updatedRefs.size() + deletedRefs.size();
        if (nbChanges == 0) {
            return;
        }
        int workAmount = 10 + nbChanges;
        SubProgress monitor = SubProgress.convert((IModelioProgress)progress, (int)workAmount);
        try {
            ObjId nodeId;
            this.resProvider.writeStamp();
            ExmlIndex index = this.getIndexes((IModelioProgress)monitor.newChild(10));
            monitor.subTask(VStoreExml.I18N.getMessage("AbstractExmlRepository.mon.updatingIndexes", new Object[]{this.resProvider.getName()}));
            for (MRef r : deletedRefs) {
                nodeId = this.objIdReader.readObjId(r, true);
                index.removeFromIndexes(nodeId);
                monitor.worked(1);
            }
            for (MRef r : createdRefs) {
                nodeId = this.objIdReader.readObjId(r, true);
                index.updateIndexes(nodeId);
                monitor.worked(1);
            }
            for (MRef r : updatedRefs) {
                nodeId = this.objIdReader.readObjId(r, true);
                index.updateIndexes(nodeId);
                monitor.worked(1);
            }
            index.commitDb();
        }
        catch (IOException | IndexException e) {
            this.setIndexesDamaged(e);
        }
        catch (CannotOpenIndexException e) {
            this.setIndexesDamaged(e);
            this.getErrorSupport().fireError((Throwable)e);
        }
        monitor.done();
    }

    public OutputStream writeBlob(IBlobInfo info) throws IOException {
        return this.resProvider.writeBlob(info);
    }

    protected void deleteCmsNodes(Collection<ExmlStorageHandler> toDelete, IModelioProgress monitor) {
        SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)(toDelete.size() * 2 + 1));
        for (ExmlStorageHandler del : toDelete) {
            ObjId id = del.getCmsNodeId();
            try {
                this.resProvider.getResource(id).delete();
                this.resProvider.getLocalResource(id).delete();
            }
            catch (IOException e) {
                this.getErrorSupport().fireWarning((Throwable)e);
            }
            del.setDirty(false);
            mon.worked(1);
        }
        try {
            ExmlIndex lindexes = this.getIndexes((IModelioProgress)mon.newChild(1));
            for (ExmlStorageHandler del : toDelete) {
                ObjId id = del.getCmsNodeId();
                lindexes.removeFromIndexes(id);
                for (ObjId objId : this.getCmsNodeIndex().getCmsNodeContent(id)) {
                    lindexes.getUserNodeIndex().remove(objId);
                }
                lindexes.getCmsNodeIndex().removeObj(id);
                mon.worked(1);
            }
        }
        catch (IndexException e) {
            this.setIndexesDamaged(e);
        }
        catch (CannotOpenIndexException e) {
            this.setIndexesDamaged(e);
        }
    }

    protected abstract void doReloadCmsNode(SmObjectImpl var1, IModelLoader var2) throws DuplicateObjectException, IOException, IndexException;

    protected abstract ILoadHelper getloadHelper();

    protected abstract void initializeLoader();

    protected ExmlStorageHandler instantiateStorageHandler(SmObjectImpl cmsNode, boolean isNodeLoaded) {
        ExmlStorageHandler newHandler = new ExmlStorageHandler(this, cmsNode, isNodeLoaded);
        return newHandler;
    }

    protected IIndexDb instantiateIndexDb() {
        Path indexPath = this.resProvider.getIndexAccessPath().toPath().resolve("hsql");
        return new HsqlIndexes(indexPath, this.resProvider.getName(), true);
    }

    protected final boolean isWriteable() throws IllegalStateException {
        if (this.writeable == null) {
            throw new IllegalStateException("The base is not open");
        }
        return this.writeable;
    }

    protected abstract void save(ExmlStorageHandler var1, IModelioProgress var2) throws IOException;

    protected final void saveRepositoryVersion(MMetamodel mm) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStream out = this.getResourceProvider().getRepositoryVersionResource().bufferedWrite();){
            RepositoryVersions v = this.repositoryFormatVersion != null ? new RepositoryVersions(this.repositoryFormatVersion.getRepositoryFormat(), mm) : new RepositoryVersions(mm);
            v.write(out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void assertOpen() {
        if (!this.baseOpen) {
            throw new RepositoryClosedException("The '" + String.valueOf(this.getURI()) + "' repository is not open.");
        }
    }

    private void checkVersions() throws IOException {
        this.repositoryFormatVersion = this.getResourceProvider().readRepositoryVersion();
        SmMetamodel metamodel = this.getModelLoaderProvider().getMetamodel();
        if (this.repositoryFormatVersion == null) {
            this.repositoryFormatVersion = new RepositoryVersions((MMetamodel)metamodel);
            if (this.writeable == Boolean.TRUE) {
                Log.trace((String)"No version file for '%s' repository. Creating one", (Object[])new Object[]{this.getURI()});
                this.saveRepositoryVersion((MMetamodel)metamodel);
                this.saveMetamodelDescriptor((MMetamodel)metamodel);
            } else {
                Log.warning((String)"No version file for read only '%s' repository.", (Object[])new Object[]{this.getURI()});
            }
        } else {
            this.repositoryFormatVersion.checkCompatible((MMetamodel)metamodel);
        }
    }

    private SmObjectImpl getByObjIdName(ObjIdName idn, boolean checkExist, IModelLoader modelLoader) throws DuplicateObjectException, IllegalReferenceException, IndexException {
        this.assertOpen();
        ObjId id = idn.toObjId();
        SmObjectImpl object = this.getLoadedObject(id);
        if (object != null) {
            return object;
        }
        if (checkExist && !this.isStored(id)) {
            return null;
        }
        try {
            return this.getloadHelper().createStubObject(modelLoader, idn, false);
        }
        catch (DuplicateObjectException e) {
            object = this.getConcurrentlyLoadedObject(id);
            if (object != null) {
                return object;
            }
            throw e;
        }
    }

    private SmObjectImpl getConcurrentlyLoadedObject(ObjId id) {
        SmObjectImpl object = this.getLoadedObject(id);
        int i = 0;
        while (i < 10 && object == null) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
            object = this.getLoadedObject(id);
            ++i;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ExmlStorageHandler> getDirtyHandlers() {
        ArrayList<ExmlStorageHandler> ret = new ArrayList<ExmlStorageHandler>();
        Collection<WeakReference<ExmlStorageHandler>> collection = this.storageHandlers;
        synchronized (collection) {
            for (WeakReference<ExmlStorageHandler> handlerRef : this.storageHandlers) {
                ExmlStorageHandler handler = (ExmlStorageHandler)handlerRef.get();
                if (handler == null || !handler.isDirty()) continue;
                ret.add(handler);
            }
        }
        return ret;
    }

    private ExmlIndex getIndexes() throws CannotOpenIndexException {
        return this.getIndexes((IModelioProgress)new NullProgress());
    }

    private void loadAll(SmClass cls, boolean recursive, IModelLoader modelLoader) throws DuplicateObjectException, IndexException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Stream<? extends MObject> stream = this.streamAll(cls, recursive);){
                stream.forEach(o -> {});
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (StreamException e) {
            e.rethrow();
            e.rethrow();
        }
    }

    private void _loadAll(SmClass cls, IModelLoader modelLoader) throws DuplicateObjectException, IndexException {
        if (cls.isAbstract()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Stream<ObjIdName> idByMClass = this.streamAllIds(cls);){
                idByMClass.forEach(objId -> this.tryGetbyObjIdName(modelLoader, (ObjIdName)objId, true));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (StreamException e) {
            e.rethrow();
            e.rethrow();
        }
    }

    private SmObjectImpl tryGetbyObjIdName(IModelLoader modelLoader, ObjIdName objId, boolean checkExist) throws StreamException {
        try {
            return this.getByObjIdName(objId, checkExist, modelLoader);
        }
        catch (AbstractMetaclassException e) {
            this.getErrorSupport().fireWarning((Throwable)e);
            return null;
        }
        catch (IllegalReferenceException e) {
            try {
                SmObjectImpl foundobj = modelLoader.loadForeignObject(objId.classof, objId.id, objId.name);
                if (foundobj.isShell()) {
                    this.setIndexesDamaged(e);
                    this.getErrorSupport().fireWarning((Throwable)e);
                }
            }
            catch (RuntimeException e2) {
                e.addSuppressed(e2);
                this.setIndexesDamaged(e);
                this.getErrorSupport().fireWarning((Throwable)e);
            }
            return null;
        }
        catch (DuplicateObjectException e) {
            throw new StreamException((Exception)((Object)e));
        }
        catch (IndexException e) {
            throw new StreamException((Exception)e);
        }
    }

    private Stream<? extends MObject> streamAll(SmClass cls) throws StreamException {
        if (cls.isAbstract()) {
            return Stream.empty();
        }
        HashSet matchingDirtyEls = new HashSet();
        this.loadCache.findByClass((MClass)cls, false, matchingDirtyEls);
        Stream<SmObjectImpl> storedStream = this.streamAllIds(cls).map(objId -> {
            Throwable throwable = null;
            Object var3_4 = null;
            try (IModelLoader loadSession = this.modelLoaderProvider.beginLoadSession();){
                return this.tryGetbyObjIdName(loadSession, (ObjIdName)objId, true);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }).filter(o -> o != null && !matchingDirtyEls.contains(o));
        if (matchingDirtyEls.isEmpty()) {
            return storedStream;
        }
        return Stream.concat(storedStream, matchingDirtyEls.stream());
    }

    private Stream<ObjIdName> streamAllIds(SmClass cls) throws StreamException {
        try {
            Stream<ObjIdName> s2 = this.getCmsNodeIndex().idByMClass(cls);
            return s2;
        }
        catch (IndexException e) {
            throw new StreamException((Exception)e);
        }
    }

    private Stream<? extends MObject> streamAll(SmClass cls, boolean recursive) throws StreamException {
        if (!recursive) {
            return this.streamAll(cls);
        }
        return AbstractExmlRepository.streamSubHierarchy(cls).flatMap(c -> this.streamAll((SmClass)c));
    }

    protected static Stream<SmClass> streamSubHierarchy(SmClass cls) {
        ArrayList<SmClass> allSubClasses = new ArrayList<SmClass>();
        if (!cls.isAbstract()) {
            allSubClasses.add(cls);
        }
        for (SmClass c : cls.getAllSubClasses()) {
            if (c.isAbstract()) continue;
            allSubClasses.add(c);
        }
        return allSubClasses.stream();
    }

    private MetamodelDescriptor loadMetamodelDescriptor() {
        InputStream in;
        block14: {
            MetamodelDescriptor metamodelDescriptor;
            block15: {
                IExmlResourceProvider.ExmlResource mmDescRes = this.getResourceProvider().getMetamodelDescriptorResource();
                Throwable throwable = null;
                Object var3_5 = null;
                in = mmDescRes.bufferedRead();
                try {
                    MetamodelDescriptor desc;
                    if (in == null) break block14;
                    metamodelDescriptor = desc = MetamodelDescriptorReader.readFrom((InputStream)in, (String)mmDescRes.getPublicLocation());
                    if (in == null) break block15;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (in != null) {
                                in.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (FileNotFoundException | NoSuchFileException iOException) {
                        return null;
                    }
                    catch (IOException e) {
                        this.getErrorSupport().fireWarning((Throwable)e);
                        return null;
                    }
                }
                in.close();
            }
            return metamodelDescriptor;
        }
        if (in != null) {
            in.close();
        }
        return null;
    }

    private boolean openIndexes(IModelioProgress aMonitor) throws CannotOpenIndexException {
        File indexAccessPath;
        if (this.indexes != null) {
            try {
                this.indexes.close();
            }
            catch (IndexException e) {
                Log.warning((String)"%s index closing failed: %s", (Object[])new Object[]{this.resProvider.getName(), e.getLocalizedMessage()});
                Log.warning((Throwable)e);
            }
        }
        if ((indexAccessPath = this.resProvider.getIndexAccessPath()) != null) {
            try {
                Files.createDirectories(indexAccessPath.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new CannotOpenIndexException(FileUtils.getLocalizedMessage((IOException)e), e);
            }
        }
        boolean indexesRebuilt = false;
        this.indexes = new ExmlIndex(this.resProvider, this::instantiateIndexDb, this.getErrorSupport());
        if (this.resProvider.isBrowsable() && (indexAccessPath == null || indexAccessPath.canWrite())) {
            try {
                this.indexes.open(aMonitor, this.getModelLoaderProvider().getMetamodel());
                this.indexes.checkUptodate();
            }
            catch (IndexException e) {
                this.setIndexesDamaged(e);
            }
            catch (RuntimeException e) {
                this.setIndexesDamaged(e);
            }
            catch (IndexOutdatedException e) {
                Log.trace((String)e.getLocalizedMessage());
                this.needRebuildIndexes = true;
            }
            catch (IOException e) {
                throw new CannotOpenIndexException(FileUtils.getLocalizedMessage((IOException)e), e);
            }
            if (this.needRebuildIndexes) {
                try {
                    Throwable e = null;
                    Object var6_18 = null;
                    try (ExmlIndex.CloseOnFail shield = this.indexes.getCloseOnFail();){
                        SubProgress mon = SubProgress.convert((IModelioProgress)aMonitor, (int)100);
                        this.resProvider.writeStamp();
                        mon.subTask(VStoreExml.I18N.getMessage("AbstractExmlRepository.mon.deletingIndexes", new Object[]{this.resProvider.getName()}));
                        this.indexes.deleteIndexes();
                        this.indexes.open((IModelioProgress)mon.newChild(10), this.modelLoaderProvider.getMetamodel());
                        mon.subTask(VStoreExml.I18N.getMessage("AbstractExmlRepository.mon.buildingIndexes", new Object[]{this.resProvider.getName()}));
                        this.indexes.buildIndexes((IModelioProgress)mon.newChild(90));
                        shield.success();
                        this.needRebuildIndexes = false;
                        indexesRebuilt = true;
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (IOException e1) {
                    String msg = VStoreExml.I18N.getMessage("AbstractExmlRepository.RebuildIndexFailed", new Object[]{this.resProvider.getName(), FileUtils.getLocalizedMessage((IOException)e1)});
                    throw new CannotOpenIndexException(msg, e1);
                }
                catch (IndexException e1) {
                    String msg = VStoreExml.I18N.getMessage("AbstractExmlRepository.RebuildIndexFailed", new Object[]{this.resProvider.getName(), e1.getLocalizedMessage()});
                    throw new CannotOpenIndexException(msg, e1);
                }
            }
        } else {
            try {
                this.indexes.open(aMonitor, this.modelLoaderProvider.getMetamodel());
                this.indexes.checkUptodate();
            }
            catch (RuntimeException e) {
                String msg = VStoreExml.I18N.getMessage("AbstractExmlRepository.RoIndexesDamaged", new Object[]{this.resProvider.getName(), e.toString()});
                throw new CannotOpenIndexException(msg, e);
            }
            catch (IndexOutdatedException e) {
                String msg = VStoreExml.I18N.getMessage("AbstractExmlRepository.RoIndexesOutdated", new Object[]{this.resProvider.getName(), e.getLocalizedMessage()});
                throw new CannotOpenIndexException(msg, e);
            }
            catch (IndexException e) {
                String msg = VStoreExml.I18N.getMessage("AbstractExmlRepository.RoIndexesDamaged", new Object[]{this.resProvider.getName(), e.getLocalizedMessage()});
                throw new CannotOpenIndexException(msg, e);
            }
            catch (IOException e) {
                String msg = VStoreExml.I18N.getMessage("AbstractExmlRepository.RoIndexesDamaged", new Object[]{this.resProvider.getName(), FileUtils.getLocalizedMessage((IOException)e)});
                throw new CannotOpenIndexException(msg, e);
            }
        }
        return indexesRebuilt;
    }

    protected void updateIndexes(Collection<ExmlStorageHandler> dirty, IModelioProgress progress) {
        if (dirty.isEmpty()) {
            return;
        }
        try {
            SubProgress mon = SubProgress.convert((IModelioProgress)progress, (int)(dirty.size() + 5));
            ExmlIndex lindexes = this.getIndexes((IModelioProgress)mon.newChild(3));
            for (ExmlStorageHandler handler : dirty) {
                lindexes.updateIndexes(handler.getCmsNodeId());
                mon.worked(1);
            }
            lindexes.commitDb();
        }
        catch (CannotOpenIndexException | IndexException e) {
            this.setIndexesDamaged(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isMetamodelFragmentUsed(SmMetamodel metamodel, MMetamodelFragment mmf) throws StreamException {
        for (SmClass mc : metamodel.getRegisteredMClasses(mmf)) {
            if (!mc.isCmsNode()) continue;
            try {
                Throwable throwable = null;
                Object var6_9 = null;
                try (Stream<ObjIdName> idByMClass = this.getIndexes().getCmsNodeIndex().idByMClass(mc);){
                    if (!idByMClass.findAny().isPresent()) continue;
                    return true;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (IndexException e) {
                this.setIndexesDamaged(e);
                throw new StreamException((Exception)e);
            }
            catch (CannotOpenIndexException e) {
                throw new StreamException((Exception)e);
            }
        }
        return false;
    }

    private MetamodelDescriptor saveMetamodelDescriptor(MMetamodel metamodel) throws IOException {
        IExmlResourceProvider.ExmlResource mmDescRes = this.getResourceProvider().getMetamodelDescriptorResource();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (OutputStream out = mmDescRes.bufferedWrite();){
                MetamodelDescriptor desc = new MetamodelWriter().run(metamodel);
                if (out == null) {
                    return desc;
                }
                new MetamodelDescriptorWriter().write(desc, out);
                return desc;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (StreamException e) {
            throw new IOException(e.getCause().getLocalizedMessage(), e);
        }
    }

    public IRepositoryQueryRunner query() {
        return new IRepositoryQueryRunner(){

            public void loadAllReferencesTo(Collection<SmObjectImpl> objs) {
                AbstractExmlRepository.this.loadAllReferencesTo(objs);
            }

            public void close() {
            }
        };
    }

    private void loadAllReferencesTo(Collection<SmObjectImpl> objs) {
        this.modelLoaderProvider.getMetamodel();
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (IModelLoader modelLoader = this.modelLoaderProvider.beginLoadSession();){
                ArrayList<ObjId> objectIds = new ArrayList<ObjId>(objs.size());
                objs.forEach(o -> {
                    boolean bl = objectIds.add(new ObjId((SmObjectImpl)o));
                });
                this.getIndexes().getUserNodeIndex().getObjectUsers(objectIds).forEach(ref -> {
                    try {
                        SmObjectImpl refObj = this.findByObjId((ObjId)ref, modelLoader);
                        if (refObj != null) {
                            refObj.getRepositoryObject().loadAtt(refObj, null);
                        }
                    }
                    catch (DuplicateObjectException e) {
                        this.getErrorSupport().fireError((Throwable)e);
                    }
                    catch (NullPointerException | IndexException | IllegalReferenceException e) {
                        this.setIndexesDamaged(e);
                        this.getErrorSupport().fireWarning((Throwable)e);
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IndexException e) {
            this.setIndexesDamaged(e);
            this.getErrorSupport().fireWarning((Throwable)e);
        }
        catch (CannotOpenIndexException e) {
            this.getErrorSupport().fireError((Throwable)e);
        }
    }
}

