/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.common;

import java.io.IOException;
import org.eclipse.emf.ecore.resource.Resource;
import org.modelio.vbasic.log.Log;
import org.modelio.vcore.model.DuplicateObjectException;
import org.modelio.vcore.session.api.repository.RepositoryClosedException;
import org.modelio.vcore.session.impl.storage.IModelLoader;
import org.modelio.vcore.smkernel.IRepositoryObject;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.StatusState;
import org.modelio.vcore.smkernel.mapi.MDependency;
import org.modelio.vcore.smkernel.meta.SmAttribute;
import org.modelio.vcore.smkernel.meta.SmDependency;
import org.modelio.vstore.exml.common.IExmlBase;
import org.modelio.vstore.exml.common.index.ICmsNodeIndex;
import org.modelio.vstore.exml.common.index.IndexException;
import org.modelio.vstore.exml.common.model.IllegalReferenceException;
import org.modelio.vstore.exml.common.model.ObjId;
import org.modelio.vstore.exml.common.utils.ExmlUtils;

public class ExmlStorageHandler
implements IRepositoryObject {
    private boolean loaded;
    private boolean dirty;
    private boolean parentLoaded;
    private final IExmlBase base;
    private SmObjectImpl cmsNode;
    private final ObjId cmsNodeId;

    protected static boolean isInverseCompositionDep(MDependency dep) {
        return dep.getSymetric() != null && dep.getSymetric().isComposition();
    }

    public ExmlStorageHandler(IExmlBase base, SmObjectImpl cmsNode, boolean isNodeLoaded) {
        this.cmsNode = cmsNode;
        this.base = base;
        this.loaded = isNodeLoaded;
        this.cmsNodeId = new ObjId(cmsNode);
    }

    public void attModified(SmObjectImpl obj, SmAttribute att, Object oldVal) {
        this.dirty = true;
        this.getBase().getDirtyElementsCache().addModified(obj, att, oldVal);
    }

    public void attach(SmObjectImpl obj) {
        if (this == obj.getRepositoryObject()) {
            return;
        }
        this.base.addObject(obj);
        if (!obj.getClassOf().isCmsNode()) {
            obj.setRepositoryObject((IRepositoryObject)this);
            this.onObjAttachedToThis(obj, false);
        }
    }

    public void attachCreatedObj(SmObjectImpl obj) {
        if (this == obj.getRepositoryObject()) {
            return;
        }
        this.base.addCreatedObject(obj);
        if (!obj.getClassOf().isCmsNode()) {
            obj.setRepositoryObject((IRepositoryObject)this);
            this.onObjAttachedToThis(obj, true);
        }
    }

    protected void onObjAttachedToThis(SmObjectImpl obj, boolean isNewObject) {
        assert (this == obj.getRepositoryObject()) : String.format("%s is attached to %s instead of %s", obj, obj.getRepositoryObject(), this);
        this.setDirty(true);
    }

    public void depValAppended(SmObjectImpl obj, SmDependency dep, SmObjectImpl val) {
        if (ExmlStorageHandler.isDepPersistent(dep)) {
            this.dirty = true;
        }
        if (ExmlUtils.isComposition(obj, dep, val) && !val.getClassOf().isCmsNode() && val.getRepositoryObject() != this) {
            this.propagateHandler(val);
        }
    }

    public void depValErased(SmObjectImpl obj, SmDependency dep, SmObjectImpl val) {
        IRepositoryObject newHandle;
        SmObjectImpl newOwner;
        if (ExmlStorageHandler.isDepPersistent(dep)) {
            this.dirty = true;
        }
        if (ExmlUtils.isComposition(obj, dep, val) && !val.getClassOf().isCmsNode() && val.getRepositoryObject() == this && (newOwner = val.getCompositionOwner()) != null && (newHandle = newOwner.getRepositoryObject()) != this && newHandle instanceof ExmlStorageHandler) {
            ((ExmlStorageHandler)newHandle).propagateHandler(val);
        }
    }

    public void depValMoved(SmObjectImpl obj, SmDependency dep, SmObjectImpl val) {
        if (ExmlStorageHandler.isDepPersistent(dep)) {
            this.dirty = true;
        }
    }

    public void detach(SmObjectImpl obj) {
        try {
            this.base.removeObject(obj);
            this.dirty = true;
        }
        catch (IOException e) {
            this.base.getErrorSupport().fireError((Throwable)e);
        }
    }

    public final SmObjectImpl getCmsNode() {
        if (this.cmsNode == null) {
            this.cmsNode = this.base.findById(this.cmsNodeId.classof, this.cmsNodeId.id);
            if (this.cmsNode != null) {
                this.cmsNode.setRepositoryObject((IRepositoryObject)this);
            } else {
                String msg = String.format("ExmlStorageHandler.getCmsNode(): %s not found in %s. The node was probably deleted then unloaded", this.cmsNodeId, this.base);
                Log.trace((Throwable)new Throwable(msg));
            }
        }
        return this.cmsNode;
    }

    public final Resource getEmfResource() {
        return this.base.getEmfResource();
    }

    public final byte getRepositoryId() {
        return this.base.getRepositoryId();
    }

    public boolean isAttLoaded(SmObjectImpl obj, SmAttribute att) {
        if (att != null && att.isNameAtt()) {
            return true;
        }
        return this.isLoaded();
    }

    public final boolean isDepLoaded(SmObjectImpl obj, SmDependency dep) {
        if (ExmlStorageHandler.isDepPersistent(dep)) {
            if (obj.equals((Object)this.getCmsNode()) && ExmlStorageHandler.isInverseCompositionDep((MDependency)dep)) {
                return this.parentLoaded;
            }
            return this.loaded;
        }
        if (this.areUsersLoaded(obj)) {
            return true;
        }
        return !ExmlStorageHandler.isInverseDepStored(dep);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public final boolean isLoaded() {
        return this.loaded;
    }

    public final boolean isPersistent(SmDependency dep) {
        return ExmlStorageHandler.isDepPersistent(dep);
    }

    private static final boolean isDepPersistent(SmDependency dep) {
        return dep.isPartOf() || dep.isComponent() || dep.isSharedComposition() || ExmlStorageHandler.isInverseCompositionDep((MDependency)dep);
    }

    public final void loadAtt(SmObjectImpl obj, SmAttribute att) {
        this.load();
    }

    public final void loadDep(SmObjectImpl obj, SmDependency dep) {
        try {
            Throwable throwable = null;
            Object var4_8 = null;
            try (IModelLoader modelLoader = this.base.getModelLoaderProvider().beginLoadSession();){
                if (ExmlStorageHandler.isDepPersistent(dep)) {
                    SmObjectImpl lcmsNode = this.getCmsNode(modelLoader);
                    if (obj.equals((Object)lcmsNode) && ExmlStorageHandler.isInverseCompositionDep((MDependency)dep)) {
                        if (!this.parentLoaded) {
                            for (MDependency ownerDep : obj.getMClass().getDependencies(true)) {
                                if (!ExmlStorageHandler.isInverseCompositionDep(ownerDep)) continue;
                                this.base.loadDynamicDep(obj, (SmDependency)ownerDep);
                            }
                            this.parentLoaded = true;
                        }
                    } else {
                        this.load();
                    }
                } else if (ExmlStorageHandler.isInverseDepStored(dep)) {
                    this.base.loadDynamicDep(obj, dep);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (DuplicateObjectException e) {
            this.base.getErrorSupport().fireError((Throwable)e);
        }
        catch (IllegalReferenceException e) {
            this.base.setIndexesDamaged(e);
            this.base.getErrorSupport().fireError((Throwable)e);
        }
        catch (IndexException e) {
            this.base.getErrorSupport().fireError((Throwable)e);
        }
    }

    public void loadStatus(SmObjectImpl obj) {
        this.load();
    }

    public final void setDirty(boolean value) {
        this.dirty = value;
    }

    public final void setLoaded(boolean value) {
        this.loaded = value;
    }

    public final void unload(SmObjectImpl obj) {
        if (this.cmsNode == obj) {
            this.cmsNode = null;
        }
        this.base.unloadObject(obj);
    }

    private static boolean isInverseDepStored(SmDependency dep) {
        SmDependency sym = dep.getSymetric();
        if (sym == null) {
            return false;
        }
        return ExmlStorageHandler.isDepPersistent(sym);
    }

    protected final void load() {
        if (this.loaded) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_6 = null;
            try (IModelLoader modelLoader = this.base.getModelLoaderProvider().beginLoadSession();){
                this.base.loadCmsNode(this.cmsNodeId, modelLoader, false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (DuplicateObjectException e) {
            this.base.getErrorSupport().fireError((Throwable)new IOException("Failed loading " + String.valueOf(this) + ": " + e.getLocalizedMessage(), e));
        }
        catch (RepositoryClosedException e) {
            this.loaded = true;
            this.cmsNode.setRStatus(256L, 0L, 0L);
            Log.warning((String)"Cannot load %s : %s", (Object[])new Object[]{this, e});
            Log.warning((Throwable)e);
        }
        catch (RuntimeException e) {
            this.base.getErrorSupport().fireError((Throwable)new IOException("Failed loading " + String.valueOf(this) + ": " + e.toString(), e));
        }
    }

    private void propagateHandler(SmObjectImpl obj) {
        assert (!obj.getClassOf().isCmsNode());
        obj.setRepositoryObject((IRepositoryObject)this);
        for (SmObjectImpl child : ExmlUtils.getLoadedCmsNodeContent(obj)) {
            child.setRepositoryObject((IRepositoryObject)this);
        }
    }

    public final boolean isDirty(SmObjectImpl obj) {
        return this.dirty;
    }

    public String toString() {
        if (this.cmsNode != null) {
            return "ExmlStorageHandler {node=" + String.valueOf(this.cmsNode) + ", base=" + this.base.toString() + "}";
        }
        return "ExmlStorageHandler {nodeid=" + String.valueOf(this.cmsNodeId) + ", base=" + this.base.toString() + "}";
    }

    private ObjId getParentCmsNode(SmObjectImpl obj) throws IndexException {
        ObjId objId = new ObjId(obj);
        ICmsNodeIndex cmsNodeIndex = this.base.getCmsNodeIndex();
        try {
            ObjId parent = cmsNodeIndex.getParentNodeOf(objId);
            return parent;
        }
        catch (RuntimeException | IndexException e) {
            this.base.setIndexesDamaged(e);
            cmsNodeIndex = this.base.getCmsNodeIndex();
            try {
                ObjId parent = cmsNodeIndex.getParentNodeOf(objId);
                return parent;
            }
            catch (RuntimeException | IndexException e2) {
                e2.addSuppressed(e);
                throw e2;
            }
        }
    }

    protected IExmlBase getBase() {
        return this.base;
    }

    public void setToReload(SmObjectImpl obj) {
        this.loaded = false;
    }

    protected boolean areUsersLoaded(SmObjectImpl obj) {
        return obj.getData().hasAllStatus(0x80000000000L) == StatusState.TRUE;
    }

    private SmObjectImpl getCmsNode(IModelLoader loader) throws DuplicateObjectException, IndexException, IllegalReferenceException {
        if (this.cmsNode == null) {
            this.cmsNode = this.base.findByObjId(this.cmsNodeId, loader);
            if (this.cmsNode != null) {
                this.cmsNode.setRepositoryObject((IRepositoryObject)this);
            } else {
                Log.trace((String)"ExmlStorageHandler.getCmsNode(IModelLoader) : %s not found in %s.", (Object[])new Object[]{this.cmsNodeId, this.base});
            }
        }
        return this.cmsNode;
    }

    public ObjId getCmsNodeId() {
        return this.cmsNodeId;
    }

    public void setParentLoaded(boolean val) {
        this.parentLoaded = val;
    }
}

