/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.common;

import java.util.Locale;
import java.util.UUID;
import org.modelio.vbasic.log.Log;
import org.modelio.vcore.model.DuplicateObjectException;
import org.modelio.vcore.model.GetAbsoluteSymbol;
import org.modelio.vcore.model.MObjectCache;
import org.modelio.vcore.session.impl.storage.IModelLoader;
import org.modelio.vcore.smkernel.IRepositoryObject;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.SmObjectSmClass;
import org.modelio.vcore.smkernel.StatusState;
import org.modelio.vcore.smkernel.mapi.MClass;
import org.modelio.vcore.smkernel.mapi.MetaclassAlreadyExistException;
import org.modelio.vcore.smkernel.meta.SmAttribute;
import org.modelio.vcore.smkernel.meta.SmClass;
import org.modelio.vcore.smkernel.meta.SmMetamodel;
import org.modelio.vstore.exml.common.ExmlStorageHandler;
import org.modelio.vstore.exml.common.IExmlBase;
import org.modelio.vstore.exml.common.ILoadHelper;
import org.modelio.vstore.exml.common.index.IndexException;
import org.modelio.vstore.exml.common.model.IllegalReferenceException;
import org.modelio.vstore.exml.common.model.ObjId;
import org.modelio.vstore.exml.common.model.ObjIdName;

public class LoadHelper
implements ILoadHelper {
    protected boolean loadReadWrite;
    private final IExmlBase exmlBase;
    private final MObjectCache loadCache;
    private final SmMetamodel metamodel;

    public LoadHelper(IExmlBase exmlBase, boolean loadReadWrite) {
        this.exmlBase = exmlBase;
        this.loadCache = exmlBase.getLoadCache();
        this.loadReadWrite = loadReadWrite;
        this.metamodel = exmlBase.getModelLoaderProvider().getMetamodel();
    }

    @Override
    public ExmlStorageHandler createStorageHandler(SmObjectImpl cmsNode, boolean isNodeLoaded) {
        return this.exmlBase.createStorageHandler(cmsNode, isNodeLoaded);
    }

    @Override
    public SmObjectImpl createStubCmsNode(IModelLoader modelLoader, ObjId id, String defaultName) throws DuplicateObjectException {
        assert (id.classof.isCmsNode()) : String.valueOf(id.classof) + " is not cms node.";
        return this.loadCache.supplyIfAbsent((MClass)id.classof, id.id, () -> {
            SmObjectImpl newObject = modelLoader.createLoadedObject(objId.classof, objId.id);
            this.setObjectName(modelLoader, newObject, this.getNameFromIndex(id, defaultName));
            newObject.setRepositoryObject((IRepositoryObject)this.createStorageHandler(newObject, false));
            return newObject;
        });
    }

    @Override
    public final SmObjectImpl createObject(IModelLoader modelLoader, ObjId id, ExmlStorageHandler handler) throws DuplicateObjectException {
        SmObjectImpl newObject = modelLoader.createLoadedObject(id.classof, id.id);
        this.loadCache.putToCache(newObject);
        if (handler != null) {
            newObject.setRepositoryObject((IRepositoryObject)handler);
        }
        return newObject;
    }

    @Override
    public SmObjectImpl createStubObject(IModelLoader modelLoader, ObjIdName idn, boolean loadNameFromIndex) throws DuplicateObjectException, IllegalReferenceException, IndexException {
        try {
            SmObjectImpl newObject;
            if (idn.classof.isCmsNode()) {
                newObject = this.createStubCmsNode(modelLoader, idn.toObjId(), idn.name);
            } else {
                SmObjectImpl parentNode;
                ObjId parentId = this.exmlBase.getCmsNodeIndex().getCmsNodeOf(idn.toObjId());
                if (parentId == null) {
                    throw new IllegalReferenceException("No CMS node contains " + String.valueOf(idn) + " in the repository.");
                }
                if (!parentId.classof.isCmsNode()) {
                    Log.warning((String)"EXML LoadHelper: The metaclass of %s parent node of %s is not a CMS node", (Object[])new Object[]{parentId, idn});
                }
                if ((parentNode = this.getLoadedObject(parentId)) == null) {
                    parentNode = this.createStubCmsNode(modelLoader, parentId, null);
                    assert (parentNode.getRepositoryObject().getRepositoryId() == this.exmlBase.getRepositoryId());
                }
                SmObjectImpl finalParentNode = parentNode;
                newObject = this.loadCache.supplyIfAbsent((MClass)idn.classof, idn.id, () -> {
                    SmObjectImpl newObj = modelLoader.createLoadedObject(objIdName.classof, objIdName.id);
                    newObj.setRepositoryObject(finalParentNode.getRepositoryObject());
                    String objName = loadNameFromIndex ? this.getNameFromIndex(idn.toObjId(), objIdName.name) : objIdName.name;
                    this.setObjectName(modelLoader, newObj, objName);
                    return newObj;
                });
            }
            assert (newObject.getRepositoryObject().getRepositoryId() == this.exmlBase.getRepositoryId());
            return newObject;
        }
        catch (IndexException e) {
            this.exmlBase.setIndexesDamaged(e);
            throw e;
        }
    }

    @Override
    public final void doLoadAtt(IModelLoader modelLoader, SmObjectImpl obj, String xattName, String attValue) {
        SmAttribute att = obj.getClassOf().getAttributeDef(xattName);
        if (att != null) {
            Class attType = att.getType();
            if (attValue != null && attType != UUID.class) {
                if (attType == String.class) {
                    modelLoader.loadAttribute(obj, att, (Object)attValue);
                } else if (!attValue.isEmpty()) {
                    if (attType == Integer.class) {
                        modelLoader.loadAttribute(obj, att, (Object)Integer.valueOf(attValue));
                    } else if (attType == Long.class) {
                        modelLoader.loadAttribute(obj, att, (Object)Long.valueOf(attValue));
                    } else if (attType == Float.class) {
                        modelLoader.loadAttribute(obj, att, (Object)Float.valueOf(attValue));
                    } else if (attType == Double.class) {
                        modelLoader.loadAttribute(obj, att, (Object)Double.valueOf(attValue));
                    } else if (attType == Boolean.class) {
                        modelLoader.loadAttribute(obj, att, (Object)Boolean.valueOf(attValue));
                    } else if (attType.isEnum()) {
                        if (attValue.isEmpty()) {
                            LoadHelper.reportProblem(obj, "Empty value for " + attType.getSimpleName() + " " + att.getName() + " attribute.");
                        } else {
                            try {
                                modelLoader.loadAttribute(obj, att, LoadHelper.getEnumValue(attValue, attType));
                            }
                            catch (IllegalArgumentException ex) {
                                LoadHelper.reportProblem(obj, "Illegal value for " + attType.getSimpleName() + " " + att.getName() + " attribute:" + ex.getLocalizedMessage());
                            }
                        }
                    } else {
                        LoadHelper.reportProblem(obj, "Unknown type:" + attType.getSimpleName() + " for " + att.getName() + " attribute.");
                    }
                }
            }
        }
    }

    @Override
    public ObjId getCmsNodeId(ObjId id) throws IndexException {
        return this.exmlBase.getCmsNodeIndex().getCmsNodeOf(id);
    }

    @Override
    public SmObjectImpl getForeignObject(IModelLoader modelLoader, ObjIdName id) {
        return modelLoader.loadForeignObject(id.classof, id.id, id.name);
    }

    @Override
    public final SmObjectImpl getLoadedObject(ObjId id) {
        if (id.id == null) {
            return null;
        }
        SmObjectImpl ret = this.loadCache.findById((MClass)id.classof, id.id);
        if (ret == null) {
            return null;
        }
        SmObjectSmClass retClassOf = ret.getClassOf();
        if (retClassOf == id.classof || retClassOf.hasBase((MClass)id.classof)) {
            return ret;
        }
        Log.error((String)String.format("LoadHelper.getObject(%s): \"%s\" found is a '%s' and not a '%s' !", id.toString(), GetAbsoluteSymbol.get((SmObjectImpl)ret), retClassOf.getName(), id.classof.getName()));
        return null;
    }

    @Override
    public final SmObjectImpl getRefObject(IModelLoader modelLoader, ObjIdName id) throws DuplicateObjectException, IllegalReferenceException, IndexException {
        return this.getForeignObject(modelLoader, id);
    }

    @Override
    public SmClass getSmClass(String xclassof) {
        SmClass mClass = this.metamodel.getMClass(xclassof);
        if (mClass == null) {
            try {
                mClass = this.metamodel.fakeClassBuilder().setQualifiedName(xclassof).setCmsNode(false).build();
            }
            catch (MetaclassAlreadyExistException ex) {
                return (SmClass)ex.getExistingMetaclass();
            }
        }
        return mClass;
    }

    @Override
    public void initObjectFlags(IModelLoader modelLoader, SmObjectImpl obj) {
        long falseFlags = 256L;
        if (!this.loadReadWrite) {
            falseFlags |= 4L;
        }
        modelLoader.setRStatus(obj, 0L, falseFlags, 0L);
    }

    @Override
    public boolean isStored(ObjId id) {
        return this.exmlBase.isStored(id);
    }

    @Override
    public void loadFailed(SmObjectImpl obj, IModelLoader modelLoader, Exception e) {
        if (obj.getData().hasAllStatus(256L) != StatusState.TRUE) {
            modelLoader.setRStatus(obj, 256L, 0L, 0L);
            modelLoader.setRStatus(obj, 256L, 0L, 0L);
            if (e != null) {
                this.exmlBase.getErrorSupport().fireWarning((Throwable)e);
            }
        }
    }

    private static Enum<?> getEnumValue(String attValue, Class<?> attType) {
        return Enum.valueOf(attType, attValue.toUpperCase(Locale.ROOT));
    }

    private static void reportProblem(SmObjectImpl obj, String msg) {
    }

    private void setObjectName(IModelLoader modelLoader, SmObjectImpl newObject, String name) {
        if (name == null) {
            return;
        }
        SmObjectSmClass cls = newObject.getClassOf();
        SmAttribute nameAtt = cls.getAttributeDef("Name");
        if (nameAtt == null) {
            nameAtt = cls.getAttributeDef("name");
        }
        if (nameAtt != null) {
            modelLoader.loadAttribute(newObject, nameAtt, (Object)name);
        }
    }

    @Override
    public ObjIdName withNameFromIndex(ObjId id) {
        try {
            return new ObjIdName(id.classof, this.exmlBase.getCmsNodeIndex().getName(id), id.id);
        }
        catch (IndexException e) {
            this.exmlBase.setIndexesDamaged(e);
            return new ObjIdName(id.classof, "", id.id);
        }
    }

    protected String getNameFromIndex(ObjId id, String defaultName) {
        try {
            return this.exmlBase.getCmsNodeIndex().getName(id);
        }
        catch (IndexException e) {
            this.exmlBase.setIndexesDamaged(e);
            return defaultName;
        }
    }
}

