/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.common;

import java.io.IOException;
import java.text.MessageFormat;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.smkernel.mapi.MMetamodel;
import org.modelio.vstore.exml.common.AbstractExmlRepository;
import org.modelio.vstore.exml.common.IMaintenanceOperations;
import org.modelio.vstore.exml.common.index.CannotOpenIndexException;
import org.modelio.vstore.exml.common.index.ExmlIndex;
import org.modelio.vstore.exml.common.index.IndexException;

public class MaintenanceOperations
implements IMaintenanceOperations {
    protected final AbstractExmlRepository repo;

    public MaintenanceOperations(AbstractExmlRepository repo) {
        this.repo = repo;
    }

    @Override
    public void rebuildIndexes(IModelioProgress monitor) throws IOException {
        try {
            SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)200);
            ExmlIndex indexes = this.repo.getIndexes((IModelioProgress)mon.newChild(20));
            mon.subTask(MessageFormat.format("Deleting {0} indexes ...", this.repo.getResourceProvider().getName()));
            indexes.deleteIndexes();
            mon.subTask(MessageFormat.format("Rebuilding {0} indexes ...", this.repo.getResourceProvider().getName()));
            indexes.open((IModelioProgress)mon.newChild(30), this.repo.getModelLoaderProvider().getMetamodel());
            indexes.buildIndexes((IModelioProgress)mon.newChild(150));
        }
        catch (CannotOpenIndexException | IndexException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void compressIndexes(IModelioProgress monitor) throws IOException {
        try {
            SubProgress mon = SubProgress.convert((IModelioProgress)monitor, (int)200);
            ExmlIndex indexes = this.repo.getIndexes((IModelioProgress)mon.newChild(20));
            mon.subTask(MessageFormat.format("Compressing {0} indexes ...", this.repo.getResourceProvider().getName()));
            indexes.compress((IModelioProgress)mon.newChild(180));
        }
        catch (CannotOpenIndexException | IndexException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void deleteIndexes(IModelioProgress monitor) throws IOException {
        try {
            ExmlIndex indexes = this.repo.getIndexes(monitor);
            monitor.subTask("Deleting " + this.repo.getResourceProvider().getName() + " indexes ...");
            indexes.deleteIndexes();
        }
        catch (CannotOpenIndexException | IndexException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void writeFormatVersion() throws IOException {
        this.repo.saveRepositoryVersion((MMetamodel)this.repo.getModelLoaderProvider().getMetamodel());
    }

    @Override
    public void writeMetamodelDescriptor() throws IOException {
        this.repo.saveMetamodelDescriptor();
    }
}

