/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.modelio.vcore.smkernel.mapi.MClass;
import org.modelio.vcore.smkernel.mapi.MMetamodel;

public class RepositoryVersions {
    public static final int CURRENT_FORMAT = 3;
    public static final int LATEST_STABLE_FORMAT = 3;
    private static final String PROP_CMSNODES = "cmsnodes";
    private static final String PROP_REPOSITORY_FORMAT = "repository_format";
    private final List<String> cmsNodesSig;
    private final int repositoryFormat;

    public static RepositoryVersions fromStream(InputStream is) throws IOException {
        Properties props = new Properties();
        props.load(is);
        int repositoryFormat = Integer.parseInt((String)props.get(PROP_REPOSITORY_FORMAT));
        String cmsnodes_str = (String)props.get(PROP_CMSNODES);
        List<String> lcmsNodesSig = Arrays.asList(cmsnodes_str.split(","));
        return new RepositoryVersions(repositoryFormat, lcmsNodesSig);
    }

    public RepositoryVersions(int format, List<String> cmsNodesSig) {
        this.repositoryFormat = format;
        this.cmsNodesSig = new ArrayList<String>(cmsNodesSig);
    }

    public RepositoryVersions(MMetamodel mm) {
        this(3, mm);
    }

    public RepositoryVersions(int format, MMetamodel mm) {
        Collection registeredClasses = mm.getRegisteredMClasses();
        this.cmsNodesSig = new ArrayList<String>();
        if (format < 2) {
            for (MClass c : registeredClasses) {
                if (!c.isCmsNode()) continue;
                this.cmsNodesSig.add(c.getName());
            }
        } else {
            for (MClass c : registeredClasses) {
                if (!c.isCmsNode() || c.isAbstract()) continue;
                this.cmsNodesSig.add(c.getQualifiedName());
            }
        }
        Collections.sort(this.cmsNodesSig);
        this.repositoryFormat = format;
    }

    public void checkCompatible(MMetamodel mm) throws IncompatibleVersionException {
        this.checkCompatible(new RepositoryVersions(mm));
    }

    public Collection<String> getCmsNodeMetaclasses() {
        return this.cmsNodesSig;
    }

    public int getRepositoryFormat() {
        return this.repositoryFormat;
    }

    protected void write(Map<Object, Object> properties) {
        StringBuilder s = new StringBuilder(this.cmsNodesSig.size() * 10);
        for (String c : this.cmsNodesSig) {
            s.append(c);
            s.append(',');
        }
        properties.put(PROP_CMSNODES, s.toString());
        properties.put(PROP_REPOSITORY_FORMAT, String.valueOf(this.repositoryFormat));
    }

    public void write(OutputStream out) throws IOException {
        Properties props = new Properties();
        this.write(props);
        props.store(out, "Repository format version, DO NOT EDIT.");
    }

    private void checkCompatible(RepositoryVersions reference) throws IncompatibleVersionException {
        if (this.repositoryFormat == reference.repositoryFormat) {
            return;
        }
        if (!(reference.getRepositoryFormat() == 2 && this.repositoryFormat < 2 || reference.getRepositoryFormat() == 3 && this.repositoryFormat >= 1)) {
            throw new IncompatibleVersionException("Repository format " + this.repositoryFormat + " is incompatible with " + reference.repositoryFormat + " version.");
        }
    }

    public String toString() {
        int f = this.getRepositoryFormat();
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(f);
        if (f == 3) {
            builder.append(" (latest)");
        } else if (f == 3) {
            builder.append(" (latest stable)");
        }
        builder.append("]");
        return builder.toString();
    }

    public static class IncompatibleVersionException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public IncompatibleVersionException(String message) {
            super(message);
        }
    }
}

