/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.common.index;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vbasic.progress.SubProgress;
import org.modelio.vcore.session.api.repository.StorageErrorSupport;
import org.modelio.vcore.smkernel.meta.SmMetamodel;
import org.modelio.vstore.exml.common.index.ICmsNodeIndex;
import org.modelio.vstore.exml.common.index.IIndexDb;
import org.modelio.vstore.exml.common.index.IUserNodeIndex;
import org.modelio.vstore.exml.common.index.IndexException;
import org.modelio.vstore.exml.common.index.IndexOutdatedException;
import org.modelio.vstore.exml.common.index.builder.IndexBuilder;
import org.modelio.vstore.exml.common.index.builder.InvalidExmlException;
import org.modelio.vstore.exml.common.model.ObjId;
import org.modelio.vstore.exml.plugin.VStoreExml;
import org.modelio.vstore.exml.resource.IExmlResourceProvider;
import org.xml.sax.InputSource;

public class ExmlIndex {
    private static final int COMMIT_FREQ = 100;
    private int commitCounter;
    private IIndexDb db;
    private ICmsNodeIndex cmsNodeIndex;
    private IUserNodeIndex userNodeIndex;
    private final IExmlResourceProvider resProvider;
    private IndexBuilder builder;
    private final StorageErrorSupport errSupport;
    private final Supplier<IIndexDb> indexDbFactory;

    public ExmlIndex(IExmlResourceProvider resProvider, Supplier<IIndexDb> indexDbFactory, StorageErrorSupport errSupport) {
        this.resProvider = resProvider;
        this.errSupport = errSupport;
        this.indexDbFactory = indexDbFactory;
    }

    public void buildIndexes(IModelioProgress aMonitor) throws IOException, IndexException {
        if (!this.db.isWritable()) {
            return;
        }
        SubProgress monitor = SubProgress.convert((IModelioProgress)aMonitor, (String)"Building indexes", (int)320);
        boolean problemsFound = false;
        Collection<IExmlResourceProvider.ExmlResource> allResources = this.resProvider.getAllResources((IModelioProgress)monitor.newChild(100));
        int nbResources = allResources.size();
        monitor.setWorkRemaining(nbResources);
        int i = 0;
        for (IExmlResourceProvider.ExmlResource f : allResources) {
            try {
                Throwable throwable = null;
                Object var10_12 = null;
                try (InputStream is = f.bufferedRead();){
                    InputSource src = new InputSource(is);
                    src.setPublicId(f.getPublicLocation());
                    this.builder.run(src);
                    this.commitSometimes();
                    if (++i % 10 == 0) {
                        monitor.subTask(VStoreExml.I18N.getMessage("AbstractExmlRepository.mon.buildingIndexes.i", new Object[]{this.resProvider.getName(), i, nbResources}));
                    }
                    monitor.worked(1);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (InvalidExmlException e) {
                problemsFound = true;
                this.errSupport.fireWarning((Throwable)e);
            }
        }
        if (!problemsFound) {
            this.db.setStoredVersion();
            this.commitDb();
        }
        this.commitDb();
        monitor.done();
    }

    public void close() throws IndexException {
        if (this.db != null) {
            this.db.close();
            this.db = null;
            this.cmsNodeIndex = null;
            this.userNodeIndex = null;
            this.builder = null;
        }
    }

    public void checkUptodate() throws IOException, IndexOutdatedException, IndexException {
        this.db.checkIndexFormat();
        if (this.cmsNodeIndex.isEmpty()) {
            throw new IndexOutdatedException(VStoreExml.I18N.getMessage("ExmlIndex.indexMissing", new Object[]{this.resProvider.getName()}));
        }
        String stamp = this.resProvider.getStamp();
        if (!this.getStoredStamp().equals(stamp)) {
            throw new IndexOutdatedException(VStoreExml.I18N.getMessage("ExmlIndex.indexNotSynchro", new Object[]{this.resProvider.getName(), this.getStoredStamp(), stamp}));
        }
    }

    public void commitDb() throws IndexException {
        this.setStamp();
        this.db.commit();
        this.commitCounter = 0;
    }

    public void deleteIndexes() throws IndexException {
        if (this.db != null) {
            this.db.deleteIndexes();
        } else {
            this.open(null, null);
            this.db.deleteIndexes();
        }
        this.close();
    }

    public CloseOnFail getCloseOnFail() {
        return new CloseOnFail(this);
    }

    public ICmsNodeIndex getCmsNodeIndex() {
        return this.cmsNodeIndex;
    }

    public IUserNodeIndex getUserNodeIndex() {
        return this.userNodeIndex;
    }

    public void open(IModelioProgress aMonitor, SmMetamodel metamodel) throws IndexException {
        if (this.db != null) {
            throw new IllegalStateException("Indexes are already open.");
        }
        try {
            this.resProvider.buildIndexes(aMonitor);
            this.db = Objects.requireNonNull(this.indexDbFactory.get());
            Throwable throwable = null;
            Object var4_6 = null;
            try (CloseOnFail shield = new CloseOnFail(this);){
                this.db.open(aMonitor, this.resProvider, metamodel);
                this.cmsNodeIndex = this.db.getCmsNodeIndex();
                this.userNodeIndex = this.db.getUserNodeIndex();
                this.builder = new IndexBuilder(metamodel, this.getCmsNodeIndex(), this.getUserNodeIndex());
                shield.success();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw ExmlIndex.convert(e);
        }
    }

    public void removeFromIndexes(ObjId id) throws IndexException {
        if (this.db.isWritable()) {
            for (ObjId childId : this.getCmsNodeIndex().getCmsNodeContent(id)) {
                this.getUserNodeIndex().remove(childId);
            }
            this.getCmsNodeIndex().removeObj(id);
            this.getUserNodeIndex().remove(id);
            this.commitSometimes();
        }
    }

    public void updateIndexes(ObjId cmsNodeId) throws IndexException {
        try {
            this.removeFromIndexes(cmsNodeId);
            IExmlResourceProvider.ExmlResource resource = this.resProvider.getResource(cmsNodeId);
            try {
                Throwable throwable = null;
                Object var4_7 = null;
                try (InputStream is = resource.bufferedRead();){
                    if (is != null) {
                        InputSource src = new InputSource(is);
                        src.setPublicId(resource.getPublicLocation());
                        this.builder.run(src);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (InvalidExmlException e) {
                this.errSupport.fireWarning((Throwable)e);
            }
            this.commitSometimes();
        }
        catch (IOException e) {
            throw ExmlIndex.convert(e);
        }
    }

    private void commitSometimes() throws IndexException {
        if (!this.db.isWritable()) {
            return;
        }
        ++this.commitCounter;
        if (this.commitCounter >= 100) {
            this.db.commit();
            this.commitCounter = 0;
        }
    }

    private void setStamp() throws IndexException {
        if (!this.db.isWritable()) {
            return;
        }
        try {
            String stamp = this.resProvider.getStamp();
            this.db.setStamp(stamp);
        }
        catch (IOException e) {
            throw ExmlIndex.convert(e);
        }
    }

    private String getStoredStamp() throws IndexException {
        return this.db.getStoredStamp();
    }

    public void compress(IModelioProgress monitor) throws IndexException {
        if (!this.db.isWritable()) {
            return;
        }
        this.db.compress(monitor);
    }

    private static IndexException convert(IOException e) {
        return new IndexException(FileUtils.getLocalizedMessage((IOException)e), e);
    }

    public static class CloseOnFail
    implements AutoCloseable {
        private ExmlIndex resource;

        public CloseOnFail(ExmlIndex resource) {
            this.resource = resource;
        }

        public void success() {
            this.resource = null;
        }

        @Override
        public void close() throws IndexException {
            if (this.resource != null) {
                this.resource.close();
                this.resource = null;
            }
        }
    }
}

