/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.common.index.builder;

import java.io.IOError;
import java.util.ArrayDeque;
import java.util.Deque;
import org.modelio.vbasic.log.Log;
import org.modelio.vcore.smkernel.meta.SmMetamodel;
import org.modelio.vstore.exml.common.index.ICmsNodeIndex;
import org.modelio.vstore.exml.common.index.IUserNodeIndex;
import org.modelio.vstore.exml.common.index.IndexException;
import org.modelio.vstore.exml.common.index.builder.AbstractState;
import org.modelio.vstore.exml.common.index.builder.DocumentState;
import org.modelio.vstore.exml.common.index.builder.EXTIDState;
import org.modelio.vstore.exml.common.index.builder.LINKState;
import org.modelio.vstore.exml.common.index.builder.OBJECTState;
import org.modelio.vstore.exml.common.index.builder.REFOBJState;
import org.modelio.vstore.exml.common.model.ObjId;
import org.modelio.vstore.exml.common.model.ObjIdName;
import org.modelio.vstore.exml.common.utils.ObjIdReader;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class DocumentContentHandler
extends DefaultHandler {
    private boolean errorEncountered;
    private boolean parentSet;
    private AbstractState currentState;
    private final ICmsNodeIndex cmsNodeIndex;
    private final IUserNodeIndex userNodeIndex;
    private final OBJECTState objectState;
    private final EXTIDState extIdState;
    private final REFOBJState refObjState;
    private final DocumentState documentState;
    private ObjId cmsNodeId;
    private Locator locator;
    private final LINKState linkState;
    private final ObjIdReader idReader;
    private final Deque<Data> dataStack = new ArrayDeque<Data>();

    public DocumentContentHandler(SmMetamodel metamodel, ICmsNodeIndex parentIndex, IUserNodeIndex userIndex) {
        this.cmsNodeIndex = parentIndex;
        this.userNodeIndex = userIndex;
        this.extIdState = new EXTIDState();
        this.objectState = new OBJECTState();
        this.refObjState = new REFOBJState();
        this.linkState = new LINKState();
        this.documentState = new DocumentState();
        this.documentState.setStateHandler(this);
        this.extIdState.setStateHandler(this);
        this.objectState.setStateHandler(this);
        this.refObjState.setStateHandler(this);
        this.linkState.setStateHandler(this);
        this.currentState = this.documentState;
        this.errorEncountered = false;
        this.idReader = new ObjIdReader(metamodel, () -> "Index builder: ", () -> ": line " + this.getLocator().getLineNumber() + " in " + this.getLocator().getPublicId());
    }

    public void addContainedObject(String className, String uid, String name, boolean isCmsNode) throws IndexException {
        ObjIdName childIdName = this.idReader.readObjIdName(className, uid, name, isCmsNode);
        ObjId childId = childIdName.toObjId();
        if (this.cmsNodeId == null) {
            assert (isCmsNode);
            this.cmsNodeId = childId;
        }
        this.cmsNodeIndex.addObject(this.cmsNodeId, childIdName);
        this.pushObject(childId);
    }

    public void addDependencyTarget(String className, String uid, String name) throws IndexException {
        ObjId usedId = this.idReader.readObjId(className, uid, false);
        if (!this.cmsNodeId.equals(this.cmsNodeIndex.getCmsNodeOf(usedId))) {
            Data data = this.getDataStack().element();
            this.userNodeIndex.addUsed(data.id, data.curDepName, usedId);
        }
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        this.currentState.characters(chars, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.currentState.endElement(uri, localName, qName);
    }

    public void enterDocumentState() {
        this.currentState = this.documentState;
    }

    @Deprecated
    public void enterEXTIDState(Attributes attributes) throws SAXException {
        this.currentState = this.extIdState;
        this.extIdState.enterState(attributes);
    }

    public void enterOBJECTState() {
        this.currentState = this.objectState;
    }

    public void enterREFOBJState() {
        this.currentState = this.refObjState;
    }

    @Override
    public void error(SAXParseException exc) throws SAXException {
        throw exc;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public boolean hasEncounteredError() {
        return this.errorEncountered;
    }

    public void setCmsNode(String className, String uid, String name) throws IndexException {
        ObjIdName objIdName = this.idReader.readObjIdName(className, uid, name, true);
        this.cmsNodeId = objIdName.toObjId();
        this.cmsNodeIndex.addCmsNode(objIdName);
    }

    @Override
    public void setDocumentLocator(Locator aLocator) {
        this.locator = aLocator;
    }

    public void setErrorEncountered() {
        this.errorEncountered = true;
    }

    public void setParent(String className, String uid, String name) throws IndexException {
        if (!this.parentSet) {
            this.parentSet = true;
            ObjId parentId = this.idReader.readObjId(className, uid, true);
            this.cmsNodeIndex.setParent(this.cmsNodeId, parentId);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            this.currentState.startElement(uri, localName, qName, atts);
        }
        catch (IOError err) {
            this.throwError((Exception)err.getCause());
        }
    }

    void throwError(Exception e) throws SAXParseException {
        String msg = e.getLocalizedMessage();
        if (msg == null || msg.isEmpty()) {
            msg = e.toString();
        }
        throw new SAXParseException(msg, this.getLocator(), e);
    }

    @Override
    public void warning(SAXParseException exc) {
        Log.warning((Throwable)exc);
    }

    public void resetModel() {
        this.cmsNodeId = null;
        this.errorEncountered = false;
        this.parentSet = false;
    }

    public void enterLINKState(String depName) {
        this.currentState = this.linkState;
        if (depName != null) {
            this.getDataStack().element().curDepName = depName;
        }
    }

    public ObjId getCmsNode() {
        return this.cmsNodeId;
    }

    private Deque<Data> getDataStack() {
        return this.dataStack;
    }

    public void pushObject(ObjId id) {
        this.dataStack.push(new Data(id));
    }

    public void popData() {
        this.dataStack.pop();
    }

    public ObjId readId(String className, String uid, String name, boolean isCmsNode) throws IndexException {
        return this.idReader.readObjId(className, uid, isCmsNode);
    }

    private static class Data {
        String curDepName;
        final ObjId id;

        public Data(ObjId id) {
            this.id = id;
        }
    }
}

