/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.common.index.builder;

import java.io.IOError;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.modelio.vcore.smkernel.meta.SmMetamodel;
import org.modelio.vstore.exml.common.index.ICmsNodeIndex;
import org.modelio.vstore.exml.common.index.IUserNodeIndex;
import org.modelio.vstore.exml.common.index.builder.DocumentContentHandler;
import org.modelio.vstore.exml.common.index.builder.InvalidExmlException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class IndexBuilder {
    private final DocumentContentHandler defaultHandler;
    private XMLReader xmlReader;

    public IndexBuilder(SmMetamodel metamodel, ICmsNodeIndex parentIndex, IUserNodeIndex userIndex) {
        this.defaultHandler = new DocumentContentHandler(metamodel, parentIndex, userIndex);
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            SAXParser parser = saxFactory.newSAXParser();
            this.xmlReader = parser.getXMLReader();
            this.xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
            this.xmlReader.setContentHandler(this.defaultHandler);
            this.xmlReader.setErrorHandler(this.defaultHandler);
        }
        catch (ParserConfigurationException e) {
            throw new Error(e);
        }
        catch (SAXException e) {
            throw new Error(e);
        }
    }

    public void run(InputSource is) throws IOException, InvalidExmlException {
        this.defaultHandler.resetModel();
        this.defaultHandler.enterDocumentState();
        try {
            this.xmlReader.parse(is);
        }
        catch (SAXParseException toCatch) {
            String msg = toCatch.getPublicId() + ":" + toCatch.getLineNumber() + ":" + toCatch.getColumnNumber() + ": " + toCatch.getLocalizedMessage();
            if (toCatch.getCause() instanceof IOException) {
                throw new IOException(msg, toCatch);
            }
            throw new InvalidExmlException(msg, toCatch);
        }
        catch (SAXException e) {
            String msg = is.getPublicId() + ": " + e.getLocalizedMessage();
            if (e.getCause() instanceof IOException) {
                throw new IOException(msg, e);
            }
            throw new InvalidExmlException(msg, e);
        }
        catch (IOException e) {
            String msg = is.getPublicId() + ": " + e.getLocalizedMessage();
            throw new InvalidExmlException(msg, e);
        }
        catch (IOError toCatch) {
            String msg = String.valueOf(this.defaultHandler.getLocator()) + ": " + toCatch.getLocalizedMessage();
            throw new IOException(msg, toCatch);
        }
    }
}

