/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.common.index.hsqldb;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Stream;
import org.modelio.vbasic.files.StreamException;
import org.modelio.vbasic.log.IBasicLogger;
import org.modelio.vbasic.log.Log;
import org.modelio.vcore.smkernel.meta.SmClass;
import org.modelio.vcore.smkernel.meta.SmMetamodel;
import org.modelio.vstore.exml.common.index.ICmsNodeIndex;
import org.modelio.vstore.exml.common.index.IndexException;
import org.modelio.vstore.exml.common.index.hsqldb.SqlOperationRunner;
import org.modelio.vstore.exml.common.model.IndexElement;
import org.modelio.vstore.exml.common.model.ObjId;
import org.modelio.vstore.exml.common.model.ObjIdName;

public class HSqlCmsNodeIndex
implements ICmsNodeIndex {
    private static final String SQL_GET_CMSNODE_CONTENT = "SELECT id, clsname, name FROM \"elements\" WHERE cmsnodeid=? AND cmsnodecls=?";
    private static final String SQL_GET_BY_MCLASS = "SELECT clsname, id, name from \"elements\" where clsname=?";
    private static final String SQL_SET_PARENT_OF_CMS_NODE = "MERGE INTO \"cmsnode\" as cmsnode USING (VALUES(?, ?, ?, ?))    AS vals(id, clsname, parentid, parentcls) ON cmsnode.id = vals.id    WHEN MATCHED THEN UPDATE SET cmsnode.clsname = vals.clsname, cmsnode.parentid = vals.parentid, cmsnode.parentcls = vals.parentcls    WHEN NOT MATCHED THEN INSERT VALUES vals.id, vals.clsname, vals.parentid, vals.parentcls";
    private static final String SQL_DELETE_CMS_CHILDREN_OF = "DELETE FROM \"cmsnode\" WHERE parentid=?";
    private static final String SQL_DELETE_OBJ_1 = "DELETE FROM \"elements\" WHERE id=? OR cmsnodeid=?";
    private static final String SQL_GET_CMS_NODE_PARENT = "SELECT p.parentid, e.clsname, e.name FROM \"cmsnode\" p, \"elements\" as e WHERE p.id=? and p.clsname=? and p.parentid = e.id";
    private static final String SQL_GET_ELEMENT_NAME = "SELECT name FROM \"elements\" WHERE id = ? and clsname=?";
    private static final String SQL_GET_CMSNODE = "SELECT c.cmsnodeid, c.cmsnodecls FROM \"elements\" as c WHERE c.id=? and c.clsname=?";
    private static final String SQL_GET_BY_NAME = "SELECT c.id, c.cmsnodeid, c.cmsnodecls FROM \"elements\" as c WHERE c.name=? and c.clsname=?";
    private static final String SQL_FIND_BY_ID = "SELECT c.clsname, c.name, c.cmsnodeid, c.cmsnodecls FROM \"elements\" as c WHERE c.id=? ";
    private static final String SQL_ADD_OBJECT = "MERGE INTO \"elements\" as elements USING (VALUES(?, ?, ?, ?, ?))    AS vals(id, clsname, name, cmsnodeid, cmsnodecls) ON elements.id = vals.id    WHEN MATCHED THEN UPDATE SET elements.name = vals.name, elements.clsname = vals.clsname, elements.cmsnodeid = vals.cmsnodeid, elements.cmsnodecls = vals.cmsnodecls    WHEN NOT MATCHED THEN INSERT VALUES vals.id, vals.clsname, vals.name, vals.cmsnodeid, vals.cmsnodecls";
    private static final String SQL_GET_BY_MC = "SELECT id from \"elements\" where clsname=?";
    private final IBasicLogger log;
    private final SqlOperationRunner sqlRunner;
    private final SmMetamodel metamodel;

    public HSqlCmsNodeIndex(SqlOperationRunner sqlRunner, String projectName, SmMetamodel metamodel) {
        this.sqlRunner = sqlRunner;
        this.metamodel = metamodel;
        this.log = Log.getLogger();
    }

    @Override
    public void addCmsNode(ObjIdName id) throws IndexException {
        this.addObject(new ObjId(id.classof, id.id), id);
    }

    @Override
    public void addObject(ObjId cmsNodeId, ObjIdName objectId) throws IndexException {
        this.sqlRunner.withPreparedIndexStatement(SQL_ADD_OBJECT, insertObjectSt -> {
            int i = 1;
            String lname = objIdName.name;
            if (lname.length() > 1023) {
                lname = lname.substring(0, 1023);
            }
            insertObjectSt.setString(i++, objIdName.id);
            insertObjectSt.setString(i++, objIdName.classof.getQualifiedName());
            insertObjectSt.setString(i++, lname);
            insertObjectSt.setString(i++, objId.id);
            insertObjectSt.setString(i++, objId.classof.getQualifiedName());
            insertObjectSt.execute();
            return null;
        });
    }

    @Override
    public Collection<String> getByMClass(SmClass cls) throws IndexException {
        return this.sqlRunner.withPreparedIndexStatement(SQL_GET_BY_MC, req_getByMClass -> {
            req_getByMClass.setString(1, cls.getQualifiedName());
            Throwable throwable = null;
            Object var3_4 = null;
            try (ResultSet res = req_getByMClass.executeQuery();){
                ArrayList<String> ret = new ArrayList<String>();
                while (res.next()) {
                    ret.add(res.getString(1));
                }
                return ret;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
    }

    @Override
    public ObjId getCmsNodeOf(ObjId id) throws IndexException {
        return this.sqlRunner.withPreparedIndexStatement(SQL_GET_CMSNODE, req_getCmsNodeOf -> {
            ResultSet res;
            block10: {
                ObjId objId2;
                block11: {
                    req_getCmsNodeOf.setString(1, objId.id);
                    req_getCmsNodeOf.setString(2, objId.classof.getQualifiedName());
                    Throwable throwable = null;
                    Object var4_5 = null;
                    res = req_getCmsNodeOf.executeQuery();
                    try {
                        if (!res.next()) break block10;
                        String parentId = res.getString(1);
                        String parentCls = res.getString(2);
                        objId2 = new ObjId(this.metamodel.getMClass(parentCls), parentId);
                        if (res == null) break block11;
                    }
                    catch (Throwable throwable2) {
                        try {
                            if (res != null) {
                                res.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    res.close();
                }
                return objId2;
            }
            if (res != null) {
                res.close();
            }
            return null;
        });
    }

    @Override
    public IndexElement findById(String uuid) throws IndexException {
        return this.sqlRunner.withPreparedIndexStatement(SQL_FIND_BY_ID, req_getCmsNodeOf -> {
            ResultSet res;
            block10: {
                IndexElement indexElement;
                block11: {
                    req_getCmsNodeOf.setString(1, uuid);
                    Throwable throwable = null;
                    Object var4_5 = null;
                    res = req_getCmsNodeOf.executeQuery();
                    try {
                        if (!res.next()) break block10;
                        int i = 1;
                        String elCls = res.getString(i++);
                        String elName = res.getString(i++);
                        String parentId = res.getString(i++);
                        String parentCls = res.getString(i++);
                        ObjId cmsNode = new ObjId(this.metamodel.getMClass(parentCls), parentId);
                        ObjIdName elId = new ObjIdName(this.metamodel.getMClass(elCls), elName, uuid);
                        indexElement = new IndexElement(elId, cmsNode);
                        if (res == null) break block11;
                    }
                    catch (Throwable throwable2) {
                        try {
                            if (res != null) {
                                res.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    res.close();
                }
                return indexElement;
            }
            if (res != null) {
                res.close();
            }
            return null;
        });
    }

    @Override
    public String getName(ObjId id) throws IndexException {
        return this.sqlRunner.withPreparedIndexStatement(SQL_GET_ELEMENT_NAME, req_getName -> {
            ResultSet res;
            block10: {
                String string;
                block11: {
                    req_getName.setString(1, objId.id);
                    req_getName.setString(2, objId.classof.getQualifiedName());
                    Throwable throwable = null;
                    Object var3_4 = null;
                    res = req_getName.executeQuery();
                    try {
                        if (!res.next()) break block10;
                        string = res.getString(1);
                        if (res == null) break block11;
                    }
                    catch (Throwable throwable2) {
                        try {
                            if (res != null) {
                                res.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    res.close();
                }
                return string;
            }
            if (res != null) {
                res.close();
            }
            return null;
        });
    }

    @Override
    public ObjId getParentNodeOf(ObjId id) throws IndexException {
        return this.sqlRunner.withPreparedIndexStatement(SQL_GET_CMS_NODE_PARENT, req_getParentNodeOf -> {
            ResultSet res;
            block10: {
                ObjId objId2;
                block11: {
                    req_getParentNodeOf.setString(1, objId.id);
                    req_getParentNodeOf.setString(2, objId.classof.getQualifiedName());
                    Throwable throwable = null;
                    Object var4_5 = null;
                    res = req_getParentNodeOf.executeQuery();
                    try {
                        if (!res.next()) break block10;
                        String parentId = res.getString(1);
                        String parentCls = res.getString(2);
                        objId2 = new ObjId(this.metamodel.getMClass(parentCls), parentId);
                        if (res == null) break block11;
                    }
                    catch (Throwable throwable2) {
                        try {
                            if (res != null) {
                                res.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    res.close();
                }
                return objId2;
            }
            if (res != null) {
                res.close();
            }
            return null;
        });
    }

    @Override
    public boolean isEmpty() {
        try {
            return this.sqlRunner.withPreparedIndexStatement("SELECT COUNT(*) FROM \"elements\"", st -> {
                Throwable throwable = null;
                Object var2_3 = null;
                try (ResultSet res = st.executeQuery();){
                    if (res.next()) {
                        return res.getInt(1) <= 0;
                    }
                    return false;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            });
        }
        catch (IndexException e) {
            this.log.warning(e.getLocalizedMessage(), new Object[]{e});
            return true;
        }
    }

    @Override
    public boolean isStored(ObjId id) throws IndexException {
        return this.getCmsNodeOf(id) != null;
    }

    @Override
    public void removeObj(ObjId id) throws IndexException {
        this.sqlRunner.withPreparedIndexStatement(SQL_DELETE_OBJ_1, st -> {
            st.setString(1, objId.id);
            st.setString(2, objId.id);
            st.executeUpdate();
            return null;
        });
        this.sqlRunner.withPreparedIndexStatement(SQL_DELETE_CMS_CHILDREN_OF, st -> {
            st.setString(1, objId.id);
            st.executeUpdate();
            return null;
        });
    }

    @Override
    public void setParent(ObjId cmsNodeId, ObjId parentId) throws IndexException {
        this.sqlRunner.withPreparedIndexStatement(SQL_SET_PARENT_OF_CMS_NODE, insertCmsNodeSt -> {
            try {
                int i = 1;
                insertCmsNodeSt.setString(i++, objId.id);
                insertCmsNodeSt.setString(i++, objId.classof.getQualifiedName());
                insertCmsNodeSt.setString(i++, objId2.id);
                insertCmsNodeSt.setString(i++, objId2.classof.getQualifiedName());
                insertCmsNodeSt.executeUpdate();
            }
            catch (SQLIntegrityConstraintViolationException e) {
                ObjId oldParentId;
                try {
                    oldParentId = this.getParentNodeOf(cmsNodeId);
                }
                catch (IndexException e1) {
                    e.addSuppressed(e1);
                    throw e;
                }
                if (!Objects.equals(parentId, oldParentId)) {
                    e.addSuppressed(new Throwable(String.format("%s parent is already %s, cannot set parent to %s.", cmsNodeId, oldParentId, parentId)));
                    throw e;
                }
                this.log.trace("setParent(%s, %s): parent already set, ignore call", new Object[]{cmsNodeId, parentId});
            }
            return null;
        });
    }

    @Override
    public Stream<ObjIdName> idByMClass(SmClass cls) throws StreamException, IndexException {
        try {
            return this.sqlRunner.streamPreparedSqlStatement(SQL_GET_BY_MCLASS, req -> req.setString(1, cls.getQualifiedName())).map(res -> {
                try {
                    return new ObjIdName(this.metamodel.getMClass(res.getString(1)), res.getString(3), res.getString(2));
                }
                catch (SQLException e) {
                    throw new StreamException((Exception)e);
                }
            });
        }
        catch (SQLException e1) {
            throw this.sqlRunner.translateSqlException(e1);
        }
    }

    @Override
    public Collection<IndexElement> findByName(SmClass cls, String name) throws IndexException {
        return this.sqlRunner.withPreparedIndexStatement(SQL_GET_BY_NAME, st -> {
            st.setString(1, name);
            st.setString(2, cls.getQualifiedName());
            Throwable throwable = null;
            Object var5_6 = null;
            try (ResultSet res = st.executeQuery();){
                ArrayList<IndexElement> ret = new ArrayList<IndexElement>(100);
                while (res.next()) {
                    ret.add(new IndexElement(new ObjIdName(cls, name, res.getString(1)), new ObjId(this.metamodel.getMClass(res.getString(3)), res.getString(2))));
                }
                return ret;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
    }

    @Override
    public Collection<ObjId> getCmsNodeContent(ObjId cmsNodeId) throws IndexException {
        return this.sqlRunner.withPreparedIndexStatement(SQL_GET_CMSNODE_CONTENT, st -> {
            st.setString(1, objId.id);
            st.setString(2, objId.classof.getQualifiedName());
            Throwable throwable = null;
            Object var4_5 = null;
            try (ResultSet res = st.executeQuery();){
                ArrayList<ObjId> ret = new ArrayList<ObjId>(100);
                while (res.next()) {
                    ret.add(new ObjId(this.metamodel.getMClass(res.getString(2)), res.getString(1)));
                }
                return ret;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
    }

    @Deprecated
    private static class ResultSetIterator
    implements Iterator<ResultSet> {
        private int state;
        private final ResultSet resultSet;

        private ResultSetIterator(ResultSet resultSet) {
            this.resultSet = resultSet;
            this.state = 0;
        }

        private void advance() {
            if (this.state == 1) {
                return;
            }
            if (this.state == 0) {
                try {
                    this.state = this.resultSet.next() ? 1 : 2;
                }
                catch (SQLException e) {
                    this.state = 2;
                    throw new StreamException((Exception)e);
                }
            }
        }

        @Override
        public boolean hasNext() {
            this.advance();
            return this.state == 1;
        }

        @Override
        public ResultSet next() {
            this.advance();
            if (this.state == 1) {
                this.state = 0;
                return this.resultSet;
            }
            if (this.state == 2) {
                throw new NoSuchElementException();
            }
            throw new IllegalStateException(String.format("Unexpected state : %d", this.state));
        }
    }
}

