/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.common.index.hsqldb;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.modelio.vbasic.log.IBasicLogger;
import org.modelio.vbasic.log.Log;
import org.modelio.vcore.smkernel.meta.SmMetamodel;
import org.modelio.vstore.exml.common.index.IUserNodeIndex;
import org.modelio.vstore.exml.common.index.IndexException;
import org.modelio.vstore.exml.common.index.hsqldb.SqlOperationRunner;
import org.modelio.vstore.exml.common.model.ObjId;

public class HSqlUsesIndex
implements IUserNodeIndex {
    private static final String SQL_GET_SOURCES_FROM_TARGET = "SELECT e.clsname, e.id, e.name FROM \"elements\" as e, \"dependencies\" as d WHERE d.targetid=? and d.depname=? and e.id=d.srcid ";
    private static final String SQL_ADD_USE = "INSERT INTO \"dependencies\" (srcid, depname, targetid) values (?, ?, ?)";
    private static final String SQL_DELETE_CMSNODE_USES = "DELETE FROM \"dependencies\" WHERE srcid IN (SELECT id FROM \"elements\" WHERE cmsnodeid=?)";
    private final IBasicLogger log;
    private final SqlOperationRunner sqlRunner;
    private final SmMetamodel metamodel;

    public HSqlUsesIndex(SmMetamodel metamodel, SqlOperationRunner sqlRunner, String projectName) throws SQLException {
        this.sqlRunner = sqlRunner;
        this.log = Log.getLogger();
        this.metamodel = metamodel;
    }

    @Override
    public void remove(ObjId id) throws IndexException {
        this.sqlRunner.withPreparedIndexStatement(SQL_DELETE_CMSNODE_USES, insertObjectSt -> {
            insertObjectSt.setString(1, objId.id);
            insertObjectSt.execute();
            return null;
        });
    }

    @Override
    public void addUsed(ObjId userNodeId, String depName, ObjId usedObjectId) throws IndexException {
        this.sqlRunner.withPreparedIndexStatement(SQL_ADD_USE, insertObjectSt -> {
            int i = 1;
            insertObjectSt.setString(i++, objId.id);
            insertObjectSt.setString(i++, depName);
            insertObjectSt.setString(i++, objId2.id);
            return insertObjectSt.execute();
        });
    }

    @Override
    public Collection<ObjId> getObjectUsers(ObjId objectId, String depName) throws IndexException {
        return this.sqlRunner.withPreparedIndexStatement(SQL_GET_SOURCES_FROM_TARGET, req -> {
            req.setString(1, objId.id);
            req.setString(2, depName);
            ArrayList<ObjId> ret = new ArrayList<ObjId>();
            Throwable throwable = null;
            Object var6_7 = null;
            try (ResultSet res = req.executeQuery();){
                while (res.next()) {
                    ObjId ref = new ObjId(this.metamodel.getMClass(res.getString(1)), res.getString(2));
                    ret.add(ref);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return ret;
        });
    }
}

