/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.common.index.hsqldb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.modelio.vbasic.log.Log;

class HsqlConnection {
    private final String dburl;
    private Connection jdbcConnection;
    private final Map<String, PreparedStatement> statCache = new HashMap<String, PreparedStatement>();
    private List<PreparedStatement> statement;

    public HsqlConnection(String dburl) {
        this.dburl = dburl;
    }

    public Connection getJdbcConnection() throws SQLException {
        if (this.jdbcConnection == null) {
            this.jdbcConnection = DriverManager.getConnection(this.dburl, "SA", "");
        }
        return this.jdbcConnection;
    }

    public void dispose() {
        if (this.jdbcConnection == null) {
            return;
        }
        try {
            this.jdbcConnection.close();
            this.jdbcConnection = null;
        }
        catch (SQLException e) {
            Log.warning((Throwable)e);
        }
    }

    public PreparedStatement getPreparedStatement(String sql) throws SQLException {
        PreparedStatement st = this.statCache.get(sql);
        if (st != null) {
            return st;
        }
        st = this.getJdbcConnection().prepareStatement(sql);
        this.statCache.put(sql, st);
        return st;
    }
}

