/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.common.index.hsqldb;

import java.lang.ref.Cleaner;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.modelio.vbasic.debug.ThreadDumper;
import org.modelio.vbasic.log.Log;
import org.modelio.vstore.exml.common.index.hsqldb.HsqlConnection;
import org.modelio.vstore.exml.common.index.hsqldb.SqlFunction;
import org.modelio.vstore.exml.common.index.hsqldb.SqlOperation;
import org.modelio.vstore.exml.common.index.hsqldb.SqlOperationRunner;

class HsqlConnectionPool
implements SqlOperationRunner {
    private final String dburl;
    private final int maxSize;
    private boolean threadsDumped;
    private volatile boolean disposed;
    private final BlockingQueue<HsqlConnection> connections;
    private static final Cleaner cleaner = Cleaner.create();

    public HsqlConnectionPool(String dburl) {
        this.dburl = dburl;
        this.maxSize = Runtime.getRuntime().availableProcessors() * 2;
        this.connections = new ArrayBlockingQueue<HsqlConnection>(this.maxSize);
        int i = 0;
        while (i < this.maxSize) {
            this.connections.add(new HsqlConnection(this.dburl));
            ++i;
        }
    }

    public HsqlConnection get() throws SQLException, IllegalStateException, CancellationException {
        if (this.disposed) {
            throw new IllegalStateException(String.format("'%s': disposed.", this.dburl, this.maxSize));
        }
        try {
            HsqlConnection ret = this.connections.poll(1L, TimeUnit.SECONDS);
            if (ret != null) {
                return ret;
            }
        }
        catch (InterruptedException e) {
            CancellationException ex = new CancellationException(String.format("'%s': interrupted waiting for a SQL connection.", this.dburl, this.maxSize));
            ex.initCause(e);
            Thread.currentThread().interrupt();
            throw ex;
        }
        IllegalStateException ex = new IllegalStateException(String.format("'%s': Too much connections : %d maximum.", this.dburl, this.maxSize));
        if (!this.threadsDumped) {
            ThreadDumper.get().getAllThreads(true).addAsSupressed((Throwable)ex);
            this.threadsDumped = true;
        }
        throw ex;
    }

    public void dispose() {
        HsqlConnection c;
        this.disposed = true;
        while ((c = (HsqlConnection)this.connections.poll()) != null) {
            c.dispose();
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public <T> T runSqlOperation(SqlFunction<Connection, T> sqlOp) throws SQLException {
        HsqlConnection aConn = this.get();
        try {
            T t = sqlOp.run(aConn.getJdbcConnection());
            return t;
        }
        finally {
            this.release(aConn);
        }
    }

    private void release(HsqlConnection aConn) {
        try {
            if (this.disposed) {
                aConn.dispose();
            } else {
                this.connections.add(aConn);
            }
        }
        catch (Throwable e) {
            Log.warning((Throwable)e);
        }
    }

    @Override
    public void runSqlOperation(SqlOperation<Connection> sqlOp) throws SQLException {
        HsqlConnection aConn = this.get();
        try {
            sqlOp.run(aConn.getJdbcConnection());
        }
        finally {
            this.release(aConn);
        }
    }

    @Override
    public <T> T withPreparedSqlStatement(String sql, SqlOperationRunner.PreparedStatementConsumer<T> sqlOp) throws SQLException {
        HsqlConnection aConn = this.get();
        try {
            PreparedStatement statement = aConn.getPreparedStatement(sql);
            T t = sqlOp.acceptPreparedStatement(statement);
            return t;
        }
        finally {
            this.release(aConn);
        }
    }

    @Override
    public Stream<ResultSet> streamPreparedSqlStatement(String sql, SqlOperation<PreparedStatement> sqlOp) throws SQLException {
        boolean ok = false;
        HsqlConnection aConn = this.get();
        try {
            PreparedStatement statement = aConn.getPreparedStatement(sql);
            sqlOp.run(statement);
            Stream<ResultSet> ret = SqlOperationRunner.toStream(statement.executeQuery());
            Cleaner.Cleanable cleanable = cleaner.register(ret, () -> this.release(aConn));
            ok = true;
            Stream stream = (Stream)ret.onClose(cleanable::clean);
            return stream;
        }
        finally {
            if (!ok) {
                this.release(aConn);
            }
        }
    }
}

