/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.common.index.hsqldb;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLTransientConnectionException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.server.Server;
import org.hsqldb.server.ServerAcl;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.files.StreamException;
import org.modelio.vbasic.log.IBasicLogger;
import org.modelio.vbasic.log.Log;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vcore.smkernel.meta.SmMetamodel;
import org.modelio.vstore.exml.common.index.ICmsNodeIndex;
import org.modelio.vstore.exml.common.index.IIndexDb;
import org.modelio.vstore.exml.common.index.IUserNodeIndex;
import org.modelio.vstore.exml.common.index.IndexException;
import org.modelio.vstore.exml.common.index.IndexOutdatedException;
import org.modelio.vstore.exml.common.index.hsqldb.HSqlCmsNodeIndex;
import org.modelio.vstore.exml.common.index.hsqldb.HSqlUsesIndex;
import org.modelio.vstore.exml.common.index.hsqldb.HsqlConnectionPool;
import org.modelio.vstore.exml.common.index.hsqldb.SqlFunction;
import org.modelio.vstore.exml.common.index.hsqldb.SqlOperation;
import org.modelio.vstore.exml.common.index.hsqldb.SqlOperationRunner;
import org.modelio.vstore.exml.resource.IExmlResourceProvider;

public class HsqlIndexes
implements IIndexDb,
SqlOperationRunner {
    static final int VERSION = 5;
    private String host;
    private int port;
    private final String projectName;
    private final boolean canCreateDb;
    public static boolean RUN_SERVER = false;
    private static final boolean TRACE = false;
    private static final IBasicLogger LOG = Log.getLogger();
    private HSqlCmsNodeIndex cmsNodeIndex;
    private HsqlConnectionPool connPool;
    private final Path indexDbPath;
    private HSqlUsesIndex userNodeIndex;

    static {
        if (RUN_SERVER) {
            LocalServer.instance.start();
        }
    }

    public HsqlIndexes(Path indexDbPath, String projectName, boolean canCreateDb) {
        this.canCreateDb = canCreateDb;
        this.indexDbPath = Objects.requireNonNull(indexDbPath);
        this.projectName = Objects.requireNonNull(projectName);
    }

    public HsqlIndexes(String host, int port, Path indexDbPath, String projectName, boolean canCreateDb) {
        this.indexDbPath = indexDbPath;
        this.canCreateDb = canCreateDb;
        this.host = Objects.requireNonNull(host);
        this.port = port;
        this.projectName = Objects.requireNonNull(projectName);
    }

    @Override
    public void checkIndexFormat() throws IndexException, IndexOutdatedException {
        int storedVersion = this.getStoredVersion();
        if (storedVersion != 5) {
            throw new IndexOutdatedException(String.format("Index format mismatch, version is %d , expected %d", storedVersion, 5));
        }
    }

    @Override
    public void close() throws IndexException {
        if (this.connPool != null) {
            this.runIndexOperation(connection -> {
                Throwable throwable = null;
                Object var3_4 = null;
                try (Statement wipeStatement = connection.createStatement();){
                    wipeStatement.execute("SHUTDOWN");
                    if (wipeStatement.getWarnings() != null) {
                        LOG.warning("SHUTDOWN:", new Object[]{wipeStatement.getWarnings()});
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                connection.commit();
            });
            this.connPool.dispose();
            this.connPool = null;
        }
    }

    @Override
    public void deleteIndexes() throws IndexException {
        if (this.connPool != null) {
            this.runIndexOperation(connection -> {
                Throwable throwable = null;
                Object var3_4 = null;
                try (Statement wipeStatement = connection.createStatement();){
                    wipeStatement.execute("DROP SCHEMA PUBLIC CASCADE");
                    if (wipeStatement.getWarnings() != null) {
                        LOG.warning("drop schema:", new Object[]{wipeStatement.getWarnings()});
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                connection.commit();
            });
        }
        try {
            this.close();
            if (RUN_SERVER) {
                LocalServer.instance.stop();
            }
            FileUtils.delete((Path)this.indexDbPath);
            if (RUN_SERVER) {
                LocalServer.instance.start();
            }
        }
        catch (IOException e) {
            throw new IndexException(FileUtils.getLocalizedMessage((IOException)e), e);
        }
    }

    @Override
    public void commit() throws IndexException {
        this.runIndexFunction(c -> {
            if (!c.getAutoCommit()) {
                c.commit();
            }
            return null;
        });
    }

    @Override
    public void compress(IModelioProgress monitor) throws IndexException {
        this.runIndexOperation(c -> {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Statement st = c.createStatement();){
                st.execute("SHUTDOWN COMPACT");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
        this.reconnectToDatabase();
    }

    @Override
    public ICmsNodeIndex getCmsNodeIndex() {
        return this.cmsNodeIndex;
    }

    @Override
    public String getStoredStamp() throws IndexException {
        return this.getMetaProp("stamp", "");
    }

    @Override
    public int getStoredVersion() throws IndexException {
        try {
            return Integer.parseInt(this.getMetaProp("version", "-1"));
        }
        catch (IndexException e) {
            if (e.getMessage().startsWith("user lacks privilege or object not found")) {
                return -1;
            }
            throw e;
        }
    }

    @Override
    public IUserNodeIndex getUserNodeIndex() {
        return this.userNodeIndex;
    }

    @Override
    public void open(IModelioProgress aMonitor, IExmlResourceProvider resProvider, SmMetamodel metamodel) throws IndexException {
        if (this.connPool != null) {
            try {
                this.initDb();
            }
            catch (SQLException e) {
                throw this.translateSqlExc(e);
            }
            catch (IOException e) {
                throw new IndexException(FileUtils.getLocalizedMessage((IOException)e), e);
            }
            return;
        }
        try {
            InetAddress inetHost;
            if (this.canCreateDb && ((inetHost = InetAddress.getByName(this.host)).equals(InetAddress.getLocalHost()) || inetHost.isLoopbackAddress())) {
                Files.createDirectories(this.indexDbPath, new FileAttribute[0]);
            }
            this.reconnectToDatabase();
            this.initDb();
            this.cmsNodeIndex = new HSqlCmsNodeIndex(this, this.projectName, metamodel);
            this.userNodeIndex = new HSqlUsesIndex(metamodel, this, this.projectName);
        }
        catch (SQLException e) {
            throw this.translateSqlExc(e);
        }
        catch (IOException e) {
            throw new IndexException(FileUtils.getLocalizedMessage((IOException)e), e);
        }
    }

    @Override
    public void setStamp(String stamp) throws IndexException {
        this.setMetaProp("stamp", stamp);
    }

    @Override
    public void setStoredVersion() throws IndexException {
        this.setMetaProp("version", String.valueOf(5));
    }

    private String getMetaProp(String key, String defaultVal) throws IndexException {
        try {
            return this.runSqlOperation((Connection cnx) -> {
                PreparedStatement st = cnx.prepareStatement("select \"val\" from \"metadatas\" where \"key\" = ?");
                st.setString(1, key);
                Throwable throwable = null;
                Object var6_7 = null;
                try (ResultSet res = st.executeQuery();){
                    this.logSqlWarnings(st);
                    if (res.next()) {
                        String strRes = res.getString(1);
                        return strRes;
                    }
                    return defaultVal;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            });
        }
        catch (SQLException e) {
            throw this.translateSqlExc(e);
        }
    }

    private void initDb() throws SQLException, IOException {
        boolean isToCreate = this.runSqlOperation((Connection conn) -> {
            try {
                Throwable throwable = null;
                Object var2_3 = null;
                try (ResultSet tables = conn.getMetaData().getTables(null, null, "metadatas", new String[]{"TABLE"});){
                    return !tables.next();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException sQLException) {
                return true;
            }
        });
        if (isToCreate) {
            if (!this.canCreateDb) {
                throw new NoSuchFileException(this.getJdbcUrl(), this.indexDbPath.toString(), MessageFormat.format("The ''{0}'' database has not been initialized by the server.", this.projectName));
            }
            String schema_file_name = "res/hsqldb_index_schema.sql";
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream is = this.getClass().getResourceAsStream("/" + schema_file_name);){
                if (is == null) {
                    throw new NoSuchFileException(schema_file_name, null, this.getClass().getClassLoader().toString());
                }
                String sqls = FileUtils.readWhole((InputStream)is, (String)"UTF-8");
                this.connPool.runSqlOperation((Connection conn) -> {
                    String[] stringArray = sqls.split(Pattern.quote("-- **commit**"));
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String sql = stringArray[n2];
                        Throwable throwable = null;
                        Object var8_9 = null;
                        try (Statement createStatement = conn.createStatement();){
                            createStatement.execute(sql);
                            this.logSqlWarnings(createStatement);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        ++n2;
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void setMetaProp(String key, String value) throws IndexException {
        this.runIndexOperation(conn -> {
            block19: {
                Throwable throwable = null;
                Object var5_6 = null;
                try (PreparedStatement st = conn.prepareStatement("update \"metadatas\" set \"val\" = ? where \"key\" = ?");){
                    st.setString(1, value);
                    st.setString(2, key);
                    int count = st.executeUpdate();
                    if (count == 0) {
                        Throwable throwable2 = null;
                        Object var9_12 = null;
                        try (PreparedStatement st2 = conn.prepareStatement("insert into \"metadatas\" (\"key\", \"val\") values(  ? , ?)");){
                            st2.setString(1, key);
                            st2.setString(2, value);
                            count = st2.executeUpdate();
                            this.logSqlWarnings(st2);
                            break block19;
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    this.logSqlWarnings(st);
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
        });
    }

    private void logSqlWarnings(Statement st) throws SQLException {
        if (st.getWarnings() != null) {
            LOG.warning("%s: %s execution returned warnings: %s", new Object[]{this.getClass().getSimpleName(), st, st.getWarnings()});
        }
    }

    private IndexException translateSqlExc(SQLException e) {
        return new IndexException(e.getLocalizedMessage(), e);
    }

    private String getJdbcUrl() {
        String ifExistProp = this.canCreateDb ? "" : ";ifexists=true";
        Object filepathProp = "";
        Path dbPath = null;
        if (this.indexDbPath != null) {
            dbPath = this.indexDbPath.resolve(this.projectName).toAbsolutePath();
            filepathProp = ";filepath=file:" + String.valueOf(dbPath);
        }
        if (this.host == null) {
            URI file = dbPath.toUri();
            return MessageFormat.format("jdbc:hsqldb:file:/{0}{1}{2};hsqldb.reconfig_logging=false", file.getPath(), filepathProp, ifExistProp);
        }
        Object loc = this.host;
        if (this.port > 0) {
            loc = this.host + ":" + this.port;
        }
        return MessageFormat.format("jdbc:hsqldb:hsql://{0}/{1}{2}{3};hsqldb.reconfig_logging=false", loc, this.projectName, filepathProp, ifExistProp);
    }

    @Override
    public void runSqlOperation(SqlOperation<Connection> torun) throws SQLException {
        this.callOrRetry(() -> {
            this.connPool.runSqlOperation(torun);
            return null;
        });
    }

    @Override
    public Stream<ResultSet> streamPreparedSqlStatement(String sql, SqlOperation<PreparedStatement> sqlOp) throws SQLException, StreamException {
        return this.callOrRetry(() -> this.connPool.streamPreparedSqlStatement(sql, sqlOp));
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    private void reconnectToDatabase() {
        String dburl = this.getJdbcUrl();
        HsqlConnectionPool oldPool = this.connPool;
        if (oldPool != null) {
            oldPool.dispose();
        }
        this.connPool = new HsqlConnectionPool(dburl);
    }

    @Override
    public <T> T runSqlOperation(SqlFunction<Connection, T> torun) throws SQLException {
        return (T)this.callOrRetry(() -> this.connPool.runSqlOperation(torun));
    }

    private <T> T callOrRetry(SqlCallable<T> torun) throws SQLException {
        try {
            return torun.call();
        }
        catch (SQLNonTransientConnectionException e) {
            if (!e.getMessage().contains("connection exception: closed")) {
                throw e;
            }
            try {
                this.reconnectToDatabase();
                return torun.call();
            }
            catch (SQLException e2) {
                e2.addSuppressed(e);
                throw e2;
            }
        }
        catch (SQLTransientConnectionException e) {
            try {
                this.reconnectToDatabase();
                return torun.call();
            }
            catch (SQLException e2) {
                e2.addSuppressed(e);
                throw e2;
            }
        }
    }

    @Override
    public <T> T withPreparedSqlStatement(String sql, SqlOperationRunner.PreparedStatementConsumer<T> sqlOp) throws SQLException {
        return (T)this.callOrRetry(() -> this.connPool.withPreparedSqlStatement(sql, sqlOp));
    }

    public static void setRunServer(boolean runServer) {
        if (runServer && !RUN_SERVER) {
            LocalServer.instance.start();
        }
        RUN_SERVER = runServer;
    }

    public static class LocalServer {
        private Server server = new Server();
        public static final LocalServer instance = new LocalServer();

        public void start() throws IllegalStateException {
            LOG.trace("Starting HSQL server in this local JVM ...");
            try {
                Class.forName("org.hsqldb.jdbc.JDBCDriver");
            }
            catch (ClassNotFoundException e) {
                throw new LinkageError("Missing HSQLDB class:" + e.getMessage(), e);
            }
            try {
                HsqlProperties props = new HsqlProperties();
                props.setProperty("server.remote_open", true);
                this.server.setProperties(props);
                this.server.start();
                if (this.server.getState() != 1) {
                    LOG.trace("   HSQL server state is %s.", new Object[]{this.server.getStateDescriptor()});
                    Thread.sleep(100L);
                    LOG.trace("   HSQL server state is now %s.", new Object[]{this.server.getStateDescriptor()});
                }
                this.server.checkRunning(true);
                LOG.trace("  Started HSQL server.");
            }
            catch (IOException e) {
                throw new IllegalStateException(FileUtils.getLocalizedMessage((IOException)e), e);
            }
            catch (ServerAcl.AclFormatException e) {
                throw new IllegalStateException(e.getLocalizedMessage(), e);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Wait for HSQL server being ready interrupted", e);
            }
        }

        public void stop() {
            LOG.trace("Stopping HSQL server ...");
            this.server.setRestartOnShutdown(false);
            this.server.shutdownWithCatalogs(2);
            this.server.stop();
            int i = 0;
            while (i < 10 && this.server.getState() != 16) {
                LOG.trace("  Waiting for HSQL server to stop %d/10 , state = %d:%s...", new Object[]{i, this.server.getState(), this.server.getStateDescriptor()});
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    throw new CompletionException(e);
                }
                ++i;
            }
            if (this.server.getState() != 16) {
                throw new IllegalStateException(String.format("HSQL server still running, state = %d:%s", this.server.getState(), this.server.getStateDescriptor()));
            }
            LOG.trace("HSQL server stopped, state = %d:%s", new Object[]{this.server.getState(), this.server.getStateDescriptor()});
        }
    }

    @FunctionalInterface
    static interface SqlCallable<T> {
        public T call() throws SQLException;
    }
}

