/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.common.index.hsqldb;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.modelio.vbasic.files.StreamException;
import org.modelio.vbasic.log.Log;
import org.modelio.vstore.exml.common.index.IndexException;
import org.modelio.vstore.exml.common.index.hsqldb.SqlFunction;
import org.modelio.vstore.exml.common.index.hsqldb.SqlOperation;

interface SqlOperationRunner {
    default public <T> T withPreparedIndexStatement(String sql, PreparedStatementConsumer<T> sqlOp) throws IndexException {
        try {
            return this.withPreparedSqlStatement(sql, sqlOp);
        }
        catch (SQLException e) {
            throw this.translateSqlException(e);
        }
    }

    public <T> T withPreparedSqlStatement(String var1, PreparedStatementConsumer<T> var2) throws SQLException;

    public Stream<ResultSet> streamPreparedSqlStatement(String var1, SqlOperation<PreparedStatement> var2) throws SQLException, StreamException;

    public <T> T runSqlOperation(SqlFunction<Connection, T> var1) throws SQLException;

    public void runSqlOperation(SqlOperation<Connection> var1) throws SQLException;

    default public <T> T runIndexFunction(SqlFunction<Connection, T> op) throws IndexException {
        try {
            return this.runSqlOperation(op);
        }
        catch (SQLException e) {
            throw this.translateSqlException(e);
        }
    }

    default public <T> T runIndexFunctionRt(SqlFunction<Connection, T> op) throws StreamException {
        try {
            return this.runSqlOperation(op);
        }
        catch (SQLException e) {
            throw this.translateSqlExceptionRuntime(e);
        }
    }

    default public void runIndexOperation(SqlOperation<Connection> op) throws IndexException {
        try {
            this.runSqlOperation(op);
        }
        catch (SQLException e) {
            throw this.translateSqlException(e);
        }
    }

    default public IndexException translateSqlException(SQLException e) {
        return new IndexException(e.getLocalizedMessage(), e);
    }

    default public StreamException translateSqlExceptionRuntime(SQLException e) {
        return new StreamException((Exception)new IndexException(e.getLocalizedMessage(), e));
    }

    public static Stream<ResultSet> toStream(ResultSet resultSet) {
        return (Stream)StreamSupport.stream(new ResultSetSpliterator(resultSet), false).onClose(() -> {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                Log.warning((String)e.getMessage(), (Object[])new Object[]{e});
            }
        });
    }

    public static Stream<ResultSet> toStream(Supplier<ResultSet> resultSet) {
        CachedSupplierValue cached = new CachedSupplierValue(resultSet);
        return (Stream)StreamSupport.stream(() -> new ResultSetSpliterator(cached.get()), 16, false).onClose(() -> cached.close());
    }

    public static final class CachedSupplierValue
    implements Supplier<ResultSet> {
        private final Supplier<ResultSet> resultSet;
        private ResultSet val;

        private CachedSupplierValue(Supplier<ResultSet> resultSet) {
            this.resultSet = resultSet;
        }

        @Override
        public ResultSet get() {
            if (this.val == null) {
                this.val = this.resultSet.get();
            }
            return this.val;
        }

        public void close() {
            if (this.val != null) {
                try {
                    this.val.close();
                }
                catch (SQLException e) {
                    Log.trace((Throwable)e);
                }
            }
        }
    }

    public static interface PreparedStatementConsumer<T> {
        public T acceptPreparedStatement(PreparedStatement var1) throws SQLException;
    }

    public static class ResultSetSpliterator
    extends Spliterators.AbstractSpliterator<ResultSet> {
        private final ResultSet resultSet;

        private ResultSetSpliterator(ResultSet resultSet) {
            super(Long.MAX_VALUE, 16);
            this.resultSet = resultSet;
        }

        @Override
        public boolean tryAdvance(Consumer<? super ResultSet> action) {
            block3: {
                try {
                    if (this.resultSet.next()) break block3;
                    this.close();
                    return false;
                }
                catch (SQLException ex) {
                    throw new StreamException((Exception)ex);
                }
            }
            action.accept(this.resultSet);
            return true;
        }

        @Override
        public void forEachRemaining(Consumer<? super ResultSet> action) {
            try {
                try {
                    while (this.resultSet.next()) {
                        action.accept(this.resultSet);
                    }
                }
                catch (SQLException ex) {
                    throw new StreamException((Exception)ex);
                }
            }
            finally {
                this.close();
            }
        }

        void close() {
            try {
                this.resultSet.close();
            }
            catch (RuntimeException | SQLException e) {
                Log.trace((Throwable)e);
            }
        }
    }
}

