/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.modelio.vcore.smkernel.SmLiveId;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.SmObjectSmClass;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.meta.SmDependency;

public final class ExmlUtils {
    public static SmObjectImpl getCmsNode(SmObjectImpl initialObj) {
        SmObjectImpl obj = initialObj;
        while (obj != null && !obj.getClassOf().isCmsNode()) {
            obj = obj.getCompositionOwner();
        }
        return obj;
    }

    public static List<SmDependency> getExternalisableDeps(SmObjectImpl object) {
        SmObjectSmClass objectClass = object.getClassOf();
        List allDeps = objectClass.getAllDepDef();
        ArrayList<SmDependency> deps = new ArrayList<SmDependency>(allDeps.size());
        for (SmDependency dep : allDeps) {
            if (!ExmlUtils.isDepToSerialize(dep)) continue;
            deps.add(dep);
        }
        return deps;
    }

    public static boolean isDepToSerialize(SmDependency dep) {
        return ExmlUtils.isDepComponent(dep) || dep.isPartOf() && !dep.isCompositionOpposite();
    }

    public static Collection<SmObjectImpl> getLoadedCmsNodeContent(SmObjectImpl cmsNode) {
        ArrayList<SmObjectImpl> results = new ArrayList<SmObjectImpl>();
        ExmlUtils.getLoadedCmsNodeContent(cmsNode, results);
        return results;
    }

    public static MObject getParentCmsNode(MObject object) {
        MObject parent = object.getCompositionOwner();
        while (parent != null && !parent.getMClass().isCmsNode()) {
            parent = parent.getCompositionOwner();
        }
        return parent;
    }

    public static boolean isComposition(SmObjectImpl src, SmDependency dep, SmObjectImpl dest) {
        if (dep.isComponent()) {
            return true;
        }
        if (!dep.isSharedComposition()) {
            return false;
        }
        return src.equals((Object)dest.getCompositionOwner());
    }

    public static boolean isDepComponent(SmDependency dep) {
        return dep.isComponent() || dep.isSharedComposition();
    }

    public static boolean sameRepository(MObject o1, MObject o2) {
        return ExmlUtils.sameRepository((SmObjectImpl)o1, (SmObjectImpl)o2);
    }

    public static boolean sameRepository(SmObjectImpl o1, SmObjectImpl o2) {
        return SmLiveId.getRid((long)o2.getLiveId()) == SmLiveId.getRid((long)o1.getLiveId());
    }

    private ExmlUtils() {
    }

    private static void getLoadedCmsNodeContent(SmObjectImpl root, Collection<SmObjectImpl> children) {
        ArrayList<SmObjectImpl> directChildren = new ArrayList<SmObjectImpl>();
        ArrayList<SmObjectImpl> currentRoots = new ArrayList<SmObjectImpl>();
        currentRoots.add(root);
        while (!currentRoots.isEmpty()) {
            for (SmObjectImpl o : currentRoots) {
                directChildren.addAll(ExmlUtils.getLoadedCompoChildren(o));
            }
            currentRoots.clear();
            for (SmObjectImpl child : directChildren) {
                if (children.contains(child) || child.getMClass().isCmsNode()) continue;
                children.add(child);
                currentRoots.add(child);
            }
            directChildren = new ArrayList();
        }
    }

    private static Collection<SmObjectImpl> getLoadedCompoChildren(SmObjectImpl obj) {
        ArrayList<SmObjectImpl> results = new ArrayList<SmObjectImpl>();
        for (SmDependency dep : obj.getClassOf().getAllComponentAndSharedDepDef()) {
            Collection depVal;
            if (dep.isMultiple()) {
                depVal = dep.getValueAsCollection(obj.getData());
                results.addAll(depVal);
                continue;
            }
            depVal = (SmObjectImpl)dep.getValue(obj.getData());
            if (depVal == null) continue;
            results.add((SmObjectImpl)depVal);
        }
        return results;
    }

    public static boolean areTargetsAlwaysInSameRepository(SmDependency dep) {
        return dep.isComposition() || dep.isCompositionOpposite() && !dep.getSymetric().isSharedComposition();
    }
}

