/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.common.utils;

import java.util.function.Supplier;
import org.modelio.vbasic.log.Log;
import org.modelio.vcore.smkernel.mapi.MRef;
import org.modelio.vcore.smkernel.meta.SmClass;
import org.modelio.vcore.smkernel.meta.SmMetamodel;
import org.modelio.vstore.exml.common.model.ObjId;
import org.modelio.vstore.exml.common.model.ObjIdName;

public class ObjIdReader {
    private final SmMetamodel metamodel;
    private final Supplier<String> logPrefixer;
    private final Supplier<String> logSuffixer;

    public ObjIdReader(SmMetamodel metamodel, Supplier<String> logPrefixer, Supplier<String> logSuffixer) {
        this.metamodel = metamodel;
        this.logPrefixer = logPrefixer;
        this.logSuffixer = logSuffixer;
    }

    public ObjIdName readObjIdName(String className, String uid, String name, boolean isCmsNode) {
        SmClass mClass = this.readMetaclass(className, isCmsNode);
        return new ObjIdName(mClass, name, uid);
    }

    public ObjIdName readObjIdName(MRef r, boolean isCmsNode) {
        return this.readObjIdName(r.mc, r.uuid, r.name, isCmsNode);
    }

    public ObjId readObjId(String className, String uid, boolean isCmsNode) {
        SmClass mClass = this.readMetaclass(className, isCmsNode);
        return new ObjId(mClass, uid);
    }

    private SmClass readMetaclass(String className, boolean isCmsNode) {
        SmClass mClass = this.metamodel.getMClass(className);
        if (mClass == null) {
            if (className == null || className.isEmpty()) {
                throw new IllegalArgumentException(className);
            }
            mClass = this.metamodel.fakeClassBuilder().setQualifiedName(className).setCmsNode(isCmsNode).build();
            String message = String.format("%sCreating '%s' fake metaclass%s.", this.logPrefixer.get(), className, this.logSuffixer.get());
            Log.warning((String)message);
        }
        return mClass;
    }

    public ObjId readObjId(MRef r, boolean isCmsNode) {
        return this.readObjId(r.mc, r.uuid, isCmsNode);
    }
}

