/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.json.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vbasic.log.Log;
import org.modelio.vcore.model.DuplicateObjectException;
import org.modelio.vcore.session.impl.storage.IModelLoader;
import org.modelio.vcore.smkernel.IRepositoryObject;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.SmObjectSmClass;
import org.modelio.vcore.smkernel.meta.SmDependency;
import org.modelio.vstore.exml.common.ExmlStorageHandler;
import org.modelio.vstore.exml.common.ILoadHelper;
import org.modelio.vstore.exml.common.index.IndexException;
import org.modelio.vstore.exml.common.model.IllegalReferenceException;
import org.modelio.vstore.exml.common.model.ObjId;
import org.modelio.vstore.exml.common.model.ObjIdName;
import org.modelio.vstore.exml.common.utils.ExmlUtils;
import org.modelio.vstore.exml.local.loader.IExmlLoader;
import org.xml.sax.InputSource;

public class JsonModelParser
implements IExmlLoader {
    private ILoadHelper loadHelper;
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public JsonModelParser(ILoadHelper loadHelper) {
        this.loadHelper = loadHelper;
    }

    @Override
    public SmObjectImpl load(InputSource is, IModelLoader modelLoader) throws DuplicateObjectException, IOException {
        return new ParseTask(modelLoader, this.loadHelper).load(is);
    }

    private static class ParseTask {
        private final IModelLoader modelLoader;
        private final ILoadHelper loadHelper;
        private ExmlStorageHandler nodeStorageHandler;

        public ParseTask(IModelLoader modelLoader, ILoadHelper loadHelper) {
            this.modelLoader = modelLoader;
            this.loadHelper = loadHelper;
        }

        public SmObjectImpl load(InputSource is) throws DuplicateObjectException, IOException {
            try {
                JsonNode jsTree = objectMapper.readTree(is.getByteStream());
                ObjIdName rootRef = this.readObjIdName(jsTree);
                SmObjectImpl rootObj = this.pushRootOBJECT(rootRef);
                ObjectNode content = (ObjectNode)jsTree.with("content");
                ArrayList<Map.Entry<JsonNode, SmObjectImpl>> loadedList = new ArrayList<Map.Entry<JsonNode, SmObjectImpl>>(content.size());
                for (JsonNode jsonNode : content) {
                    ObjIdName ref = this.readObjIdName(jsonNode);
                    try {
                        SmObjectImpl obj = this.pushObject(ref);
                        if (obj == null) continue;
                        ObjectNode attsNode = (ObjectNode)jsonNode.with("atts");
                        Iterator it = attsNode.fields();
                        while (it.hasNext()) {
                            Map.Entry attEn = (Map.Entry)it.next();
                            String attName = (String)attEn.getKey();
                            this.loadHelper.doLoadAtt(this.modelLoader, obj, attName, ((JsonNode)attEn.getValue()).asText());
                        }
                        loadedList.add(Map.entry(jsonNode, obj));
                        this.loadHelper.initObjectFlags(this.modelLoader, obj);
                    }
                    catch (IndexException e) {
                        this.loadHelper.loadFailed(rootObj, this.modelLoader, e);
                    }
                }
                for (Map.Entry entry : loadedList) {
                    this.loadObjDeps((JsonNode)entry.getKey(), (SmObjectImpl)entry.getValue());
                }
                return rootObj;
            }
            catch (IOException e) {
                String msg = is.getPublicId() + ": " + FileUtils.getLocalizedMessage((IOException)e);
                throw new IOException(msg, e);
            }
            catch (Error | RuntimeException e) {
                e.addSuppressed(new Throwable("Error occurred while reading '" + is.getPublicId() + "'"));
                throw e;
            }
        }

        protected ObjIdName readObjIdName(JsonNode jsTree) throws IOException {
            JsonNode nameNode = jsTree.get("name");
            String objName = nameNode != null ? nameNode.asText() : null;
            String mcName = jsTree.path("mc").asText();
            String uuid = jsTree.path("uuid").asText();
            if (mcName.isEmpty() || uuid.isEmpty()) {
                throw new IOException("Broken object identifier: " + jsTree.toPrettyString());
            }
            return new ObjIdName(this.loadHelper.getSmClass(mcName), objName, uuid);
        }

        private void loadObjDeps(JsonNode objNode, SmObjectImpl obj) throws IOException, DuplicateObjectException {
            ObjectNode depsNode = (ObjectNode)objNode.with("deps");
            HashSet<SmDependency> loadedDeps = new HashSet<SmDependency>(depsNode.size());
            SmObjectSmClass mc = obj.getClassOf();
            Iterator it = depsNode.fields();
            while (it.hasNext()) {
                boolean isTargetAlwaysInSameRepository;
                Map.Entry depEn = (Map.Entry)it.next();
                SmDependency dep = mc.getDependencyDef((String)depEn.getKey());
                JsonNode jsVals = (JsonNode)depEn.getValue();
                boolean bl = isTargetAlwaysInSameRepository = dep.isComposition() || dep.isCompositionOpposite() && !dep.getSymetric().isSharedComposition();
                if (!ExmlUtils.isDepToSerialize(dep)) {
                    Log.trace((String)"%s: Found non serializable %s dep with %d elements in %s in %s , ignore it .", (Object[])new Object[]{JsonModelParser.class.getSimpleName(), dep, jsVals.size(), obj, this.nodeStorageHandler});
                    continue;
                }
                loadedDeps.add(dep);
                ArrayList<SmObjectImpl> depVals = new ArrayList<SmObjectImpl>(jsVals.size());
                for (JsonNode valNode : jsVals) {
                    ObjIdName valRef = this.readObjIdName(valNode);
                    SmObjectImpl val = this.loadHelper.getLoadedObject(valRef.toObjId());
                    if (val == null) {
                        try {
                            if (isTargetAlwaysInSameRepository) {
                                val = this.loadHelper.createStubObject(this.modelLoader, valRef, true);
                                if (dep.isComposition() && valRef.classof.isCmsNode()) {
                                    ((ExmlStorageHandler)val.getRepositoryObject()).setParentLoaded(true);
                                }
                            } else {
                                val = this.loadHelper.getRefObject(this.modelLoader, valRef);
                            }
                        }
                        catch (IndexException | IllegalReferenceException e) {
                            this.loadHelper.loadFailed(obj, this.modelLoader, e);
                        }
                    }
                    if (val == null) continue;
                    depVals.add(val);
                }
                this.modelLoader.loadDependency(obj, dep, depVals);
            }
            for (SmDependency dep : ExmlUtils.getExternalisableDeps(obj)) {
                if (loadedDeps.contains(dep)) continue;
                this.modelLoader.loadDependency(obj, dep, Collections.emptyList());
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private SmObjectImpl pushObject(ObjIdName objidName) throws DuplicateObjectException, IndexException {
            ObjId objid = objidName.toObjId();
            SmObjectImpl obj = this.loadHelper.getLoadedObject(objid);
            if (obj == null) return this.loadHelper.createObject(this.modelLoader, objid, this.nodeStorageHandler);
            IRepositoryObject objHandler = obj.getRepositoryObject();
            if (objHandler == this.nodeStorageHandler) return obj;
            ObjId realParent = this.loadHelper.getCmsNodeId(objid);
            if (!realParent.equals(this.nodeStorageHandler.getCmsNodeId())) return null;
            obj.setRepositoryObject((IRepositoryObject)this.nodeStorageHandler);
            return obj;
        }

        private final SmObjectImpl pushRootOBJECT(ObjIdName objid) throws DuplicateObjectException {
            if (objid == null) {
                return null;
            }
            SmObjectImpl obj = this.loadHelper.getLoadedObject(objid.toObjId());
            if (obj != null) {
                assert (obj.getClassOf().isCmsNode());
                this.nodeStorageHandler = (ExmlStorageHandler)obj.getRepositoryObject();
                this.nodeStorageHandler.setLoaded(true);
            } else {
                obj = this.loadHelper.createObject(this.modelLoader, objid.toObjId(), null);
                assert (obj.getClassOf().isCmsNode());
                this.nodeStorageHandler = this.loadHelper.createStorageHandler(obj, true);
                obj.setRepositoryObject((IRepositoryObject)this.nodeStorageHandler);
            }
            return obj;
        }
    }
}

