/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.json.local;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vcore.model.DuplicateObjectException;
import org.modelio.vcore.session.impl.storage.IModelLoader;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vstore.exml.common.AbstractExmlRepository;
import org.modelio.vstore.exml.common.ExmlStorageHandler;
import org.modelio.vstore.exml.common.ILoadHelper;
import org.modelio.vstore.exml.common.LoadHelper;
import org.modelio.vstore.exml.common.index.IndexException;
import org.modelio.vstore.exml.common.model.ObjId;
import org.modelio.vstore.exml.json.common.JsonModelParser;
import org.modelio.vstore.exml.json.local.JsStoreSaver;
import org.modelio.vstore.exml.resource.IExmlResourceProvider;
import org.xml.sax.InputSource;

public class JsBase
extends AbstractExmlRepository {
    private ILoadHelper loadHelper;

    public JsBase(IExmlResourceProvider resProvider) {
        super(resProvider);
    }

    public JsBase(Path path, String name) throws IOException {
        super(path, path, name);
    }

    @Override
    public synchronized void doReloadCmsNode(SmObjectImpl obj, IModelLoader modelLoader) throws DuplicateObjectException, IOException, IndexException {
        ObjId cmsNodeId = new ObjId(obj);
        IExmlResourceProvider.ExmlResource resource = this.getResourceProvider().getResource(cmsNodeId);
        if (resource == null) {
            throw new FileNotFoundException(cmsNodeId.toString());
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream is = resource.bufferedRead();){
            if (is == null) {
                throw new FileNotFoundException(resource.getPublicLocation());
            }
            InputSource isrc = new InputSource(is);
            isrc.setPublicId(resource.getPublicLocation());
            new JsonModelParser(this.getloadHelper()).load(isrc, modelLoader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected ILoadHelper getloadHelper() {
        return this.loadHelper;
    }

    @Override
    protected void initializeLoader() {
        this.loadHelper = new LoadHelper(this, this.isWriteable());
    }

    @Override
    protected void save(ExmlStorageHandler handler, IModelioProgress progress) throws IOException {
        SmObjectImpl cmsNode = handler.getCmsNode();
        ObjId cmsNodeId = handler.getCmsNodeId();
        Throwable throwable = null;
        Object var6_7 = null;
        try (OutputStream os = this.getResourceProvider().getResource(cmsNodeId).bufferedWrite();){
            JsStoreSaver saver = new JsStoreSaver();
            saver.externalize(cmsNode, os);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

