/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.json.local;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.mapi.MObject;
import org.modelio.vcore.smkernel.meta.SmAttribute;
import org.modelio.vcore.smkernel.meta.SmDependency;
import org.modelio.vstore.exml.common.utils.ExmlUtils;

class JsStoreSaver {
    private static final int FORMAT_VERSION = 1;
    private JsonGenerator out;
    private Queue<SmObjectImpl> queue = new ArrayDeque<SmObjectImpl>();

    JsStoreSaver() {
    }

    public void externalize(SmObjectImpl object, OutputStream os) throws IOException {
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (JsonGenerator closeableWriter = JsonFactory.builder().build().createGenerator(os);){
                this.out = closeableWriter;
                this.out.writeStartObject();
                this.dumpEXT(object);
                this.out.writeEndObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.out = null;
        }
    }

    private final void dumpOBJECT(SmObjectImpl object, Collection<SmObjectImpl> recursionContext) throws IOException {
        if (recursionContext.contains(object)) {
            return;
        }
        recursionContext.add(object);
        this.out.writeFieldName(object.getUuid());
        this.out.writeStartObject();
        this.dumpIDFields((MObject)object);
        this.dumpATTRIBUTES(object);
        this.dumpDEPENDENCIES(object, recursionContext);
        this.out.writeEndObject();
    }

    private void dumpATT(SmObjectImpl object, SmAttribute att) throws IOException {
        Object attVal = object.getAttVal(att);
        if (attVal != null) {
            this.out.writeFieldName(att.getName());
            Class type = att.getType();
            if (type == Long.class) {
                this.out.writeNumber(((Long)attVal).longValue());
            } else if (type == Short.class) {
                this.out.writeNumber(((Short)attVal).shortValue());
            } else if (type == Integer.class) {
                this.out.writeNumber(((Integer)attVal).intValue());
            } else if (type == String.class) {
                this.out.writeString(attVal.toString());
            } else if (type == Float.class) {
                this.out.writeNumber(((Float)attVal).floatValue());
            } else if (type == Double.class) {
                this.out.writeNumber(((Double)attVal).doubleValue());
            } else if (Enum.class.isAssignableFrom(type)) {
                this.out.writeString(attVal.toString());
            } else if (type == Boolean.class) {
                this.out.writeBoolean(((Boolean)attVal).booleanValue());
            } else {
                throw new IllegalArgumentException(String.format("'%s' value of type '%s' not supported", attVal, type.getName()));
            }
        }
    }

    private void dumpATTRIBUTES(SmObjectImpl object) throws IOException {
        this.out.writeFieldName("atts");
        this.out.writeStartObject();
        for (SmAttribute att : object.getClassOf().getAllAttDef()) {
            this.dumpATT(object, att);
        }
        this.out.writeEndObject();
    }

    private void dumpCOMPS(SmObjectImpl object, SmDependency dep, List<SmObjectImpl> targets, Collection<SmObjectImpl> recursionContext) throws IOException {
        this.out.writeFieldName(dep.getName());
        this.out.writeStartArray();
        for (SmObjectImpl t : targets) {
            this.dumpID((MObject)t);
            if (t.getRepositoryObject() != object.getRepositoryObject() || recursionContext.contains(t)) continue;
            this.queue.add(t);
        }
        this.out.writeEndArray();
    }

    private void dumpDEPENDENCIES(SmObjectImpl object, Collection<SmObjectImpl> recursionContext) throws IOException {
        this.out.writeObjectFieldStart("deps");
        List<SmDependency> dependencies = ExmlUtils.getExternalisableDeps(object);
        for (SmDependency dep : dependencies) {
            List content = object.getDepValList(dep);
            if (content.isEmpty()) continue;
            if (ExmlUtils.isDepComponent(dep)) {
                this.dumpCOMPS(object, dep, content, recursionContext);
                continue;
            }
            this.dumpLINKS(object, dep, content);
        }
        this.out.writeEndObject();
    }

    private void dumpEXT(SmObjectImpl object) throws IOException {
        this.out.writeFieldName("metadatas");
        this.out.writeStartObject();
        this.out.writeStringField("comment", "GENERATED FILE, PLEASE DO NOT EDIT!!!");
        this.out.writeStringField("name", object.getName());
        this.out.writeNumberField("format-version", 1);
        this.out.writeEndObject();
        this.dumpIDFields((MObject)object);
        this.out.writeFieldName("content");
        this.out.writeStartObject();
        HashSet<SmObjectImpl> doneSet = new HashSet<SmObjectImpl>();
        this.dumpOBJECT(object, doneSet);
        while (!this.queue.isEmpty()) {
            this.dumpOBJECT(this.queue.remove(), doneSet);
        }
        this.out.writeEndObject();
    }

    private void dumpID(MObject object) throws IOException {
        this.out.writeStartObject();
        this.dumpIDFields(object);
        this.out.writeEndObject();
    }

    private void dumpIDFields(MObject object) throws IOException {
        this.out.writeStringField("name", Objects.toString(object.getName(), ""));
        this.out.writeStringField("mc", object.getMClass().getQualifiedName());
        this.out.writeStringField("uuid", object.getUuid().toString());
    }

    private void dumpLINKS(SmObjectImpl object, SmDependency dep, List<SmObjectImpl> targets) throws IOException {
        this.out.writeFieldName(dep.getName());
        this.out.writeStartArray();
        for (SmObjectImpl t : targets) {
            this.dumpID((MObject)t);
        }
        this.out.writeEndArray();
    }
}

