/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.local;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import org.modelio.vbasic.progress.IModelioProgress;
import org.modelio.vcore.model.DuplicateObjectException;
import org.modelio.vcore.session.impl.storage.IModelLoader;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vstore.exml.common.AbstractExmlRepository;
import org.modelio.vstore.exml.common.ExmlStorageHandler;
import org.modelio.vstore.exml.common.ILoadHelper;
import org.modelio.vstore.exml.common.LoadHelper;
import org.modelio.vstore.exml.common.index.IndexException;
import org.modelio.vstore.exml.common.model.ObjId;
import org.modelio.vstore.exml.local.loader.IExmlLoader;
import org.modelio.vstore.exml.local.loader.sax.SaxExmlLoader;
import org.modelio.vstore.exml.local.save.ExmlSaver;
import org.modelio.vstore.exml.resource.IExmlResourceProvider;
import org.xml.sax.InputSource;

public class ExmlBase
extends AbstractExmlRepository {
    private ILoadHelper loadHelper;
    private IExmlLoader loader;

    public ExmlBase(IExmlResourceProvider resProvider) {
        super(resProvider);
    }

    @Deprecated
    public ExmlBase(Path path) throws IOException {
        super(path, path, path.toString());
    }

    public ExmlBase(Path path, String name) throws IOException {
        super(path, path, name);
    }

    @Override
    public synchronized void doReloadCmsNode(SmObjectImpl obj, IModelLoader modelLoader) throws DuplicateObjectException, IOException, IndexException {
        ObjId cmsNodeId = new ObjId(obj);
        IExmlResourceProvider.ExmlResource resource = this.getResourceProvider().getResource(cmsNodeId);
        if (resource == null) {
            throw new FileNotFoundException(cmsNodeId.toString());
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream is = resource.bufferedRead();){
            if (is == null) {
                throw new FileNotFoundException(resource.getPublicLocation());
            }
            InputSource isrc = new InputSource(is);
            isrc.setPublicId(resource.getPublicLocation());
            this.loader.load(isrc, modelLoader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected ILoadHelper getloadHelper() {
        return this.loadHelper;
    }

    @Override
    protected void initializeLoader() {
        this.loadHelper = new LoadHelper(this, this.isWriteable());
        this.loader = new SaxExmlLoader(this.loadHelper);
    }

    @Override
    protected void save(ExmlStorageHandler handler, IModelioProgress progress) throws IOException {
        SmObjectImpl cmsNode = handler.getCmsNode();
        ObjId cmsNodeId = handler.getCmsNodeId();
        Throwable throwable = null;
        Object var6_7 = null;
        try (OutputStream os = this.getResourceProvider().getResource(cmsNodeId).bufferedWrite();){
            ExmlSaver saver = new ExmlSaver(this.getErrorSupport());
            saver.externalize(cmsNode, os);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

