/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.local.loader.sax;

import java.io.IOException;
import java.text.MessageFormat;
import org.modelio.vbasic.files.FileUtils;
import org.modelio.vcore.model.DuplicateObjectException;
import org.modelio.vcore.smkernel.meta.SmClass;
import org.modelio.vstore.exml.common.model.ExmlTags;
import org.modelio.vstore.exml.common.model.ObjIdName;
import org.modelio.vstore.exml.local.loader.sax.DataModel;
import org.modelio.vstore.exml.local.loader.sax.DocumentContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractState
implements ExmlTags {
    protected DocumentContentHandler stateHandler;

    protected AbstractState() {
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
    }

    public String toString() {
        return this.getClass().getSimpleName() + " state";
    }

    public void setStateHandler(DocumentContentHandler value) {
        this.stateHandler = value;
    }

    protected final DataModel getDataModel() {
        return this.stateHandler.getDataModel();
    }

    protected final ObjIdName readID(Attributes att) {
        String xname = att.getValue("name");
        String xclassof = att.getValue("mc");
        String xuid = att.getValue("uid");
        SmClass classof = this.getDataModel().getSmClass(xclassof);
        if (classof == null) {
            String msg = MessageFormat.format("''{2}'' {0} {1} : Unknown {0} metaclass.", xclassof, xuid, xname);
            this.stateHandler.warning(new SAXParseException(msg, this.stateHandler.getLocator()));
            return null;
        }
        return new ObjIdName(classof, xname, xuid);
    }

    protected final void rethrowException(Exception e) throws SAXParseException {
        String msg;
        if (e instanceof IOException) {
            msg = FileUtils.getLocalizedMessage((IOException)((IOException)e));
        } else if (e instanceof DuplicateObjectException) {
            msg = e.getLocalizedMessage();
        } else if (e instanceof RuntimeException) {
            msg = e.toString();
        } else {
            msg = e.getLocalizedMessage();
            if (msg == null || msg.isEmpty() || msg.equals("null")) {
                msg = e.toString();
            }
        }
        throw new SAXParseException(msg, this.stateHandler.getLocator(), e);
    }

    protected void throwInvalidTag(String localName) throws SAXParseException {
        throw new SAXParseException("Invalid '" + localName + "' tag.", this.stateHandler.getLocator());
    }
}

