/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.vstore.exml.local.loader.sax;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.modelio.vcore.model.DuplicateObjectException;
import org.modelio.vcore.session.impl.storage.IModelLoader;
import org.modelio.vcore.smkernel.IRepositoryObject;
import org.modelio.vcore.smkernel.SmObjectImpl;
import org.modelio.vcore.smkernel.meta.SmClass;
import org.modelio.vstore.exml.common.ExmlStorageHandler;
import org.modelio.vstore.exml.common.ILoadHelper;
import org.modelio.vstore.exml.common.index.IndexException;
import org.modelio.vstore.exml.common.model.ExmlTags;
import org.modelio.vstore.exml.common.model.IllegalReferenceException;
import org.modelio.vstore.exml.common.model.ObjId;
import org.modelio.vstore.exml.common.model.ObjIdName;
import org.modelio.vstore.exml.local.loader.sax.DummyObjectDataModel;
import org.modelio.vstore.exml.local.loader.sax.IDependencyContentHook;
import org.modelio.vstore.exml.local.loader.sax.IObjectDataModel;
import org.modelio.vstore.exml.local.loader.sax.ObjectDataModel;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

class DataModel
implements ExmlTags {
    private int version;
    ExmlStorageHandler nodeStorageHandler;
    final ILoadHelper loadHelper;
    IModelLoader modelLoader;
    private IObjectDataModel currentModel;
    private final Deque<IObjectDataModel> objStack;
    private Locator locator;
    private SmObjectImpl rootObject;
    static final List<SmObjectImpl> EMPTY_DEP = Collections.emptyList();
    IDependencyContentHook depContentHook;

    public DataModel(ILoadHelper loadHelper) {
        this.loadHelper = loadHelper;
        this.objStack = new ArrayDeque<IObjectDataModel>(30);
    }

    public IObjectDataModel getCurrent() {
        return this.currentModel;
    }

    public SmObjectImpl getRootObject() {
        return this.rootObject;
    }

    public void initObjectFlags() {
        this.loadHelper.initObjectFlags(this.modelLoader, this.currentModel.getObject());
    }

    public void reset() {
        this.locator = null;
        this.objStack.clear();
        this.currentModel = null;
        this.rootObject = null;
    }

    void addDepRef(ObjIdName ref) throws DuplicateObjectException, IllegalReferenceException, IndexException {
        this.getCurrent().addRefToDep(ref);
    }

    Locator getLocator() {
        return this.locator;
    }

    int getVersion() {
        return this.version;
    }

    void loadAtt(String attName, String string) {
        this.loadHelper.doLoadAtt(this.modelLoader, this.currentModel.getObject(), attName, string);
    }

    void myassert(boolean b) throws AssertionError {
        if (!b) {
            SAXParseException cause = new SAXParseException("assertion failed", this.getLocator());
            throw new AssertionError(cause.getMessage(), cause);
        }
    }

    void myassert(boolean b, String msg) {
        if (!b) {
            SAXParseException cause = new SAXParseException(msg, this.getLocator());
            throw new AssertionError(cause.getMessage(), cause);
        }
    }

    IObjectDataModel pop() {
        IObjectDataModel previous = this.objStack.pop();
        this.currentModel = this.objStack.peek();
        return previous;
    }

    final SmObjectImpl pushObject(ObjIdName objidName) throws SAXParseException {
        ObjId objid = objidName.toObjId();
        if (this.rootObject == null) {
            return this.pushRootOBJECT(objidName);
        }
        boolean isNew = false;
        SmObjectImpl obj = this.loadHelper.getLoadedObject(objid);
        if (obj != null) {
            this.pushAlreadyLoadedObject(objid, obj, isNew);
        } else if (this.loadHelper.isStored(objid)) {
            try {
                obj = this.loadHelper.createObject(this.modelLoader, objid, this.nodeStorageHandler);
                isNew = true;
                this.currentModel = new ObjectDataModel(this, obj, isNew);
            }
            catch (DuplicateObjectException e) {
                if (this.loadHelper.getLoadedObject(objid) == e.getOriginalObj()) {
                    obj = (SmObjectImpl)e.getOriginalObj();
                    this.pushAlreadyLoadedObject(objid, obj, isNew);
                }
                throw new SAXParseException(e.getLocalizedMessage(), this.getLocator(), (Exception)((Object)e));
            }
        } else {
            obj = this.loadHelper.getForeignObject(this.modelLoader, objidName);
            this.currentModel = new DummyObjectDataModel(obj);
        }
        this.objStack.push(this.currentModel);
        return obj;
    }

    private void pushAlreadyLoadedObject(ObjId objid, SmObjectImpl obj, boolean isNew) throws SAXParseException {
        IRepositoryObject objHandler = obj.getRepositoryObject();
        if (objHandler != this.nodeStorageHandler) {
            ObjId realParent = this.getCmsNodeId(objid);
            if (realParent.equals(this.nodeStorageHandler.getCmsNodeId())) {
                obj.setRepositoryObject((IRepositoryObject)this.nodeStorageHandler);
            } else {
                this.currentModel = new DummyObjectDataModel(obj);
            }
        }
        this.currentModel = new ObjectDataModel(this, obj, isNew);
    }

    private final SmObjectImpl pushRootOBJECT(ObjIdName objid) throws SAXParseException {
        if (objid == null) {
            return null;
        }
        boolean isNew = false;
        SmObjectImpl obj = this.loadHelper.getLoadedObject(objid.toObjId());
        if (obj != null) {
            assert (obj.getClassOf().isCmsNode());
            this.nodeStorageHandler = (ExmlStorageHandler)obj.getRepositoryObject();
            this.nodeStorageHandler.setLoaded(true);
        } else {
            try {
                obj = this.loadHelper.createObject(this.modelLoader, objid.toObjId(), null);
            }
            catch (DuplicateObjectException e) {
                throw new SAXParseException(e.getLocalizedMessage(), this.getLocator(), (Exception)((Object)e));
            }
            assert (obj.getClassOf().isCmsNode());
            this.nodeStorageHandler = this.loadHelper.createStorageHandler(obj, true);
            obj.setRepositoryObject((IRepositoryObject)this.nodeStorageHandler);
            isNew = true;
        }
        this.currentModel = new ObjectDataModel(this, obj, isNew);
        this.objStack.push(this.currentModel);
        this.rootObject = obj;
        return obj;
    }

    void setDocumentLocator(Locator aLocator) {
        this.locator = aLocator;
    }

    public final void setModelLoader(IModelLoader modelLoader) {
        this.modelLoader = modelLoader;
    }

    void setVersion(int v) {
        this.version = v;
    }

    public void setDependencyContentHook(IDependencyContentHook depContentHook) {
        this.depContentHook = depContentHook;
    }

    SmClass getSmClass(String xclassof) {
        return this.loadHelper.getSmClass(xclassof);
    }

    private ObjId getCmsNodeId(ObjId objid) throws SAXParseException {
        try {
            return this.loadHelper.getCmsNodeId(objid);
        }
        catch (IndexException e) {
            throw new SAXParseException(e.getLocalizedMessage(), this.getLocator(), e);
        }
    }
}

